/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.fec.AbstractFECReceiver;
import org.jitsi.impl.neomedia.transform.fec.FECSender;
import org.jitsi.impl.neomedia.transform.fec.FlexFec03Receiver;
import org.jitsi.impl.neomedia.transform.fec.ULPFECReceiver;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.logging.Logger;

public class FECTransformEngine
implements TransformEngine,
PacketTransformer {
    private static final Logger logger = Logger.getLogger(FECTransformEngine.class);
    public static final int INITIAL_BUFFER_SIZE = 1500;
    private byte incomingPT = (byte)-1;
    protected FecType fecType;
    private byte outgoingPT = (byte)-1;
    private int fecRate = 0;
    private final Map<Long, AbstractFECReceiver> fecReceivers = new HashMap<Long, AbstractFECReceiver>();
    private final Map<Long, FECSender> fecSenders = new HashMap<Long, FECSender>();
    private final MediaStream mediaStream;

    public FECTransformEngine(FecType fecType, byte incomingPT, byte outgoingPT, MediaStream mediaStream) {
        this.fecType = fecType;
        this.mediaStream = mediaStream;
        this.setIncomingPT(incomingPT);
        this.setOutgoingPT(outgoingPT);
    }

    private long getPrimarySsrc(Long ssrc) {
        if (ssrc == null) {
            return -1L;
        }
        MediaStreamTrackReceiver receiver = this.mediaStream.getMediaStreamTrackReceiver();
        if (receiver == null) {
            return -1L;
        }
        RTPEncodingDesc encoding = receiver.findRTPEncodingDesc(ssrc);
        if (encoding == null) {
            return -1L;
        }
        return encoding.getPrimarySSRC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        AbstractFECReceiver fecReceiver;
        if (this.incomingPT == -1 || pkts == null) {
            return pkts;
        }
        Long ssrc = this.findSSRC(pkts);
        long primarySsrc = this.getPrimarySsrc(ssrc);
        if (primarySsrc == -1L) {
            return pkts;
        }
        Map<Long, AbstractFECReceiver> map = this.fecReceivers;
        synchronized (map) {
            fecReceiver = this.fecReceivers.get(primarySsrc);
            if (fecReceiver == null) {
                if (this.fecType == FecType.ULPFEC) {
                    fecReceiver = new ULPFECReceiver(primarySsrc, this.incomingPT);
                } else if (this.fecType == FecType.FLEXFEC_03) {
                    fecReceiver = new FlexFec03Receiver(primarySsrc, this.incomingPT);
                } else {
                    logger.error((Object)("Unknown fec type set: " + (Object)((Object)this.fecType)));
                    return pkts;
                }
                this.fecReceivers.put(primarySsrc, fecReceiver);
            }
        }
        return fecReceiver.reverseTransform(pkts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        FECSender fpt;
        if (this.outgoingPT == -1 || pkts == null) {
            return pkts;
        }
        Long ssrc = this.findSSRC(pkts);
        if (ssrc == null) {
            return pkts;
        }
        Map<Long, FECSender> map = this.fecSenders;
        synchronized (map) {
            fpt = this.fecSenders.get(ssrc);
            if (fpt == null) {
                fpt = new FECSender(ssrc, this.fecRate, this.outgoingPT);
                this.fecSenders.put(ssrc, fpt);
            }
        }
        return fpt.transform(pkts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Collection<FECSender> senders;
        Collection<AbstractFECReceiver> receivers;
        Iterator<FECSender> iterator = this.fecReceivers;
        synchronized (iterator) {
            receivers = this.fecReceivers.values();
            this.fecReceivers.clear();
        }
        iterator = this.fecSenders;
        synchronized (iterator) {
            senders = this.fecSenders.values();
            this.fecSenders.clear();
        }
        for (AbstractFECReceiver fecReceiver : receivers) {
            fecReceiver.close();
        }
        for (FECSender fecSender : senders) {
            fecSender.close();
        }
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncomingPT(byte incomingPT) {
        this.incomingPT = incomingPT;
        Map<Long, AbstractFECReceiver> map = this.fecReceivers;
        synchronized (map) {
            for (AbstractFECReceiver f : this.fecReceivers.values()) {
                f.setPayloadType(incomingPT);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting payload type for incoming ulpfec: " + incomingPT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutgoingPT(byte outgoingPT) {
        this.outgoingPT = outgoingPT;
        Map<Long, FECSender> map = this.fecSenders;
        synchronized (map) {
            for (FECSender f : this.fecSenders.values()) {
                f.setUlpfecPT(outgoingPT);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting payload type for outgoing ulpfec: " + outgoingPT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFecRate(int fecRate) {
        Map<Long, FECSender> map = this.fecSenders;
        synchronized (map) {
            for (FECSender f : this.fecSenders.values()) {
                f.setFecRate(fecRate);
            }
        }
        this.fecRate = fecRate;
    }

    public int getFecRate() {
        return this.fecRate;
    }

    private Long findSSRC(RawPacket[] pkts) {
        Long ret = null;
        if (pkts != null) {
            for (RawPacket p : pkts) {
                if (p == null) continue;
                ret = p.getSSRCAsLong();
                break;
            }
        }
        return ret;
    }

    public static enum FecType {
        ULPFEC,
        FLEXFEC_03;

    }
}

