/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.terminal.session.TerminalBlocksModelState;
import com.intellij.terminal.session.TerminalOutputBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockFinishedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockRemovedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockStartedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModelEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0007H\u0002J\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/editor/Document;)V", "blockIdCounter", "", "getBlockIdCounter", "()I", "setBlockIdCounter", "(I)V", "blocks", "", "Lcom/intellij/terminal/session/TerminalOutputBlock;", "getBlocks", "()Ljava/util/List;", "mutableEventsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelEvent;", "events", "Lkotlinx/coroutines/flow/SharedFlow;", "getEvents", "()Lkotlinx/coroutines/flow/SharedFlow;", "promptStarted", "", "offset", "promptFinished", "commandStarted", "commandFinished", "exitCode", "dumpState", "Lcom/intellij/terminal/session/TerminalBlocksModelState;", "restoreFromState", "state", "trimBlocksBefore", "trimBlocksAfter", "createNewBlock", "startOffset", "toString", "", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalBlocksModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlocksModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1#2:176\n360#3,7:177\n360#3,7:184\n*S KotlinDebug\n*F\n+ 1 TerminalBlocksModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelImpl\n*L\n113#1:177,7\n149#1:184,7\n*E\n"})
public final class TerminalBlocksModelImpl
implements TerminalBlocksModel {
    @NotNull
    private final Document document;
    @VisibleForTesting
    private int blockIdCounter;
    @NotNull
    private final List<TerminalOutputBlock> blocks;
    @NotNull
    private final MutableSharedFlow<TerminalBlocksModelEvent> mutableEventsFlow;
    @NotNull
    private final SharedFlow<TerminalBlocksModelEvent> events;

    public TerminalBlocksModelImpl(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.blocks = new ArrayList();
        this.mutableEventsFlow = SharedFlowKt.MutableSharedFlow$default((int)Integer.MAX_VALUE, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.events = FlowKt.asSharedFlow(this.mutableEventsFlow);
        this.document.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOffset() == 0 && event.getNewLength() == 0) {
                    this.trimBlocksBefore(event.getOldLength());
                } else {
                    this.trimBlocksAfter(event.getOffset());
                }
            }
        });
        TerminalOutputBlock newBlock = this.createNewBlock(0);
        this.getBlocks().add(newBlock);
        this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(newBlock));
    }

    public final int getBlockIdCounter() {
        return this.blockIdCounter;
    }

    public final void setBlockIdCounter(int n) {
        this.blockIdCounter = n;
    }

    @Override
    @NotNull
    public List<TerminalOutputBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    @NotNull
    public SharedFlow<TerminalBlocksModelEvent> getEvents() {
        return this.events;
    }

    @Override
    public void promptStarted(int offset) {
        TerminalOutputBlock lastBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        if (offset == lastBlock.getStartOffset()) {
            CollectionsKt.removeLast(this.getBlocks());
            v0 = this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(lastBlock));
        } else {
            TerminalOutputBlock updatedBlock = TerminalOutputBlock.copy$default((TerminalOutputBlock)lastBlock, (int)0, (int)0, (int)0, (int)0, (int)offset, null, (int)47, null);
            this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), updatedBlock);
            v0 = this.mutableEventsFlow.tryEmit((Object)new TerminalBlockFinishedEvent(updatedBlock));
        }
        TerminalOutputBlock newBlock = this.createNewBlock(offset);
        this.getBlocks().add(newBlock);
        this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(newBlock));
    }

    @Override
    public void promptFinished(int offset) {
        TerminalOutputBlock curBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), TerminalOutputBlock.copy$default((TerminalOutputBlock)curBlock, (int)0, (int)0, (int)offset, (int)0, (int)0, null, (int)59, null));
    }

    @Override
    public void commandStarted(int offset) {
        TerminalOutputBlock curBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), TerminalOutputBlock.copy$default((TerminalOutputBlock)curBlock, (int)0, (int)0, (int)0, (int)offset, (int)0, null, (int)55, null));
    }

    @Override
    public void commandFinished(int exitCode) {
        TerminalOutputBlock curBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), TerminalOutputBlock.copy$default((TerminalOutputBlock)curBlock, (int)0, (int)0, (int)0, (int)0, (int)0, (Integer)exitCode, (int)31, null));
    }

    @Override
    @NotNull
    public TerminalBlocksModelState dumpState() {
        return new TerminalBlocksModelState(CollectionsKt.toList((Iterable)this.getBlocks()), this.blockIdCounter);
    }

    @Override
    public void restoreFromState(@NotNull TerminalBlocksModelState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(!((Collection)state.getBlocks()).isEmpty())) {
            boolean bl = false;
            String string = "There should be always at least one block in the blocks model state";
            throw new IllegalStateException(string.toString());
        }
        this.blockIdCounter = state.getBlockIdCounter();
        for (TerminalOutputBlock terminalOutputBlock : this.getBlocks()) {
            this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(terminalOutputBlock));
        }
        this.getBlocks().clear();
        List finishedBlocks = state.getBlocks().subList(0, state.getBlocks().size() - 1);
        for (TerminalOutputBlock block : finishedBlocks) {
            this.getBlocks().add(block);
            this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(block));
            this.mutableEventsFlow.tryEmit((Object)new TerminalBlockFinishedEvent(block));
        }
        TerminalOutputBlock terminalOutputBlock = (TerminalOutputBlock)CollectionsKt.last((List)state.getBlocks());
        this.getBlocks().add(terminalOutputBlock);
        this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(terminalOutputBlock));
    }

    private final void trimBlocksBefore(int offset) {
        int firstNotRemovedBlockIndex;
        block11: {
            int n;
            List<TerminalOutputBlock> $this$indexOfFirst$iv = this.getBlocks();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<TerminalOutputBlock> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                TerminalOutputBlock item$iv;
                TerminalOutputBlock it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getEndOffset() > offset) {
                    n = index$iv;
                    break block11;
                }
                ++index$iv;
            }
            n = firstNotRemovedBlockIndex = -1;
        }
        if (firstNotRemovedBlockIndex != -1) {
            int it;
            int $this$indexOfFirst$iv = 0;
            while ($this$indexOfFirst$iv < firstNotRemovedBlockIndex) {
                it = $this$indexOfFirst$iv++;
                boolean bl = false;
                TerminalOutputBlock block = (TerminalOutputBlock)CollectionsKt.removeFirst(this.getBlocks());
                this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(block));
            }
            it = ((Collection)this.getBlocks()).size();
            for (int ind = 0; ind < it; ++ind) {
                int n;
                int n2;
                TerminalOutputBlock block = this.getBlocks().get(ind);
                List<TerminalOutputBlock> list = this.getBlocks();
                int n3 = block.getId();
                int n4 = block.getStartOffset() - offset;
                int n5 = 0;
                int n6 = Math.max(n4, n5);
                if (block.getCommandStartOffset() != -1) {
                    n4 = block.getCommandStartOffset() - offset;
                    n5 = 0;
                    n2 = Math.max(n4, n5);
                } else {
                    n2 = -1;
                }
                if (block.getOutputStartOffset() != -1) {
                    n4 = block.getOutputStartOffset() - offset;
                    n5 = 0;
                    n = Math.max(n4, n5);
                } else {
                    n = -1;
                }
                n4 = block.getEndOffset() - offset;
                n5 = 0;
                list.set(ind, new TerminalOutputBlock(n3, n6, n2, n, Math.max(n4, n5), block.getExitCode()));
            }
        } else {
            for (TerminalOutputBlock block : this.getBlocks()) {
                this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(block));
            }
            this.getBlocks().clear();
            TerminalOutputBlock newBlock = this.createNewBlock(0);
            this.getBlocks().add(newBlock);
            this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(newBlock));
        }
    }

    private final void trimBlocksAfter(int offset) {
        int firstBlockToRemoveIndex;
        block4: {
            int n;
            List<TerminalOutputBlock> $this$indexOfFirst$iv = this.getBlocks();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<TerminalOutputBlock> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                TerminalOutputBlock item$iv;
                TerminalOutputBlock it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getStartOffset() > offset) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = firstBlockToRemoveIndex = -1;
        }
        if (firstBlockToRemoveIndex != -1) {
            int $this$indexOfFirst$iv = this.getBlocks().size() - firstBlockToRemoveIndex;
            int n = 0;
            while (n < $this$indexOfFirst$iv) {
                int it = n++;
                boolean bl = false;
                TerminalOutputBlock block = (TerminalOutputBlock)CollectionsKt.removeLast(this.getBlocks());
                this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(block));
            }
        }
        TerminalOutputBlock lastBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), TerminalOutputBlock.copy$default((TerminalOutputBlock)lastBlock, (int)0, (int)0, (int)0, (int)0, (int)this.document.getTextLength(), null, (int)47, null));
    }

    private final TerminalOutputBlock createNewBlock(int startOffset) {
        int n = this.blockIdCounter;
        this.blockIdCounter = n + 1;
        return new TerminalOutputBlock(n, startOffset, -1, -1, this.document.getTextLength(), null);
    }

    @NotNull
    public String toString() {
        return "TerminalBlocksModelImpl(blocks=" + this.getBlocks() + ")";
    }
}

