/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.outputs.error;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.kotlin.jupyter.core.jupyter.outputs.error.CellHighlightInfo;
import com.intellij.kotlin.jupyter.core.jupyter.outputs.error.KotlinCellHyperlinkInfo;
import com.intellij.kotlin.jupyter.core.jupyter.outputs.error.KotlinStacktraceUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/outputs/error/KotlinNotebookLineLinkFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "dispose", "", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookLineLinkFilter
implements Filter,
DumbAware,
Disposable {
    @NotNull
    private final EditorImpl editor;

    public KotlinNotebookLineLinkFilter(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public void dispose() {
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        CellHighlightInfo cellHighlightInfo = KotlinStacktraceUtilsKt.linkifyStackLine(line, entireLength);
        if (cellHighlightInfo == null) {
            return null;
        }
        CellHighlightInfo stackLineInfo = cellHighlightInfo;
        KotlinCellHyperlinkInfo hyperlinkInfo = new KotlinCellHyperlinkInfo(stackLineInfo.getExecutionCount(), stackLineInfo.getCellLine(), this);
        return new Filter.Result(stackLineInfo.getHighlightRange().getFirst(), stackLineInfo.getHighlightRange().getLast(), (HyperlinkInfo)hyperlinkInfo);
    }
}

