/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.variables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsToolWindowPanel;
import com.intellij.kotlin.jupyter.core.debug.KotlinNotebookDebugEditorsProvider;
import com.intellij.kotlin.jupyter.core.debug.frame.KotlinNotebookVariablesFrame;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSession;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.kotlin.jupyter.core.debug.util.DebugSupportUtilsKt;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.variables.NotebookVariablesToolWindowSetup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kotlin/jupyter/core/variables/KotlinNotebookVarsToolWindow;", "Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "panelSetupData", "Lcom/intellij/kotlin/jupyter/core/variables/NotebookVariablesToolWindowSetup;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/kotlin/jupyter/core/variables/NotebookVariablesToolWindowSetup;)V", "shouldBeAddedOnTopLevel", "", "getShouldBeAddedOnTopLevel", "()Z", "getName", "", "initVariablesView", "", "createPanelContent", "Lcom/intellij/ui/content/Content;", "createContent", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookVarsToolWindow
extends JupyterVarsToolWindowPanel {
    @NotNull
    private final NotebookVariablesToolWindowSetup panelSetupData;
    private final boolean shouldBeAddedOnTopLevel;

    public KotlinNotebookVarsToolWindow(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, @NotNull NotebookVariablesToolWindowSetup panelSetupData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)panelSetupData, (String)"panelSetupData");
        super(project, notebookFile);
        this.panelSetupData = panelSetupData;
    }

    public boolean getShouldBeAddedOnTopLevel() {
        return this.shouldBeAddedOnTopLevel;
    }

    @NotNull
    public String getName() {
        return KotlinNotebookBundle.message("kotlin.jupyter.toolbar.tabs.variables", new Object[0]);
    }

    protected void initVariablesView() {
        if (this.getProject().isDisposed() || !DebugSupportUtilsKt.getShouldShowNotebookVariables(this.getProject())) {
            this.showMessage(KotlinNotebookBundle.message("kotlin.jupyter.debug.node.default.message", new Object[0]));
            return;
        }
        if (!this.panelSetupData.isEnabled()) {
            this.showMessage(KotlinNotebookBundle.message("kotlin.jupyter.debug.node.not.enabled.message", new Object[0]));
            return;
        }
        this.removeAll();
        KotlinNotebookDebugSession debugManager = KotlinNotebookDebugSessionManager.Companion.getForFile(this.getProject(), this.getNotebookFile());
        KotlinNotebookVariablesFrame stackFrame = new KotlinNotebookVariablesFrame(this.getProject(), null, debugManager);
        this.removeClickListener();
        this.setVariablesView(new XStandaloneVariablesView(this.getProject(), (XDebuggerEditorsProvider)new KotlinNotebookDebugEditorsProvider(), (XStackFrame)stackFrame));
        XStandaloneVariablesView viewReference = this.getVariablesView();
        if (viewReference == null) {
            return;
        }
        PopupHandler.installPopupMenu((JComponent)((JComponent)viewReference.getTree()), (String)"Notebook.XDebugger.StateValueGroup", (String)"XDebuggerTreePopup");
        this.add(viewReference.getPanel(), "Center");
        this.setClickListener(new ClickListener(this){
            final /* synthetic */ KotlinNotebookVarsToolWindow this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.logViewUsage();
                return false;
            }
        });
        ListenerUtil.addClickListener((Component)viewReference.getPanel(), (ClickListener)this.getClickListener());
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)viewReference));
        this.add(viewReference.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    @NotNull
    public Content createPanelContent() {
        return this.createContent();
    }

    @NotNull
    public final Content createContent() {
        NotebookVariablesToolWindowSetup data;
        KotlinNotebookVarsToolWindow panel = this;
        NotebookVariablesToolWindowSetup $this$createContent_u24lambda_u240 = data = this.panelSetupData;
        boolean bl = false;
        Content content = $this$createContent_u24lambda_u240.getUiRunnerLayoutUi().createContent($this$createContent_u24lambda_u240.getHelpId() + $this$createContent_u24lambda_u240.getTitle(), (JComponent)((Object)panel), $this$createContent_u24lambda_u240.getTitle(), null, UiUtils.getPreferredFocusedComponent((JComponent)((JComponent)((Object)panel))));
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        return content;
    }
}

