/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.tables;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.kotlin.jupyter.tables.KotlinDataframeParser;
import com.intellij.kotlin.jupyter.tables.KotlinDataframeTableDataProviderKt;
import com.intellij.kotlin.jupyter.tables.KotlinTableStatisticsDataImpl;
import com.intellij.kotlin.jupyter.tables.i18n.KotlinNotebookTablesBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DescribeTableCommand;
import com.intellij.scientific.tables.api.FilterExpression;
import com.intellij.scientific.tables.api.ImageLoadCommand;
import com.intellij.scientific.tables.api.ImageStartLoadCommand;
import com.intellij.scientific.tables.api.InfoTableCommand;
import com.intellij.scientific.tables.api.NestedTableDataProvider;
import com.intellij.scientific.tables.api.SliceTableCommand;
import com.intellij.scientific.tables.api.TableCommand;
import com.intellij.scientific.tables.api.TableCommandCodeProvider;
import com.intellij.scientific.tables.api.TableStatisticsData;
import com.intellij.scientific.tables.api.VisualizationDataTableCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J:\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0016J,\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\b\b\u0001\u0010#\u001a\u00020\u00112\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0%H\u0082\b\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\u0011H\u0003J\b\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016J \u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00112\u000e\b\u0002\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110-H\u0002J\u0010\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u0011H\u0002J\u0010\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020:H\u0002J4\u0010;\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0-2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00110-2\u0006\u0010?\u001a\u00020\u0007H\u0016J\"\u0010@\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020\u0007H\u0016J\b\u0010D\u001a\u000200H\u0016J\u0018\u0010E\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010F\u001a\u000200H\u0002J\u0018\u0010G\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010H\u001a\u00020*2\u0006\u0010I\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006J"}, d2={"Lcom/intellij/kotlin/jupyter/tables/KotlinDataFrameProvider;", "Lcom/intellij/scientific/tables/api/NestedTableDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "parser", "Lcom/intellij/kotlin/jupyter/tables/KotlinDataframeParser;", "columnsLimit", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/kotlin/jupyter/tables/KotlinDataframeParser;I)V", "type", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "getType", "()Lcom/intellij/scientific/tables/api/DSTableDataType;", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/DSTableRawData;", "id", "Lcom/intellij/scientific/tables/DataId;", "table", "loadDynamicTableDataFrameInfo", "commandExecutor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "tableVariable", "textTableOutput", "loadDynamicTableData", "dataId", "format", "start", "end", "executeParsing", "T", "textData", "parseFunction", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "extractNonComparableColumnTypeMessage", "exceptionMessage", "notifyUnknownParsingException", "", "getNestedTableCommand", "path", "", "Lcom/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate;", "isNonComparableColumnSortingError", "", "response", "errorIndicators", "extractColumnNameFromSortErrorMessage", "errorMsg", "getCommandCode", "tableCommand", "Lcom/intellij/scientific/tables/api/TableCommand;", "getSliceCommandCode", "command", "Lcom/intellij/scientific/tables/api/SliceTableCommand;", "getSortingCommand", "sortKeys", "Ljavax/swing/RowSorter$SortKey;", "columns", "indexColumnWidth", "getFilteringCommand", "filters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "tableColumnsNumber", "isFallbackToStaticTableSupported", "parseFrameInfoFromKotlinDataframeOutput", "isPreview", "parseDataFromKotlinDataframeOutput", "requireNumberOfColumnsLessThenLimit", "numberOfColumns", "intellij.kotlin.jupyter.tables"})
@SourceDebugExtension(value={"SMAP\nKotlinDataframeTableDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDataframeTableDataProvider.kt\ncom/intellij/kotlin/jupyter/tables/KotlinDataFrameProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n131#1,39:334\n131#1,39:373\n1740#2,3:412\n1740#2,3:415\n1563#2:418\n1634#2,3:419\n1563#2:422\n1634#2,3:423\n*S KotlinDebug\n*F\n+ 1 KotlinDataframeTableDataProvider.kt\ncom/intellij/kotlin/jupyter/tables/KotlinDataFrameProvider\n*L\n105#1:334,39\n126#1:373,39\n213#1:412,3\n251#1:415,3\n254#1:418\n254#1:419,3\n260#1:422\n260#1:423,3\n*E\n"})
public final class KotlinDataFrameProvider
implements NestedTableDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final KotlinDataframeParser parser;
    private final int columnsLimit;
    @NotNull
    private final DSTableDataType type;

    public KotlinDataFrameProvider(@NotNull Project project, @NotNull KotlinDataframeParser parser, int columnsLimit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.project = project;
        this.parser = parser;
        this.columnsLimit = columnsLimit;
        this.type = DSTableDataType.EXTERNAL;
    }

    @NotNull
    public DSTableDataType getType() {
        return this.type;
    }

    @NotNull
    public DSDataFrameInfo parseStaticTableToFrameInfo(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.parseFrameInfoFromKotlinDataframeOutput(text, true);
    }

    @NotNull
    public DSTableRawData parseStaticTableToTableData(@NotNull DataId id, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return this.parseDataFromKotlinDataframeOutput(id, table);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DSDataFrameInfo loadDynamicTableDataFrameInfo(@NotNull DSTableCommandExecutor commandExecutor, @NotNull String tableVariable, @NotNull String textTableOutput) throws DSTableDataException {
        void this_$iv;
        DSDataFrameInfo dSDataFrameInfo;
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)textTableOutput, (String)"textTableOutput");
        KotlinDataFrameProvider kotlinDataFrameProvider = this;
        String textData$iv = textTableOutput;
        boolean $i$f$executeParsing = false;
        try {
            boolean bl = false;
            dSDataFrameInfo = this.parseFrameInfoFromKotlinDataframeOutput(textTableOutput, false);
        }
        catch (DSTableDataException e$iv) {
            throw e$iv;
        }
        catch (JsonParseException e$iv) {
            if (KotlinDataFrameProvider.isNonComparableColumnSortingError$default((KotlinDataFrameProvider)this_$iv, textData$iv, null, 2, null)) {
                NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error");
                Object[] objectArray = new Object[]{super.extractColumnNameFromSortErrorMessage(textData$iv)};
                String string = KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error", objectArray);
                String string2 = super.extractNonComparableColumnTypeMessage(textData$iv);
                if (string2 == null) {
                    string2 = KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error.message", new Object[0]);
                }
                notificationGroup.createNotification(string, string2, NotificationType.WARNING).notify(this_$iv.project);
                throw new DSTableDataException(KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error.message", new Object[0]), (Throwable)e$iv);
            }
            super.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e$iv.getLocalizedMessage(), (Throwable)e$iv);
        }
        catch (StreamConstraintsException e$iv) {
            NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error").createNotification(KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.cannot.render.dataframe.error", new Object[0]), KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.cannot.parse.dataframe.error", new Object[0]), NotificationType.WARNING).notify(this_$iv.project);
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e$iv.getLocalizedMessage(), (Throwable)e$iv);
        }
        catch (IOException e$iv) {
            super.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e$iv.getLocalizedMessage(), (Throwable)e$iv);
        }
        catch (RuntimeException e$iv) {
            super.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e$iv.getLocalizedMessage(), (Throwable)e$iv);
        }
        DSDataFrameInfo info = dSDataFrameInfo;
        KotlinTableStatisticsDataImpl dataStatistics = new KotlinTableStatisticsDataImpl(commandExecutor, tableVariable);
        return DSDataFrameInfo.copy$default((DSDataFrameInfo)info, (int)0, (int)0, null, null, null, null, null, null, (TableStatisticsData)dataStatistics, null, (int)767, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DSTableRawData loadDynamicTableData(@NotNull DSTableCommandExecutor commandExecutor, @NotNull DataId dataId, @NotNull String tableVariable, @Nullable String format, int start, int end) throws DSTableDataException {
        void this_$iv;
        DSTableRawData dSTableRawData;
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        String response2 = commandExecutor.executeCommand((TableCommand)new SliceTableCommand(tableVariable, false, format, start, end), new TableCommandCodeProvider(this){
            final /* synthetic */ KotlinDataFrameProvider $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final String getCommandCode(TableCommand p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return KotlinDataFrameProvider.access$getCommandCode(this.$tmp0, p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, KotlinDataFrameProvider.class, "getCommandCode", "getCommandCode(Lcom/intellij/scientific/tables/api/TableCommand;)Ljava/lang/String;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof TableCommandCodeProvider ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        KotlinDataFrameProvider kotlinDataFrameProvider = this;
        String textData$iv = response2;
        boolean $i$f$executeParsing = false;
        try {
            boolean bl = false;
            dSTableRawData = this.parseDataFromKotlinDataframeOutput(dataId, response2);
        }
        catch (DSTableDataException e$iv) {
            throw e$iv;
        }
        catch (JsonParseException e$iv) {
            if (KotlinDataFrameProvider.isNonComparableColumnSortingError$default((KotlinDataFrameProvider)this_$iv, textData$iv, null, 2, null)) {
                NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error");
                Object[] objectArray = new Object[]{super.extractColumnNameFromSortErrorMessage(textData$iv)};
                String string = KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error", objectArray);
                String string2 = super.extractNonComparableColumnTypeMessage(textData$iv);
                if (string2 == null) {
                    string2 = KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error.message", new Object[0]);
                }
                notificationGroup.createNotification(string, string2, NotificationType.WARNING).notify(this_$iv.project);
                throw new DSTableDataException(KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error.message", new Object[0]), (Throwable)e$iv);
            }
            super.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e$iv.getLocalizedMessage(), (Throwable)e$iv);
        }
        catch (StreamConstraintsException e$iv) {
            NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error").createNotification(KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.cannot.render.dataframe.error", new Object[0]), KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.cannot.parse.dataframe.error", new Object[0]), NotificationType.WARNING).notify(this_$iv.project);
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e$iv.getLocalizedMessage(), (Throwable)e$iv);
        }
        catch (IOException e$iv) {
            super.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e$iv.getLocalizedMessage(), (Throwable)e$iv);
        }
        catch (RuntimeException e$iv) {
            super.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e$iv.getLocalizedMessage(), (Throwable)e$iv);
        }
        return dSTableRawData;
    }

    private final <T> T executeParsing(@NlsSafe String textData, Function0<? extends T> parseFunction) throws DSTableDataException {
        Object object;
        boolean $i$f$executeParsing = false;
        try {
            object = parseFunction.invoke();
        }
        catch (DSTableDataException e) {
            throw e;
        }
        catch (JsonParseException e) {
            if (KotlinDataFrameProvider.isNonComparableColumnSortingError$default(this, textData, null, 2, null)) {
                NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error");
                Object[] objectArray = new Object[]{this.extractColumnNameFromSortErrorMessage(textData)};
                String string = KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error", objectArray);
                String string2 = this.extractNonComparableColumnTypeMessage(textData);
                if (string2 == null) {
                    string2 = KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error.message", new Object[0]);
                }
                notificationGroup.createNotification(string, string2, NotificationType.WARNING).notify(this.project);
                throw new DSTableDataException(KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.sort_column_not_comparable.error.message", new Object[0]), (Throwable)e);
            }
            this.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (StreamConstraintsException e) {
            NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error").createNotification(KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.cannot.render.dataframe.error", new Object[0]), KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.cannot.parse.dataframe.error", new Object[0]), NotificationType.WARNING).notify(this.project);
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return (T)object;
    }

    @NlsSafe
    private final String extractNonComparableColumnTypeMessage(String exceptionMessage) {
        MatchResult matchResult;
        Regex regex = new Regex("Column '(.+?)' has type '(.+?)' that is not Comparable");
        MatchResult matchResult2 = matchResult = Regex.find$default((Regex)regex, (CharSequence)exceptionMessage, (int)0, (int)2, null);
        return matchResult2 != null ? matchResult2.getValue() : null;
    }

    private final void notifyUnknownParsingException() {
        NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error").createNotification(KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.cannot.render.dataframe.error", new Object[0]), KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.cannot.parse.dataframe.error.unknown", new Object[0]), NotificationType.WARNING).notify(this.project);
    }

    @NotNull
    public String getNestedTableCommand(@NotNull String tableVariable, @NotNull List<? extends NestedTablesDataGridModel.NestedTableCellCoordinate> path) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        String command = tableVariable;
        for (NestedTablesDataGridModel.NestedTableCellCoordinate nestedTableCellCoordinate : path) {
            Object object;
            GridColumn column = nestedTableCellCoordinate.getColumn();
            if (column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn) {
                List list = ((HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column).getFullyQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFullyQualifiedName(...)");
                object = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, KotlinDataFrameProvider::getNestedTableCommand$lambda$2, (int)30, null);
            } else {
                object = "[\"" + column.getName() + "\"]";
            }
            String columnSelector = object;
            command = StringsKt.trimIndent((String)("\n                KotlinNotebookPluginUtils.convertToDataFrame(" + command + "!!)" + columnSelector + "[" + nestedTableCellCoordinate.getRowIdx() + "]\n            "));
        }
        return command;
    }

    private final boolean isNonComparableColumnSortingError(String response2, List<String> errorIndicators) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = errorIndicators;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String indicator = (String)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.contains$default((CharSequence)response2, (CharSequence)indicator, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    static /* synthetic */ boolean isNonComparableColumnSortingError$default(KotlinDataFrameProvider kotlinDataFrameProvider, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            Object[] objectArray = new String[]{"Column", "has type", "that is not Comparable"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return kotlinDataFrameProvider.isNonComparableColumnSortingError(string, list);
    }

    private final String extractColumnNameFromSortErrorMessage(String errorMsg) {
        Regex regex = new Regex("Column '+(.*?)'+");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)errorMsg, (int)0, (int)2, null);
        Object object = matchResult;
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            object = "";
        }
        return object;
    }

    private final String getCommandCode(TableCommand tableCommand) {
        TableCommand tableCommand2 = tableCommand;
        if (tableCommand2 instanceof DescribeTableCommand || tableCommand2 instanceof InfoTableCommand || tableCommand2 instanceof VisualizationDataTableCommand || tableCommand2 instanceof ImageLoadCommand || tableCommand2 instanceof ImageStartLoadCommand) {
            throw new NotImplementedError(null, 1, null);
        }
        if (!(tableCommand2 instanceof SliceTableCommand)) {
            throw new NoWhenBranchMatchedException();
        }
        return this.getSliceCommandCode((SliceTableCommand)tableCommand);
    }

    private final String getSliceCommandCode(SliceTableCommand command) {
        SliceTableCommand $this$getSliceCommandCode_u24lambda_u244 = command;
        boolean bl = false;
        return StringsKt.trimIndent((String)("\n                try {\n                    DISPLAY(KotlinNotebookPluginUtils.getRowsSubsetForRendering(" + $this$getSliceCommandCode_u24lambda_u244.getTableVariable() + ", " + $this$getSliceCommandCode_u24lambda_u244.getStartRow() + ", " + $this$getSliceCommandCode_u24lambda_u244.getEndRow() + "), \"\")\n                } catch (_: IllegalArgumentException) {\n                    DISPLAY((" + $this$getSliceCommandCode_u24lambda_u244.getTableVariable() + ")!!, \"\")\n                }\n            "));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getSortingCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @NotNull List<String> columns, int indexColumnWidth) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
            Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            if (sortKeys.isEmpty()) {
                return tableVariable;
            }
            if (columns.isEmpty()) {
                return tableVariable;
            }
            Iterable $this$all$iv = columns;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    String it = (String)element$iv2;
                    boolean bl2 = false;
                    if (StringsKt.isBlank((CharSequence)it)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return tableVariable;
        }
        Iterable $i$f$all = sortKeys;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            RowSorter.SortKey sortKey = (RowSorter.SortKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            String name = columns.get(it.getColumn());
            String[] stringArray = new String[]{"."};
            String path = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null), null, null, null, (int)0, null, KotlinDataFrameProvider::getSortingCommand$lambda$7$lambda$6, (int)31, null);
            collection.add("listOf(" + path + ")");
        }
        List columnPaths = (List)destination$iv$iv;
        Iterable $this$map$iv2 = sortKeys;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RowSorter.SortKey bl3 = (RowSorter.SortKey)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            collection.add(it.getSortOrder() == SortOrder.DESCENDING);
        }
        List orderings = (List)destination$iv$iv2;
        return StringsKt.trimIndent((String)("\n            KotlinNotebookPluginUtils.sortByColumns(KotlinNotebookPluginUtils.convertToDataFrame(" + tableVariable + "!!), listOf(" + CollectionsKt.joinToString$default((Iterable)columnPaths, null, null, null, (int)0, null, null, (int)63, null) + "), listOf(" + CollectionsKt.joinToString$default((Iterable)orderings, null, null, null, (int)0, null, null, (int)63, null) + "))\n            "));
    }

    @NotNull
    public String getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters, int tableColumnsNumber) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        return tableVariable;
    }

    public boolean isFallbackToStaticTableSupported() {
        return true;
    }

    private final DSDataFrameInfo parseFrameInfoFromKotlinDataframeOutput(String text, boolean isPreview) {
        DSDataFrameInfo info = KotlinDataframeTableDataProviderKt.access$asDsTableInfo(this.parser.parseDataFrameInfo(text), isPreview);
        this.requireNumberOfColumnsLessThenLimit(info.getColumnNames().size());
        return info;
    }

    private final DSTableRawData parseDataFromKotlinDataframeOutput(DataId id, String text) {
        List<List<Object>> columnValues = this.parser.parseDataFrameData(text);
        this.requireNumberOfColumnsLessThenLimit(columnValues.size());
        return new DSTableRawData(id, columnValues);
    }

    private final void requireNumberOfColumnsLessThenLimit(int numberOfColumns) {
        if (numberOfColumns > this.columnsLimit) {
            Object[] objectArray = new Object[]{numberOfColumns};
            NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error").createNotification(KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.too.many.columns.error", new Object[0]), KotlinNotebookTablesBundle.message("kotlin.jupyter.table.output.notification.content.could.not.display.table.with.d.columns", objectArray), NotificationType.WARNING).notify(this.project);
            throw new DSTableDataException("Attempt to create grid with " + numberOfColumns + " columns");
        }
    }

    private static final CharSequence getNestedTableCommand$lambda$2(String it) {
        return "[\"" + it + "\"]";
    }

    private static final CharSequence getSortingCommand$lambda$7$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    public static final /* synthetic */ String access$getCommandCode(KotlinDataFrameProvider $this, TableCommand tableCommand) {
        return $this.getCommandCode(tableCommand);
    }
}

