/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging.comms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.Comm;
import org.jetbrains.kotlinx.jupyter.messaging.CommCloseMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CommMsgMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CommOpenMessage;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityKt;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerInternal;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 (2\u00020\u0001:\u0002'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\bJ\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!2\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020#H\u0016J*\u0010$\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\b2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tH\u0016J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0006\u001a$\u0012\u0004\u0012\u00020\b\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tj\u0002`\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\u0011R\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl;", "Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;", "connection", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;)V", "commOpenCallbacks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Comm;", "Lkotlinx/serialization/json/JsonObject;", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommOpenCallback;", "commTargetToIds", "Ljava/util/concurrent/CopyOnWriteArrayList;", "commIdToComm", "Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl$CommImpl;", "openComm", "target", "data", "processCommOpen", "message", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "content", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommOpenMessage;", "registerNewComm", "id", "closeComm", "processCommClose", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommCloseMessage;", "removeComm", "getComms", "", "processCommMessage", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommMsgMessage;", "registerCommTarget", "callback", "unregisterCommTarget", "CommImpl", "Companion", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nCommManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommManagerImpl.kt\norg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n72#2,2:221\n1#3:223\n1#3:234\n1617#4,9:224\n1869#4:233\n1870#4:235\n1626#4:236\n*S KotlinDebug\n*F\n+ 1 CommManagerImpl.kt\norg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl\n*L\n81#1:221,2\n81#1:223\n115#1:234\n115#1:224,9\n115#1:233\n115#1:235\n115#1:236\n*E\n"})
public final class CommManagerImpl
implements CommManagerInternal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterCommunicationFacility connection;
    @NotNull
    private final ConcurrentHashMap<String, Function2<Comm, JsonObject, Unit>> commOpenCallbacks;
    @NotNull
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<String>> commTargetToIds;
    @NotNull
    private final ConcurrentHashMap<String, CommImpl> commIdToComm;

    public CommManagerImpl(@NotNull JupyterCommunicationFacility connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        this.commOpenCallbacks = new ConcurrentHashMap();
        this.commTargetToIds = new ConcurrentHashMap();
        this.commIdToComm = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public Comm openComm(@NotNull String target, @NotNull JsonObject data) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        Comm newComm = this.registerNewComm(target, id);
        JupyterCommunicationFacilityKt.sendSimpleMessageToIoPub(this.connection, MessageType.COMM_OPEN, new CommOpenMessage(newComm.getId(), newComm.getTarget(), data));
        return newComm;
    }

    @Override
    @Nullable
    public Comm processCommOpen(@NotNull Message message, @NotNull CommOpenMessage content) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String target = content.getTargetName();
        String id = content.getCommId();
        JsonObject data = content.getData();
        Function2<Comm, JsonObject, Unit> callback = this.commOpenCallbacks.get(target);
        if (callback == null) {
            JupyterCommunicationFacilityKt.sendSimpleMessageToIoPub(this.connection, MessageType.COMM_CLOSE, new CommCloseMessage(id, CommManagerImpl.Companion.commFailureJson("Target " + target + " was not registered")));
            return null;
        }
        Comm newComm = this.registerNewComm(target, id);
        try {
            callback.invoke((Object)newComm, (Object)data);
        }
        catch (Throwable e) {
            JupyterCommunicationFacilityKt.sendSimpleMessageToIoPub(this.connection, MessageType.COMM_CLOSE, new CommCloseMessage(id, CommManagerImpl.Companion.commFailureJson("Unable to crete comm " + id + " (with target " + target + "), exception was thrown: " + ExceptionsKt.stackTraceToString((Throwable)e))));
            this.removeComm(id);
        }
        return newComm;
    }

    /*
     * WARNING - void declaration
     */
    private final Comm registerNewComm(String target, String id) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.commTargetToIds;
        String key$iv = target;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            CopyOnWriteArrayList default$iv = new CopyOnWriteArrayList();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CopyOnWriteArrayList commIds = (CopyOnWriteArrayList)object;
        CommImpl newComm = new CommImpl(target, id);
        commIds.add(id);
        ((Map)this.commIdToComm).put(id, newComm);
        return newComm;
    }

    @Override
    public void closeComm(@NotNull String id, @NotNull JsonObject data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CommImpl commImpl = this.commIdToComm.get(id);
        if (commImpl == null) {
            return;
        }
        CommImpl comm = commImpl;
        comm.close(data, true);
    }

    @Override
    public void processCommClose(@NotNull Message message, @NotNull CommCloseMessage content) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        CommImpl commImpl = this.commIdToComm.get(content.getCommId());
        if (commImpl == null) {
            return;
        }
        CommImpl comm = commImpl;
        comm.close(content.getData(), false);
    }

    public final void removeComm(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CommImpl commImpl = this.commIdToComm.get(id);
        if (commImpl == null) {
            return;
        }
        CommImpl comm = commImpl;
        CopyOnWriteArrayList<String> copyOnWriteArrayList = this.commTargetToIds.get(comm.getTarget());
        Intrinsics.checkNotNull(copyOnWriteArrayList);
        CopyOnWriteArrayList<String> commIds = copyOnWriteArrayList;
        commIds.remove(id);
        this.commIdToComm.remove(id);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Comm> getComms(@Nullable String target) {
        Collection collection;
        if (target == null) {
            Collection<CommImpl> collection2 = this.commIdToComm.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            collection = CollectionsKt.toList((Iterable)collection2);
        } else {
            void $this$mapNotNullTo$iv$iv;
            List list = this.commTargetToIds.get(target);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                CommImpl it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.commIdToComm.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        }
        return collection;
    }

    @Override
    public void processCommMessage(@NotNull Message message, @NotNull CommMsgMessage content) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            CommImpl commImpl = this.commIdToComm.get(content.getCommId());
            if (commImpl == null) break block0;
            commImpl.messageReceived(content.getData());
        }
    }

    @Override
    public void registerCommTarget(@NotNull String target, @NotNull Function2<? super Comm, ? super JsonObject, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ((Map)this.commOpenCallbacks).put(target, callback);
    }

    @Override
    public void unregisterCommTarget(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.commOpenCallbacks.remove(target);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\rH\u0016J0\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fH\u0016J \u0010\u0019\u001a\u00020\u000e2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fH\u0016J0\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u00112\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u0011H\u0016J \u0010\u001c\u001a\u00020\u000e2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u0011H\u0016J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR$\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl$CommImpl;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Comm;", "target", "", "id", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl;Ljava/lang/String;Ljava/lang/String;)V", "getTarget", "()Ljava/lang/String;", "getId", "onMessageCallbacks", "", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonObject;", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommMsgCallback;", "onCloseCallbacks", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommCloseCallback;", "closed", "", "assertOpen", "send", "data", "onMessage", "action", "removeMessageCallback", "callback", "onClose", "removeCloseCallback", "close", "notifyClient", "messageReceived", "shared-compiler"})
    @SourceDebugExtension(value={"SMAP\nCommManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommManagerImpl.kt\norg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl$CommImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1869#2,2:221\n*S KotlinDebug\n*F\n+ 1 CommManagerImpl.kt\norg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl$CommImpl\n*L\n189#1:221,2\n*E\n"})
    public final class CommImpl
    implements Comm {
        @NotNull
        private final String target;
        @NotNull
        private final String id;
        @NotNull
        private final List<Function1<JsonObject, Unit>> onMessageCallbacks;
        @NotNull
        private final List<Function1<JsonObject, Unit>> onCloseCallbacks;
        private boolean closed;

        public CommImpl(@NotNull String target, String id) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.target = target;
            this.id = id;
            this.onMessageCallbacks = new ArrayList();
            this.onCloseCallbacks = new ArrayList();
        }

        @Override
        @NotNull
        public String getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        private final void assertOpen() {
            if (this.closed) {
                throw new AssertionError((Object)("Comm '" + this.getTarget() + "' has been already closed"));
            }
        }

        @Override
        public void send(@NotNull JsonObject data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.assertOpen();
            JupyterCommunicationFacilityKt.sendSimpleMessageToIoPub(CommManagerImpl.this.connection, MessageType.COMM_MSG, new CommMsgMessage(this.getId(), data));
        }

        @Override
        @NotNull
        public Function1<JsonObject, Unit> onMessage(@NotNull Function1<? super JsonObject, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.assertOpen();
            this.onMessageCallbacks.add(action);
            return action;
        }

        @Override
        public void removeMessageCallback(@NotNull Function1<? super JsonObject, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.onMessageCallbacks.remove(callback);
        }

        @Override
        @NotNull
        public Function1<JsonObject, Unit> onClose(@NotNull Function1<? super JsonObject, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.assertOpen();
            this.onCloseCallbacks.add(action);
            return action;
        }

        @Override
        public void removeCloseCallback(@NotNull Function1<? super JsonObject, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.onCloseCallbacks.remove(callback);
        }

        @Override
        public void close(@NotNull JsonObject data, boolean notifyClient) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.assertOpen();
            this.closed = true;
            this.onMessageCallbacks.clear();
            CommManagerImpl.this.removeComm(this.getId());
            Iterable $this$forEach$iv = this.onCloseCallbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)data);
            }
            if (notifyClient) {
                JupyterCommunicationFacilityKt.sendSimpleMessageToIoPub(CommManagerImpl.this.connection, MessageType.COMM_CLOSE, new CommCloseMessage(this.getId(), data));
            }
        }

        public final void messageReceived(@NotNull JsonObject data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (this.closed) {
                return;
            }
            JupyterCommunicationFacilityKt.doWrappedInBusyIdle(CommManagerImpl.this.connection, (Function0<Unit>)((Function0)() -> CommImpl.messageReceived$lambda$1(this, data)));
        }

        private static final Unit messageReceived$lambda$1(CommImpl this$0, JsonObject $data) {
            for (Function1<JsonObject, Unit> callback : this$0.onMessageCallbacks) {
                callback.invoke((Object)$data);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerImpl$Companion;", "", "<init>", "()V", "commFailureJson", "Lkotlinx/serialization/json/JsonObject;", "errorMessage", "", "shared-compiler"})
    public static final class Companion {
        private Companion() {
        }

        private final JsonObject commFailureJson(String errorMessage) {
            return new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)JsonElementKt.JsonPrimitive((String)errorMessage))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

