/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.diagnostics;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.ide.model.FileTransmissionChunk;
import com.jetbrains.rd.ide.model.FileTransmissionModel;
import com.jetbrains.rd.ide.model.FileTransmissionRequest;
import com.jetbrains.rd.ide.model.FileTransmissionSession;
import com.jetbrains.rd.platform.codeWithMe.diagnostics.FileTransmission;
import com.jetbrains.rd.platform.codeWithMe.diagnostics.FileTransmissionHandler;
import com.jetbrains.rd.platform.codeWithMe.diagnostics.FileTransmissionHandlerKt;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.RdDefaultErrorLoggerHolder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ExecutionOrder;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.SchedulerUtilKt;
import com.jetbrains.rdserver.clipboard.SplitFileTransferKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J6\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002J.\u0010*\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010-\u001a\u00020\f2\u0006\u0010'\u001a\u00020\nH\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010'\u001a\u00020\nH\u0016J\u0018\u0010/\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u0004\u0018\u00010\f2\u0006\u00102\u001a\u000203H\u0096@\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\nH\u0002J.\u00106\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002J.\u00107\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u00108\u001a\u0002032\u0006\u00109\u001a\u000203H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\r\u001a \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u0006:"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/diagnostics/FileTransmissionHandler;", "Lcom/jetbrains/rd/platform/codeWithMe/diagnostics/FileTransmission;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "transmissionModel", "Lcom/jetbrains/rd/ide/model/FileTransmissionModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/FileTransmissionModel;)V", "filesToReceive", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/rd/ide/model/FileTransmissionRequest;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/io/File;", "filesToSend", "Lkotlin/Pair;", "", "isExperimentalMode", "", "()Z", "chunkSize", "", "getChunkSize", "()I", "packetSize", "getPacketSize", "ackSize", "", "getAckSize", "()J", "ioScheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "getIoScheduler", "()Lcom/jetbrains/rd/util/reactive/IScheduler;", "ioScheduler$delegate", "Lkotlin/Lazy;", "handleSend", "sessionLt", "session", "Lcom/jetbrains/rd/ide/model/FileTransmissionSession;", "request", "fileToSend", "onFileSent", "handleReceive", "onFileReceived", "sendFileAsync", "file", "receiveFileAsync", "receiveFileAsyncCancellable", "(Lcom/jetbrains/rd/ide/model/FileTransmissionRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchFile", "remoteFileSystemIndependentPath", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanUpTransmissionMetadata", "handleSendExperimental", "handleReceiveExperimental", "sanitiseFileName", "receivedFileName", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nFileTransmissionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTransmissionHandler.kt\ncom/jetbrains/rd/platform/codeWithMe/diagnostics/FileTransmissionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,387:1\n1#2:388\n24#3:389\n24#3:390\n24#3:391\n137#4:392\n135#4:393\n117#4,7:394\n136#4:401\n137#4:402\n135#4:403\n117#4,7:404\n136#4:411\n137#4:412\n135#4:413\n117#4,7:414\n136#4:421\n137#4:422\n135#4:423\n117#4,7:424\n136#4:431\n137#4:432\n135#4:433\n117#4,7:434\n136#4:441\n137#4:442\n135#4:443\n117#4,7:444\n136#4:451\n*S KotlinDebug\n*F\n+ 1 FileTransmissionHandler.kt\ncom/jetbrains/rd/platform/codeWithMe/diagnostics/FileTransmissionHandler\n*L\n223#1:389\n226#1:390\n232#1:391\n103#1:392\n103#1:393\n103#1:394,7\n103#1:401\n112#1:402\n112#1:403\n112#1:404,7\n112#1:411\n141#1:412\n141#1:413\n141#1:414,7\n141#1:421\n161#1:422\n161#1:423\n161#1:424,7\n161#1:431\n296#1:432\n296#1:433\n296#1:434,7\n296#1:441\n356#1:442\n356#1:443\n356#1:444,7\n356#1:451\n*E\n"})
public final class FileTransmissionHandler
implements FileTransmission {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final FileTransmissionModel transmissionModel;
    @NotNull
    private final ConcurrentHashMap<FileTransmissionRequest, CompletableFuture<File>> filesToReceive;
    @NotNull
    private final ConcurrentHashMap<FileTransmissionRequest, Pair<File, CompletableFuture<Unit>>> filesToSend;
    @NotNull
    private final Lazy ioScheduler$delegate;

    public FileTransmissionHandler(@NotNull Lifetime lifetime, @NotNull FileTransmissionModel transmissionModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)transmissionModel, (String)"transmissionModel");
        this.lifetime = lifetime;
        this.transmissionModel = transmissionModel;
        this.filesToReceive = new ConcurrentHashMap();
        this.filesToSend = new ConcurrentHashMap();
        this.ioScheduler$delegate = LazyKt.lazy(FileTransmissionHandler::ioScheduler_delegate$lambda$0);
        this.transmissionModel.getSessions().view(this.lifetime, (arg_0, arg_1, arg_2) -> FileTransmissionHandler._init_$lambda$1(this, arg_0, arg_1, arg_2));
    }

    private final boolean isExperimentalMode() {
        return Intrinsics.areEqual((Object)this.transmissionModel.getExperimentalMode().getValueOrNull(), (Object)true);
    }

    private final int getChunkSize() {
        Integer n = (Integer)this.transmissionModel.getChunkSizeKB().getValueOrNull();
        return RangesKt.coerceIn((int)(n != null ? n : 512), (int)1, (int)1024) * 1024;
    }

    private final int getPacketSize() {
        Integer n = (Integer)this.transmissionModel.getPacketSizeKB().getValueOrNull();
        return RangesKt.coerceIn((int)(n != null ? n : 16), (int)1, (int)1024) * 1024;
    }

    private final long getAckSize() {
        Integer n = (Integer)this.transmissionModel.getAckSizeKB().getValueOrNull();
        return (long)RangesKt.coerceIn((int)(n != null ? n : 1024), (int)128, (int)16384) * 1024L;
    }

    private final IScheduler getIoScheduler() {
        Lazy lazy = this.ioScheduler$delegate;
        return (IScheduler)lazy.getValue();
    }

    private final void handleSend(Lifetime sessionLt, FileTransmissionSession session, FileTransmissionRequest request, File fileToSend, CompletableFuture<Unit> onFileSent) {
        FileInputStream fileInputStream = (FileInputStream)FileTransmissionHandler.handleSend$catchAndTerminateSession(session, onFileSent, () -> FileTransmissionHandler.handleSend$lambda$3(fileToSend, sessionLt), (Function0<Unit>)((Function0)FileTransmissionHandler::handleSend$lambda$4));
        if (fileInputStream == null) {
            return;
        }
        FileInputStream stream = fileInputStream;
        byte[] buffer = new byte[this.getChunkSize()];
        boolean sendNextRc = FileTransmissionHandler.handleSend$sendNext(stream, buffer, session, onFileSent);
        if (sendNextRc) {
            session.getAck().advise(sessionLt, arg_0 -> FileTransmissionHandler.handleSend$lambda$9(stream, buffer, session, onFileSent, arg_0));
        }
        sessionLt.onTermination(() -> FileTransmissionHandler.handleSend$lambda$10(request, fileToSend));
    }

    private final void handleReceive(Lifetime sessionLt, FileTransmissionSession session, FileTransmissionRequest request, CompletableFuture<File> onFileReceived) {
        String sanitisedFileName = this.sanitiseFileName(request.getName());
        File file = FileUtil.createTempFile((String)sanitisedFileName, (String)".tmp", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File tempFile = file;
        FileOutputStream stream = new FileOutputStream(tempFile);
        session.getChunk().adviseOn(sessionLt, IRdDispatcherKt.getAsRdDispatcher((IScheduler)InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)session)).getScheduler()).getBackgroundScheduler(), arg_0 -> FileTransmissionHandler.handleReceive$lambda$14(stream, onFileReceived, tempFile, this, session, request, arg_0));
        LifetimeExKt.onTerminationOrNowSafe((Lifetime)sessionLt, () -> FileTransmissionHandler.handleReceive$lambda$16(request, onFileReceived, stream));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> sendFileAsync(@NotNull File file, @NotNull FileTransmissionRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FileTransmissionHandlerKt.access$getLOG$p().info("Sending file '" + request.getName() + " " + request.getUuid() + "' from " + file + " via Rd protocol");
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        future.handleAsync((arg_0, arg_1) -> FileTransmissionHandler.sendFileAsync$lambda$18((arg_0, arg_1) -> FileTransmissionHandler.sendFileAsync$lambda$17(request, arg_0, arg_1), arg_0, arg_1));
        ((Map)this.filesToSend).put(request, TuplesKt.to((Object)file, future));
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<File> receiveFileAsync(@NotNull FileTransmissionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FileTransmissionHandlerKt.access$getLOG$p().info("Receiving file '" + request.getName() + "' via Rd protocol");
        CompletableFuture<File> future = new CompletableFuture<File>();
        future.handleAsync((arg_0, arg_1) -> FileTransmissionHandler.receiveFileAsync$lambda$20((arg_0, arg_1) -> FileTransmissionHandler.receiveFileAsync$lambda$19(request, arg_0, arg_1), arg_0, arg_1));
        InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)this.transmissionModel)).getScheduler().invokeOrQueue(() -> FileTransmissionHandler.receiveFileAsync$lambda$21(this, request, future));
        return future;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object receiveFileAsyncCancellable(@NotNull FileTransmissionRequest request, @NotNull Continuation<? super File> $completion) {
        if (!($completion instanceof receiveFileAsyncCancellable.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ FileTransmissionHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.receiveFileAsyncCancellable(null, (Continuation<? super File>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = request;
                $continuation.label = 1;
                v0 = FutureKt.await((CompletionStage)this.receiveFileAsync(request), (Continuation)$continuation);
                ** if (v0 != var7_5) goto lbl19
lbl18:
                // 1 sources

                return var7_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                request = (FileTransmissionRequest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    var3_6 = (File)v0;
                }
                catch (CancellationException <unused var>) {
                    this.cleanUpTransmissionMetadata(request);
                    var3_6 = null;
                }
                return var3_6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object fetchFile(@NotNull String remoteFileSystemIndependentPath, @NotNull Continuation<? super File> $completion) {
        block14: {
            if (!($completion instanceof fetchFile.1)) ** GOTO lbl-1000
            var11_3 = $completion;
            if ((var11_3.label & -2147483648) != 0) {
                var11_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ FileTransmissionHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.fetchFile(null, (Continuation<? super File>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = remoteFileSystemIndependentPath;
                    $continuation.label = 1;
                    v0 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)((IRdCall)this.transmissionModel.getFetchFile()), (Lifetime)this.lifetime, (Object)remoteFileSystemIndependentPath, null, (Continuation)$continuation, (int)4, null);
                    if (v0 == var12_5) {
                        return var12_5;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    remoteFileSystemIndependentPath = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    if ((requestToDownloadAlreadyPreparedFile = (FileTransmissionRequest)v0) == null) break;
                    var4_7 = this;
                    $this$fetchFile_u24lambda_u2422 = var4_7;
                    $i$a$-runCatching-FileTransmissionHandler$fetchFile$2 = 0;
                    $continuation.L$0 = remoteFileSystemIndependentPath;
                    $continuation.L$1 = requestToDownloadAlreadyPreparedFile;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$fetchFile_u24lambda_u2422);
                    $continuation.I$0 = $i$a$-runCatching-FileTransmissionHandler$fetchFile$2;
                    $continuation.label = 2;
                    v1 = FutureKt.await((CompletionStage)$this$fetchFile_u24lambda_u2422.receiveFileAsync(requestToDownloadAlreadyPreparedFile), (Continuation)$continuation);
                    ** if (v1 != var12_5) goto lbl37
lbl36:
                    // 1 sources

                    return var12_5;
lbl37:
                    // 1 sources

                    ** GOTO lbl47
                }
                case 2: {
                    $i$a$-runCatching-FileTransmissionHandler$fetchFile$2 = $continuation.I$0;
                    $this$fetchFile_u24lambda_u2422 = (FileTransmissionHandler)$continuation.L$2;
                    requestToDownloadAlreadyPreparedFile = (FileTransmissionRequest)$continuation.L$1;
                    remoteFileSystemIndependentPath = (String)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl47:
                        // 2 sources

                        $this$fetchFile_u24lambda_u2422 = Result.constructor-impl((Object)((File)v1));
                    }
                    catch (Throwable $i$a$-runCatching-FileTransmissionHandler$fetchFile$2) {
                        $this$fetchFile_u24lambda_u2422 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-FileTransmissionHandler$fetchFile$2));
                    }
                    var4_7 = $this$fetchFile_u24lambda_u2422;
                    v2 = Result.exceptionOrNull-impl((Object)var4_7);
                    if (v2 != null) {
                        exception = $this$fetchFile_u24lambda_u2422 = v2;
                        $i$a$-onFailure-FileTransmissionHandler$fetchFile$3 = false;
                        $this$thisLogger$iv = this;
                        $i$f$thisLogger = false;
                        v3 = com.intellij.openapi.diagnostic.Logger.getInstance(FileTransmissionHandler.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                        v3.debug("Failed to fetch file '" + remoteFileSystemIndependentPath + "'", (Throwable)exception);
                        this.cleanUpTransmissionMetadata(requestToDownloadAlreadyPreparedFile);
                    }
                    if (Result.isSuccess-impl((Object)var4_7)) {
                        value = (File)var4_7;
                        $i$a$-onSuccess-FileTransmissionHandler$fetchFile$4 = false;
                        $this$thisLogger$iv = this;
                        $i$f$thisLogger = false;
                        v4 = com.intellij.openapi.diagnostic.Logger.getInstance(FileTransmissionHandler.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
                        v4.debug("Successfully fetched file '" + remoteFileSystemIndependentPath + "' to " + value);
                        this.cleanUpTransmissionMetadata(requestToDownloadAlreadyPreparedFile);
                    }
                    v5 = (File)(Result.isFailure-impl((Object)var4_7) != false ? null : var4_7);
                    break block14;
                }
            }
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            v6 = com.intellij.openapi.diagnostic.Logger.getInstance(FileTransmissionHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getInstance(...)");
            v6.warn("Unable to prepare file `" + remoteFileSystemIndependentPath + "` for transmission");
            v5 = null;
        }
        return v5;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void cleanUpTransmissionMetadata(FileTransmissionRequest request) {
        InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)this.transmissionModel)).getScheduler().invokeOrQueue(() -> FileTransmissionHandler.cleanUpTransmissionMetadata$lambda$25(this, request));
        this.filesToReceive.remove(request);
    }

    private final void handleSendExperimental(Lifetime sessionLt, FileTransmissionSession session, File fileToSend, CompletableFuture<Unit> onFileSent) {
        FileInputStream fileInputStream = (FileInputStream)FileTransmissionHandler.handleSendExperimental$catchAndTerminateSession$26(session, onFileSent, () -> FileTransmissionHandler.handleSendExperimental$lambda$27(fileToSend));
        if (fileInputStream == null) {
            return;
        }
        FileInputStream inputStream = fileInputStream;
        sessionLt.onTermination((Closeable)inputStream);
        byte[] buffer = new byte[this.getPacketSize()];
        Ref.LongRef sentLength = new Ref.LongRef();
        Ref.BooleanRef ackPending = new Ref.BooleanRef();
        session.getAckLength().advise(sessionLt, arg_0 -> FileTransmissionHandler.handleSendExperimental$lambda$32(ackPending, sentLength, session, this, inputStream, buffer, onFileSent, arg_0));
        FileTransmissionHandler.handleSendExperimental$sendPacketIfPossible(ackPending, sentLength, session, this, inputStream, buffer, onFileSent);
    }

    private final void handleReceiveExperimental(Lifetime sessionLt, FileTransmissionSession session, FileTransmissionRequest request, CompletableFuture<File> onFileReceived) {
        File file = (File)FileTransmissionHandler.handleReceiveExperimental$catchAndReportFailure(onFileReceived, this, request, () -> FileTransmissionHandler.handleReceiveExperimental$lambda$34(request));
        if (file == null) {
            return;
        }
        File file2 = file;
        FileOutputStream fileOutputStream = (FileOutputStream)FileTransmissionHandler.handleReceiveExperimental$catchAndReportFailure(onFileReceived, this, request, () -> FileTransmissionHandler.handleReceiveExperimental$lambda$35(file2));
        if (fileOutputStream == null) {
            return;
        }
        FileOutputStream stream = fileOutputStream;
        Ref.LongRef bytesWritten = new Ref.LongRef();
        session.getChunk().adviseOn(sessionLt, this.getIoScheduler(), arg_0 -> FileTransmissionHandler.handleReceiveExperimental$lambda$41(stream, onFileReceived, this, request, file2, bytesWritten, session, arg_0));
    }

    private final String sanitiseFileName(String receivedFileName) {
        String string = FileUtilRt.getNameWithoutExtension((String)receivedFileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String nameWithoutExtension = string;
        String string2 = FileUtilRt.getExtension((String)receivedFileName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
        String extension = string2;
        String sanitisedName = SplitFileTransferKt.sanitiseRemoteFileNameSegment(nameWithoutExtension);
        String sanitisedExtension = SplitFileTransferKt.sanitiseRemoteFileNameSegment(extension);
        return sanitisedName + "." + sanitisedExtension;
    }

    private static final IScheduler ioScheduler_delegate$lambda$0() {
        return SchedulerUtilKt.asRdScheduler((Executor)new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue()), (ExecutionOrder)ExecutionOrder.Sequential);
    }

    private static final Unit _init_$lambda$1(FileTransmissionHandler this$0, Lifetime sessionLt, FileTransmissionRequest request, FileTransmissionSession session) {
        Intrinsics.checkNotNullParameter((Object)sessionLt, (String)"sessionLt");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        CompletableFuture<File> onFileReceived = this$0.filesToReceive.remove(request);
        if (onFileReceived != null) {
            if (this$0.isExperimentalMode()) {
                this$0.handleReceiveExperimental(sessionLt, session, request, onFileReceived);
            } else {
                this$0.handleReceive(sessionLt, session, request, onFileReceived);
            }
            return Unit.INSTANCE;
        }
        Pair<File, CompletableFuture<Unit>> sendData = this$0.filesToSend.remove(request);
        if (sendData != null) {
            File fileToSend = (File)sendData.component1();
            CompletableFuture onFileSent = (CompletableFuture)sendData.component2();
            if (this$0.isExperimentalMode()) {
                this$0.handleSendExperimental(sessionLt, session, fileToSend, onFileSent);
            } else {
                this$0.handleSend(sessionLt, session, request, fileToSend, onFileSent);
            }
            return Unit.INSTANCE;
        }
        FileTransmissionHandlerKt.access$getLOG$p().error("Received unexpected FileTransmissionRequest: fileName=" + request.getName() + " uuid=" + request.getUuid());
        return Unit.INSTANCE;
    }

    private static final <R> R handleSend$catchAndTerminateSession(FileTransmissionSession $session, CompletableFuture<Unit> $onFileSent, Function0<? extends R> block, Function0<Unit> closeStream) {
        try {
            return (R)block.invoke();
        }
        catch (Throwable t) {
            closeStream.invoke();
            $session.getChunk().fire((Object)new FileTransmissionChunk(new byte[0], true, t.getClass().getName() + ": " + t.getMessage()));
            $onFileSent.completeExceptionally(t);
            return null;
        }
    }

    private static final FileInputStream handleSend$lambda$3(File $fileToSend, Lifetime $sessionLt) {
        FileInputStream fileInputStream;
        FileInputStream it = fileInputStream = new FileInputStream($fileToSend);
        boolean bl = false;
        $sessionLt.onTermination((Closeable)it);
        return fileInputStream;
    }

    private static final Unit handleSend$lambda$4() {
        return Unit.INSTANCE;
    }

    private static final boolean handleSend$sendNext$lambda$6(FileInputStream $stream, byte[] $buffer, FileTransmissionSession $session, CompletableFuture $onFileSent) {
        boolean bl;
        int bytesRead = $stream.read($buffer);
        if (bytesRead < 0) {
            $session.getChunk().fire((Object)new FileTransmissionChunk(new byte[0], true, null));
            boolean $i$f$catch = false;
            Object comment$iv$iv = null;
            boolean $i$f$catch2 = false;
            Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
            boolean $i$f$catch3 = false;
            try {
                boolean bl2 = false;
                $stream.close();
            }
            catch (Throwable e$iv$iv$iv) {
                String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
            }
            $onFileSent.complete(Unit.INSTANCE);
            bl = false;
        } else {
            IAsyncSignal iAsyncSignal = $session.getChunk();
            byte[] byArray = Arrays.copyOf($buffer, bytesRead);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            iAsyncSignal.fire((Object)new FileTransmissionChunk(byArray, false, null));
            bl = true;
        }
        return bl;
    }

    private static final Unit handleSend$sendNext$lambda$8(FileInputStream $stream) {
        boolean $i$f$catch = false;
        Object comment$iv$iv = null;
        boolean $i$f$catch2 = false;
        Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
        boolean $i$f$catch3 = false;
        try {
            boolean bl = false;
            $stream.close();
        }
        catch (Throwable e$iv$iv$iv) {
            String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
            LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
        }
        return Unit.INSTANCE;
    }

    private static final boolean handleSend$sendNext(FileInputStream stream, byte[] buffer, FileTransmissionSession $session, CompletableFuture<Unit> $onFileSent) {
        Boolean bl = (Boolean)FileTransmissionHandler.handleSend$catchAndTerminateSession($session, $onFileSent, () -> FileTransmissionHandler.handleSend$sendNext$lambda$6(stream, buffer, $session, $onFileSent), (Function0<Unit>)((Function0)() -> FileTransmissionHandler.handleSend$sendNext$lambda$8(stream)));
        return bl != null ? bl : false;
    }

    private static final Unit handleSend$lambda$9(FileInputStream $stream, byte[] $buffer, FileTransmissionSession $session, CompletableFuture $onFileSent, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FileTransmissionHandler.handleSend$sendNext($stream, $buffer, $session, $onFileSent);
        return Unit.INSTANCE;
    }

    private static final Unit handleSend$lambda$10(FileTransmissionRequest $request, File $fileToSend) {
        FileTransmissionHandlerKt.access$getLOG$p().debug("Terminating sending file " + $request + " from " + $fileToSend);
        return Unit.INSTANCE;
    }

    private static final void handleReceive$lambda$14$lambda$12(File $tempFile) {
        boolean $i$f$catch = false;
        Object comment$iv$iv = null;
        boolean $i$f$catch2 = false;
        Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
        boolean $i$f$catch3 = false;
        try {
            boolean bl = false;
            $tempFile.delete();
        }
        catch (Throwable e$iv$iv$iv) {
            String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
            LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
        }
    }

    private static final Unit handleReceive$lambda$14$lambda$13(FileTransmissionHandler this$0, FileTransmissionRequest $request) {
        this$0.transmissionModel.getSessions().remove((Object)$request);
        return Unit.INSTANCE;
    }

    private static final Unit handleReceive$lambda$14(FileOutputStream $stream, CompletableFuture $onFileReceived, File $tempFile, FileTransmissionHandler this$0, FileTransmissionSession $session, FileTransmissionRequest $request, FileTransmissionChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        $stream.write(chunk.getBytes());
        if (chunk.getEof()) {
            String errorString = chunk.getError();
            FileTransmissionHandlerKt.access$getLOG$p().debug("Received EOF signal, errorString=" + errorString);
            if (errorString != null) {
                CompletableFuture.runAsync(() -> FileTransmissionHandler.handleReceive$lambda$14$lambda$12($tempFile));
                v0 = $onFileReceived.completeExceptionally(new IllegalStateException("File sending error on remote side: " + errorString));
            } else {
                v0 = $onFileReceived.complete($tempFile);
            }
            InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)this$0.transmissionModel)).getScheduler().invokeOrQueue(() -> FileTransmissionHandler.handleReceive$lambda$14$lambda$13(this$0, $request));
        } else {
            $session.getAck().fire((Object)Unit.INSTANCE);
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleReceive$lambda$16(FileTransmissionRequest $request, CompletableFuture $onFileReceived, FileOutputStream $stream) {
        FileTransmissionHandlerKt.access$getLOG$p().debug("Terminating receiving file " + $request);
        boolean $i$f$catch = false;
        Object comment$iv$iv = null;
        boolean $i$f$catch2 = false;
        Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
        boolean $i$f$catch3 = false;
        try {
            boolean bl = false;
            $stream.close();
        }
        catch (Throwable e$iv$iv$iv) {
            String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
            LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
        }
        $onFileReceived.completeExceptionally(new CancellationException());
        return Unit.INSTANCE;
    }

    private static final Unit sendFileAsync$lambda$17(FileTransmissionRequest $request, Unit unit, Throwable exception) {
        if (exception != null) {
            FileTransmissionHandlerKt.access$getLOG$p().warn("File sending of '" + $request.getName() + " " + $request.getUuid() + "' completed with an error: " + exception.getMessage(), exception);
        } else {
            FileTransmissionHandlerKt.access$getLOG$p().info("Successfully sent file '" + $request.getName() + " " + $request.getUuid() + "' to the other side");
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendFileAsync$lambda$18(Function2 $tmp0, Object p0, Throwable p1) {
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit receiveFileAsync$lambda$19(FileTransmissionRequest $request, File file, Throwable exception) {
        if (exception != null) {
            FileTransmissionHandlerKt.access$getLOG$p().warn("File receiving of '" + $request.getName() + " " + $request.getUuid() + "' completed with an error: " + exception.getMessage(), exception);
        } else {
            FileTransmissionHandlerKt.access$getLOG$p().info("Successfully received file '" + $request.getName() + " " + $request.getUuid() + "'");
        }
        return Unit.INSTANCE;
    }

    private static final Unit receiveFileAsync$lambda$20(Function2 $tmp0, Object p0, Throwable p1) {
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit receiveFileAsync$lambda$21(FileTransmissionHandler this$0, FileTransmissionRequest $request, CompletableFuture $future) {
        ((Map)this$0.filesToReceive).put($request, $future);
        ((Map)this$0.transmissionModel.getSessions()).put($request, new FileTransmissionSession());
        return Unit.INSTANCE;
    }

    private static final Unit cleanUpTransmissionMetadata$lambda$25(FileTransmissionHandler this$0, FileTransmissionRequest $request) {
        this$0.transmissionModel.getSessions().remove((Object)$request);
        return Unit.INSTANCE;
    }

    private static final <R> R handleSendExperimental$catchAndTerminateSession$26(FileTransmissionSession $session, CompletableFuture<Unit> $onFileSent, Function0<? extends R> block) {
        try {
            return (R)block.invoke();
        }
        catch (IOException ex) {
            $session.getChunk().fire((Object)new FileTransmissionChunk(new byte[0], false, ex.toString()));
            $onFileSent.completeExceptionally(ex);
            return null;
        }
    }

    private static final FileInputStream handleSendExperimental$lambda$27(File $fileToSend) {
        return new FileInputStream($fileToSend);
    }

    private static final boolean handleSendExperimental$sendPacket$lambda$28(FileInputStream $inputStream, byte[] $buffer, FileTransmissionSession $session, CompletableFuture $onFileSent, Ref.LongRef $sentLength) {
        boolean bl;
        int bytes = $inputStream.read($buffer);
        if (bytes < 0) {
            $session.getChunk().fire((Object)new FileTransmissionChunk(new byte[0], false, null));
            $onFileSent.complete(Unit.INSTANCE);
            bl = false;
        } else {
            IAsyncSignal iAsyncSignal = $session.getChunk();
            byte[] byArray = Arrays.copyOf($buffer, bytes);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            iAsyncSignal.fire((Object)new FileTransmissionChunk(byArray, false, null));
            $sentLength.element += (long)bytes;
            bl = true;
        }
        return bl;
    }

    private static final boolean handleSendExperimental$sendPacket(FileInputStream inputStream, byte[] buffer, FileTransmissionSession $session, CompletableFuture<Unit> $onFileSent, Ref.LongRef sentLength) {
        Boolean bl = (Boolean)FileTransmissionHandler.handleSendExperimental$catchAndTerminateSession$26($session, $onFileSent, () -> FileTransmissionHandler.handleSendExperimental$sendPacket$lambda$28(inputStream, buffer, $session, $onFileSent, sentLength));
        return bl != null ? bl : false;
    }

    private static final void handleSendExperimental$sendPacketIfPossible$lambda$31$lambda$29(Ref.BooleanRef $ackPending, Ref.LongRef $sentLength, FileTransmissionSession $session, FileTransmissionHandler this$0, FileInputStream $inputStream, byte[] $buffer, CompletableFuture $onFileSent) {
        FileTransmissionHandler.handleSendExperimental$sendPacketIfPossible($ackPending, $sentLength, $session, this$0, $inputStream, $buffer, $onFileSent);
    }

    private static final Unit handleSendExperimental$sendPacketIfPossible$lambda$31(FileInputStream $inputStream, byte[] $buffer, FileTransmissionSession $session, CompletableFuture $onFileSent, Ref.LongRef $sentLength, Ref.BooleanRef $ackPending, FileTransmissionHandler this$0) {
        if (FileTransmissionHandler.handleSendExperimental$sendPacket($inputStream, $buffer, $session, $onFileSent, $sentLength)) {
            SwingUtilities.invokeLater(() -> FileTransmissionHandler.handleSendExperimental$sendPacketIfPossible$lambda$31$lambda$29($ackPending, $sentLength, $session, this$0, $inputStream, $buffer, $onFileSent));
        } else {
            boolean $i$f$catch = false;
            Object comment$iv$iv = null;
            boolean $i$f$catch2 = false;
            Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
            boolean $i$f$catch3 = false;
            try {
                boolean bl = false;
                $inputStream.close();
            }
            catch (Throwable e$iv$iv$iv) {
                String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void handleSendExperimental$sendPacketIfPossible(Ref.BooleanRef ackPending, Ref.LongRef sentLength, FileTransmissionSession $session, FileTransmissionHandler this$0, FileInputStream inputStream, byte[] buffer, CompletableFuture<Unit> $onFileSent) {
        boolean bl = ackPending.element = sentLength.element - ((Number)com.jetbrains.rd.util.reactive.InterfacesKt.valueOrDefault((IOptProperty)$session.getAckLength(), (Object)0L)).longValue() > this$0.getAckSize();
        if (!ackPending.element) {
            this$0.getIoScheduler().queue(() -> FileTransmissionHandler.handleSendExperimental$sendPacketIfPossible$lambda$31(inputStream, buffer, $session, $onFileSent, sentLength, ackPending, this$0));
        }
    }

    private static final Unit handleSendExperimental$lambda$32(Ref.BooleanRef $ackPending, Ref.LongRef $sentLength, FileTransmissionSession $session, FileTransmissionHandler this$0, FileInputStream $inputStream, byte[] $buffer, CompletableFuture $onFileSent, long it) {
        if ($ackPending.element) {
            FileTransmissionHandler.handleSendExperimental$sendPacketIfPossible($ackPending, $sentLength, $session, this$0, $inputStream, $buffer, $onFileSent);
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleReceiveExperimental$terminateSession$lambda$33(FileTransmissionHandler this$0, FileTransmissionRequest $request) {
        this$0.transmissionModel.getSessions().remove((Object)$request);
        return Unit.INSTANCE;
    }

    private static final void handleReceiveExperimental$terminateSession(FileTransmissionHandler this$0, FileTransmissionRequest $request) {
        InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)this$0.transmissionModel)).getScheduler().queue(() -> FileTransmissionHandler.handleReceiveExperimental$terminateSession$lambda$33(this$0, $request));
    }

    private static final <R> R handleReceiveExperimental$catchAndReportFailure(CompletableFuture<File> $onFileReceived, FileTransmissionHandler this$0, FileTransmissionRequest $request, Function0<? extends R> block) {
        try {
            return (R)block.invoke();
        }
        catch (IOException ex) {
            FileTransmissionHandler.handleReceiveExperimental$terminateSession(this$0, $request);
            $onFileReceived.completeExceptionally(ex);
            return null;
        }
    }

    private static final File handleReceiveExperimental$lambda$34(FileTransmissionRequest $request) {
        return FileUtil.createTempFile((String)$request.getName(), (String)".tmp", (boolean)true);
    }

    private static final FileOutputStream handleReceiveExperimental$lambda$35(File $file) {
        return new FileOutputStream($file);
    }

    private static final Unit handleReceiveExperimental$lambda$41$lambda$36(FileOutputStream $stream) {
        $stream.close();
        return Unit.INSTANCE;
    }

    private static final Unit handleReceiveExperimental$lambda$41$lambda$39(FileOutputStream $stream, byte[] $bytes) {
        $stream.write($bytes);
        return Unit.INSTANCE;
    }

    private static final Unit handleReceiveExperimental$lambda$41(FileOutputStream $stream, CompletableFuture $onFileReceived, FileTransmissionHandler this$0, FileTransmissionRequest $request, File $file, Ref.LongRef $bytesWritten, FileTransmissionSession $session, FileTransmissionChunk chunk) {
        block6: {
            byte[] bytes;
            block5: {
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                bytes = chunk.getBytes();
                if (!(bytes.length == 0)) break block5;
                Unit unit = (Unit)FileTransmissionHandler.handleReceiveExperimental$catchAndReportFailure($onFileReceived, this$0, $request, () -> FileTransmissionHandler.handleReceiveExperimental$lambda$41$lambda$36($stream));
                if (unit == null) break block6;
                Unit it = unit;
                boolean bl = false;
                FileTransmissionHandler.handleReceiveExperimental$terminateSession(this$0, $request);
                String errorString = chunk.getError();
                if (errorString == null) {
                    v0 = $onFileReceived.complete($file);
                } else {
                    boolean $i$f$catch = false;
                    Object comment$iv$iv = null;
                    boolean $i$f$catch2 = false;
                    Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
                    boolean $i$f$catch3 = false;
                    try {
                        boolean bl2 = false;
                        $file.delete();
                    }
                    catch (Throwable e$iv$iv$iv) {
                        String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                        LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
                    }
                    v0 = $onFileReceived.completeExceptionally(new IllegalStateException("File sending error on remote side: " + errorString));
                }
                break block6;
            }
            Unit unit = (Unit)FileTransmissionHandler.handleReceiveExperimental$catchAndReportFailure($onFileReceived, this$0, $request, () -> FileTransmissionHandler.handleReceiveExperimental$lambda$41$lambda$39($stream, bytes));
            if (unit == null) break block6;
            Unit it = unit;
            boolean bl = false;
            $bytesWritten.element += (long)bytes.length;
            if ($bytesWritten.element - ((Number)com.jetbrains.rd.util.reactive.InterfacesKt.valueOrDefault((IOptProperty)$session.getAckLength(), (Object)0L)).longValue() >= this$0.getAckSize() / (long)2) {
                $session.getAckLength().set((Object)$bytesWritten.element);
            }
        }
        return Unit.INSTANCE;
    }
}

