/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.module;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.text.UniqueNameGenerator;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.module.UnknownSourceRootType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.impl.JpsSerializationFormatException;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.UnknownSourceRootPropertiesSerializer;

@ApiStatus.Internal
public final class JpsModuleRootModelSerializer {
    private static final Logger LOG = Logger.getInstance(JpsModuleRootModelSerializer.class);
    public static final String URL_ATTRIBUTE = "url";
    public static final String CONTENT_TAG = "content";
    public static final String SOURCE_FOLDER_TAG = "sourceFolder";
    public static final String PACKAGE_PREFIX_ATTRIBUTE = "packagePrefix";
    public static final String IS_TEST_SOURCE_ATTRIBUTE = "isTestSource";
    public static final String EXCLUDE_FOLDER_TAG = "excludeFolder";
    public static final String EXCLUDE_PATTERN_TAG = "excludePattern";
    public static final String EXCLUDE_PATTERN_ATTRIBUTE = "pattern";
    public static final String ORDER_ENTRY_TAG = "orderEntry";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String SOURCE_FOLDER_TYPE = "sourceFolder";
    public static final String JDK_TYPE = "jdk";
    public static final String JDK_NAME_ATTRIBUTE = "jdkName";
    public static final String JDK_TYPE_ATTRIBUTE = "jdkType";
    public static final String INHERITED_JDK_TYPE = "inheritedJdk";
    public static final String LIBRARY_TYPE = "library";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String LEVEL_ATTRIBUTE = "level";
    public static final String LIBRARY_TAG = "library";
    public static final String MODULE_LIBRARY_TYPE = "module-library";
    public static final String MODULE_TYPE = "module";
    public static final String MODULE_NAME_ATTRIBUTE = "module-name";
    public static final String SOURCE_ROOT_TYPE_ATTRIBUTE = "type";
    public static final String JAVA_SOURCE_ROOT_TYPE_ID = "java-source";
    public static final String JAVA_TEST_ROOT_TYPE_ID = "java-test";
    private static final String GENERATED_LIBRARY_NAME_PREFIX = "#";

    public static void loadRootModel(JpsModule module, @Nullable Element rootModelComponent, @Nullable JpsSdkType<?> projectSdkType, @NotNull JpsPathMapper pathMapper) {
        if (pathMapper == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(0);
        }
        if (rootModelComponent == null) {
            return;
        }
        for (Element contentElement : JDOMUtil.getChildren((Element)rootModelComponent, (String)CONTENT_TAG)) {
            String url = JpsModuleRootModelSerializer.getRequiredAttribute(contentElement, URL_ATTRIBUTE);
            module.getContentRootsList().addUrl(url);
            for (Element sourceElement : JDOMUtil.getChildren((Element)contentElement, (String)"sourceFolder")) {
                module.addSourceRoot(JpsModuleRootModelSerializer.loadSourceRoot(sourceElement));
            }
            for (Element excludeElement : JDOMUtil.getChildren((Element)contentElement, (String)EXCLUDE_FOLDER_TAG)) {
                module.getExcludeRootsList().addUrl(JpsModuleRootModelSerializer.getRequiredAttribute(excludeElement, URL_ATTRIBUTE));
            }
            for (Element excludePatternElement : JDOMUtil.getChildren((Element)contentElement, (String)EXCLUDE_PATTERN_TAG)) {
                module.addExcludePattern(url, JpsModuleRootModelSerializer.getRequiredAttribute(excludePatternElement, EXCLUDE_PATTERN_ATTRIBUTE));
            }
        }
        JpsDependenciesList dependenciesList = module.getDependenciesList();
        dependenciesList.clear();
        JpsElementFactory elementFactory = JpsElementFactory.getInstance();
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        boolean moduleSourceAdded = false;
        for (Element orderEntry : JDOMUtil.getChildren((Element)rootModelComponent, (String)ORDER_ENTRY_TAG)) {
            String name;
            String type = orderEntry.getAttributeValue("type");
            if ("sourceFolder".equals(type)) {
                dependenciesList.addModuleSourceDependency();
                moduleSourceAdded = true;
                continue;
            }
            if (JDK_TYPE.equals(type)) {
                String sdkName = JpsModuleRootModelSerializer.getRequiredAttribute(orderEntry, JDK_NAME_ATTRIBUTE);
                String sdkTypeId = orderEntry.getAttributeValue(JDK_TYPE_ATTRIBUTE);
                JpsSdkType<?> sdkType = JpsSdkTableSerializer.getSdkType(sdkTypeId);
                dependenciesList.addSdkDependency(sdkType);
                JpsSdkTableSerializer.setSdkReference(module.getSdkReferencesTable(), sdkName, sdkType);
                if (!(sdkType instanceof JpsJavaSdkTypeWrapper)) continue;
                dependenciesList.addSdkDependency(JpsJavaSdkType.INSTANCE);
                continue;
            }
            if (INHERITED_JDK_TYPE.equals(type)) {
                JpsJavaSdkType sdkType = projectSdkType != null ? projectSdkType : JpsJavaSdkType.INSTANCE;
                dependenciesList.addSdkDependency(sdkType);
                if (!(sdkType instanceof JpsJavaSdkTypeWrapper)) continue;
                dependenciesList.addSdkDependency(JpsJavaSdkType.INSTANCE);
                continue;
            }
            if ("library".equals(type)) {
                name = JpsModuleRootModelSerializer.getRequiredAttribute(orderEntry, NAME_ATTRIBUTE);
                String level = JpsModuleRootModelSerializer.getRequiredAttribute(orderEntry, LEVEL_ATTRIBUTE);
                JpsElementReference<? extends JpsCompositeElement> ref = JpsLibraryTableSerializer.createLibraryTableReference(level);
                JpsLibraryDependency dependency = dependenciesList.addLibraryDependency(elementFactory.createLibraryReference(name, ref));
                JpsModuleRootModelSerializer.loadModuleDependencyProperties(dependency, orderEntry);
                continue;
            }
            if (MODULE_LIBRARY_TYPE.equals(type)) {
                Element moduleLibraryElement = orderEntry.getChild("library");
                if (moduleLibraryElement == null) continue;
                String name2 = moduleLibraryElement.getAttributeValue(NAME_ATTRIBUTE);
                if (name2 == null) {
                    name2 = GENERATED_LIBRARY_NAME_PREFIX;
                }
                String uniqueName = nameGenerator.generateUniqueName(name2);
                JpsLibrary library = JpsLibraryTableSerializer.loadLibrary(moduleLibraryElement, uniqueName, pathMapper);
                module.addModuleLibrary(library);
                JpsLibraryDependency dependency = dependenciesList.addLibraryDependency(library);
                JpsModuleRootModelSerializer.loadModuleDependencyProperties(dependency, orderEntry);
                continue;
            }
            if (!MODULE_TYPE.equals(type)) continue;
            name = JpsModuleRootModelSerializer.getRequiredAttribute(orderEntry, MODULE_NAME_ATTRIBUTE);
            JpsModuleDependency dependency = dependenciesList.addModuleDependency(elementFactory.createModuleReference(name));
            JpsModuleRootModelSerializer.loadModuleDependencyProperties(dependency, orderEntry);
        }
        if (!moduleSourceAdded) {
            dependenciesList.addModuleSourceDependency();
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadRootModel(module, rootModelComponent);
        }
    }

    @NotNull
    private static String getRequiredAttribute(Element element, String attribute) {
        String url = element.getAttributeValue(attribute);
        if (url == null) {
            throw new JpsSerializationFormatException("'" + attribute + "' attribute is missing in '" + element.getName() + "' tag");
        }
        String string = url;
        if (string == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static JpsModuleSourceRoot loadSourceRoot(Element sourceElement) {
        String sourceUrl = JpsModuleRootModelSerializer.getRequiredAttribute(sourceElement, URL_ATTRIBUTE);
        JpsModuleSourceRootPropertiesSerializer<?> serializer = JpsModuleRootModelSerializer.getSourceRootPropertiesSerializer(sourceElement);
        return JpsModuleRootModelSerializer.createSourceRoot(sourceUrl, serializer, sourceElement);
    }

    @NotNull
    private static <P extends JpsElement> JpsModuleSourceRoot createSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootPropertiesSerializer<P> serializer, @NotNull Element sourceElement) {
        if (url == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(2);
        }
        if (serializer == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(4);
        }
        JpsModuleSourceRoot jpsModuleSourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(url, (JpsModuleSourceRootType)serializer.getType(), serializer.loadProperties(sourceElement));
        if (jpsModuleSourceRoot == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(5);
        }
        return jpsModuleSourceRoot;
    }

    @NotNull
    private static JpsModuleSourceRootPropertiesSerializer<?> getSourceRootPropertiesSerializer(@NotNull Element sourceElement) {
        String typeAttribute;
        if (sourceElement == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(6);
        }
        if ((typeAttribute = sourceElement.getAttributeValue("type")) == null) {
            typeAttribute = Boolean.parseBoolean(sourceElement.getAttributeValue(IS_TEST_SOURCE_ATTRIBUTE)) ? JAVA_TEST_ROOT_TYPE_ID : JAVA_SOURCE_ROOT_TYPE_ID;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModuleSourceRootPropertiesSerializer<?> serializer : extension.getModuleSourceRootPropertiesSerializers()) {
                if (!serializer.getTypeId().equals(typeAttribute)) continue;
                JpsModuleSourceRootPropertiesSerializer<?> jpsModuleSourceRootPropertiesSerializer = serializer;
                if (jpsModuleSourceRootPropertiesSerializer == null) {
                    JpsModuleRootModelSerializer.$$$reportNull$$$0(7);
                }
                return jpsModuleSourceRootPropertiesSerializer;
            }
        }
        LOG.warn("Unknown module source root type " + typeAttribute);
        UnknownSourceRootPropertiesSerializer unknownSourceRootPropertiesSerializer = UnknownSourceRootPropertiesSerializer.forType(UnknownSourceRootType.getInstance(typeAttribute));
        if (unknownSourceRootPropertiesSerializer == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(8);
        }
        return unknownSourceRootPropertiesSerializer;
    }

    public static <P extends JpsElement> void saveSourceRoot(@NotNull Element contentElement, @NotNull String rootUrl, @NotNull JpsTypedModuleSourceRoot<P> root) {
        if (contentElement == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(9);
        }
        if (rootUrl == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(10);
        }
        if (root == null) {
            JpsModuleRootModelSerializer.$$$reportNull$$$0(11);
        }
        Element sourceElement = new Element("sourceFolder");
        sourceElement.setAttribute(URL_ATTRIBUTE, rootUrl);
        JpsModuleSourceRootPropertiesSerializer<P> serializer = JpsModuleRootModelSerializer.getSerializer(root.getRootType());
        if (serializer != null) {
            String typeId = serializer.getTypeId();
            if (!typeId.equals(JAVA_SOURCE_ROOT_TYPE_ID) && !typeId.equals(JAVA_TEST_ROOT_TYPE_ID)) {
                sourceElement.setAttribute("type", typeId);
            }
            serializer.saveProperties(root.getProperties(), sourceElement);
        }
        contentElement.addContent(sourceElement);
    }

    @Nullable
    private static <P extends JpsElement> JpsModuleSourceRootPropertiesSerializer<P> getSerializer(JpsModuleSourceRootType<P> type) {
        if (type instanceof UnknownSourceRootType) {
            return UnknownSourceRootPropertiesSerializer.forType((UnknownSourceRootType)type);
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModuleSourceRootPropertiesSerializer<?> serializer : extension.getModuleSourceRootPropertiesSerializers()) {
                if (!((JpsModuleSourceRootType)serializer.getType()).equals(type)) continue;
                return serializer;
            }
        }
        return null;
    }

    private static void loadModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadModuleDependencyProperties(dependency, orderEntry);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTRIBUTE;
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSourceRoot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootPropertiesSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadRootModel";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootPropertiesSerializer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveSourceRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

