/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.fus;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.RoundedIntEventField;
import com.intellij.internal.statistic.eventLog.events.RoundedLongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.jupyter.core.fus.JupyterErrorType;
import com.intellij.jupyter.core.fus.JupyterFusAddTagResult;
import com.intellij.jupyter.core.fus.JupyterFusAddTagSource;
import com.intellij.jupyter.core.fus.JupyterFusCellRunStatus;
import com.intellij.jupyter.core.fus.JupyterFusScreenScale;
import com.intellij.jupyter.core.fus.JupyterInstallSource;
import com.intellij.jupyter.core.fus.TableDataTypeValidationRule;
import com.intellij.jupyter.core.fus.WidgetsToCollectStatistic;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.models.WidgetScriptSource;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.notebooks.visualization.outputs.statistic.NotebookOutputKeyType;
import java.time.Duration;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/fus/JupyterFeaturesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFeaturesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFeaturesCollector.kt\ncom/intellij/jupyter/core/fus/JupyterFeaturesCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,235:1\n249#2,3:236\n249#2,3:239\n249#2,3:242\n90#2,3:245\n249#2,3:248\n249#2,3:251\n249#2,3:254\n249#2,3:257\n249#2,3:260\n249#2,3:263\n249#2,3:266\n249#2,3:269\n249#2,3:272\n249#2,3:275\n*S KotlinDebug\n*F\n+ 1 JupyterFeaturesCollector.kt\ncom/intellij/jupyter/core/fus/JupyterFeaturesCollector\n*L\n21#1:236,3\n31#1:239,3\n32#1:242,3\n33#1:245,3\n50#1:248,3\n51#1:251,3\n63#1:254,3\n70#1:257,3\n77#1:260,3\n93#1:263,3\n99#1:266,3\n100#1:269,3\n114#1:272,3\n120#1:275,3\n*E\n"})
public final class JupyterFeaturesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final EventId1<NotebookOutputKeyType> outputEvent;
    @NotNull
    private static final PrimitiveEventField<String> versionField;
    @NotNull
    private static final RoundedIntEventField notebookSizeField;
    @NotNull
    private static final RoundedIntEventField cellCountField;
    @NotNull
    private static final RoundedIntEventField cellCodeCountField;
    @NotNull
    private static final RoundedIntEventField cellMarkdownCountField;
    @NotNull
    private static final RoundedIntEventField cellSqlCountField;
    @NotNull
    private static final RoundedIntEventField cellWithTagsCountField;
    @NotNull
    private static final RoundedLongEventField executionDurationField;
    @NotNull
    private static final EnumEventField<JupyterExecutionStatus> executionStatusField;
    @NotNull
    private static final EnumEventField<MimeType> mimeTypeField;
    @NotNull
    private static final StringEventField tableTypeField;
    @NotNull
    private static final VarargEventId notebookOpenEvent;
    @NotNull
    private static final EventId2<Integer, Integer> notebookLoadedTimeEvent;
    @NotNull
    private static final EventId1<Integer> notebookLoadedMemoryEvent;
    @NotNull
    private static final EnumEventField<WidgetsToCollectStatistic> widgetField;
    @NotNull
    private static final EventId2<WidgetsToCollectStatistic, WidgetScriptSource.Source> widgetLoadEvent;
    @NotNull
    private static final EventId1<WidgetsToCollectStatistic> widgetLoadErrorEvent;
    @NotNull
    private static final EventId1<Long> fileDownloadFromCefEvent;
    @NotNull
    private static final VarargEventId executionFinishEvent;
    @NotNull
    private static final EventId2<JupyterErrorType, Long> executionFinishErrorEvent;
    @NotNull
    private static final EventId2<Boolean, JupyterInstallSource> jupyterInstallPackage;
    @NotNull
    private static final EventId outputLinkToCellEvent;
    @NotNull
    private static final EventId1<JupyterFusCellRunStatus> jupyterGotoRunningCell;
    @NotNull
    private static final EventId2<Boolean, Long> finishedCellNotificationSettingSwitched;
    @NotNull
    private static final EventId1<Long> finishedCellNotificationDurationChanged;
    @NotNull
    private static final EventId2<JupyterFusCellRunStatus, Long> finishedCellNotificationClicked;
    @NotNull
    private static final EventId2<JupyterFusAddTagSource, JupyterFusAddTagResult> addTagEvent;
    @NotNull
    private static final EventId removeTagEvent;
    @NotNull
    private static final EventId interruptKernelEvent;
    @NotNull
    private static final EventId consoleOpenEvent;
    @NotNull
    private static final EventId1<Long> runSelectionInConsoleEvent;
    @NotNull
    private static final EventId2<JupyterFusCellRunStatus, Long> finishedCellNotificationShown;
    @NotNull
    private static final EventId2<Boolean, JupyterFusScreenScale> cefOutputUpdateErrorEvent;
    @NotNull
    private static final EventId1<Boolean> restoreRemoteSessionClickedEvent;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        EventFields $this$iv;
        Companion = new Companion(null);
        GROUP = new EventLogGroup("jupyter.features", 22, null, 4, null);
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "output_type";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        outputEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"showed.output", (EventField)((EventField)new EnumEventField(name$iv, NotebookOutputKeyType.class, null, transform$iv)), null, (int)4, null);
        versionField = EventFields.Version;
        notebookSizeField = EventFields.RoundedInt((String)"notebook_size_kb");
        cellCountField = EventFields.RoundedInt((String)"cell_count");
        cellCodeCountField = EventFields.RoundedInt((String)"cell_code_count");
        cellMarkdownCountField = EventFields.RoundedInt((String)"cell_markdown_count");
        cellSqlCountField = EventFields.RoundedInt((String)"cell_sql_count");
        cellWithTagsCountField = EventFields.RoundedInt((String)"cell_with_tags_count");
        executionDurationField = EventFields.RoundedLong$default((String)"execution_duration_ms", null, (int)2, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "status";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        executionStatusField = new EnumEventField(name$iv, JupyterExecutionStatus.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "mimeType";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        mimeTypeField = new EnumEventField(name$iv, MimeType.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "tableType";
        String description$iv = null;
        boolean $i$f$StringValidatedByCustomRule = false;
        tableTypeField = EventFields.StringValidatedByCustomRule((String)name$iv, TableDataTypeValidationRule.class, description$iv);
        $this$iv = new EventFields[]{versionField, notebookSizeField, cellCountField, cellCodeCountField, cellMarkdownCountField, cellSqlCountField, cellWithTagsCountField};
        notebookOpenEvent = GROUP.registerVarargEvent("notebook.opened", (EventField[])$this$iv);
        notebookLoadedTimeEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"notebook.loaded.time", (EventField)((EventField)EventFields.RoundedInt((String)"full_load_time_ms")), (EventField)((EventField)EventFields.RoundedInt((String)"post_editor_init_load_time_ms")), null, (int)8, null);
        notebookLoadedMemoryEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"notebook.loaded.memory", (EventField)((EventField)EventFields.RoundedInt((String)"memory_used_kb")), null, (int)4, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "widget";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        widgetField = new EnumEventField(name$iv, WidgetsToCollectStatistic.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        widgetLoadEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"widget.loaded", (EventField)((EventField)widgetField), (EventField)((EventField)new EnumEventField(name$iv, WidgetScriptSource.Source.class, null, transform$iv)), null, (int)8, null);
        widgetLoadErrorEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"widget.error.load", (EventField)((EventField)widgetField), null, (int)4, null);
        fileDownloadFromCefEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"file.download.from.cef", (EventField)((EventField)EventFields.RoundedLong$default((String)"file_size", null, (int)2, null)), null, (int)4, null);
        $this$iv = new EventFields[]{executionStatusField, mimeTypeField, tableTypeField, executionDurationField};
        executionFinishEvent = GROUP.registerVarargEvent("execution.finished", (EventField[])$this$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        executionFinishErrorEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"execution.finished.error", (EventField)((EventField)new EnumEventField(name$iv, JupyterErrorType.class, null, transform$iv)), (EventField)((EventField)executionDurationField), null, (int)8, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "resultType";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        jupyterInstallPackage = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.install.package", (EventField)((EventField)EventFields.Boolean((String)"isSuccess")), (EventField)((EventField)new EnumEventField(name$iv, JupyterInstallSource.class, null, transform$iv)), null, (int)8, null);
        outputLinkToCellEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"link.to.cell.in.output.is.clicked", null, (int)2, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "cellRunStatus";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        jupyterGotoRunningCell = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.click.goto.button", (EventField)((EventField)new EnumEventField(name$iv, JupyterFusCellRunStatus.class, null, transform$iv)), null, (int)4, null);
        finishedCellNotificationSettingSwitched = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.cell.finished.notification.setting.changed", (EventField)((EventField)EventFields.Boolean((String)"changedTo")), (EventField)((EventField)EventFields.Long$default((String)"durationSeconds", null, (int)2, null)), null, (int)8, null);
        finishedCellNotificationDurationChanged = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.cell.finished.notification.duration.changed", (EventField)((EventField)EventFields.Long$default((String)"durationChangedTo", null, (int)2, null)), null, (int)4, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "cellStatus";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        finishedCellNotificationClicked = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.cell.finished.notification.clicked", (EventField)((EventField)new EnumEventField(name$iv, JupyterFusCellRunStatus.class, null, transform$iv)), (EventField)((EventField)EventFields.Long$default((String)"durationSeconds", null, (int)2, null)), null, (int)8, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "dialogCalledFrom";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        EnumEventField enumEventField = new EnumEventField(name$iv, JupyterFusAddTagSource.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "result";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        addTagEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.cell.add.tag.event", (EventField)((EventField)enumEventField), (EventField)((EventField)new EnumEventField(name$iv, JupyterFusAddTagResult.class, null, transform$iv)), null, (int)8, null);
        removeTagEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.cell.remove.tag", null, (int)2, null);
        interruptKernelEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.interrupt.kernel", null, (int)2, null);
        consoleOpenEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.console.open", null, (int)2, null);
        runSelectionInConsoleEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.run.selection.in.console", (EventField)((EventField)EventFields.Long$default((String)"numberLines", null, (int)2, null)), null, (int)4, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "cellStatus";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        finishedCellNotificationShown = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.cell.finished.notification.shown", (EventField)((EventField)new EnumEventField(name$iv, JupyterFusCellRunStatus.class, null, transform$iv)), (EventField)((EventField)EventFields.Long$default((String)"durationSeconds", null, (int)2, null)), null, (int)8, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "screenScale";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        cefOutputUpdateErrorEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.cell.cef.update.error", (EventField)((EventField)EventFields.Boolean((String)"hiDpi")), (EventField)((EventField)new EnumEventField(name$iv, JupyterFusScreenScale.class, null, transform$iv)), null, (int)8, null);
        restoreRemoteSessionClickedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"jupyter.restored.remote.session", (EventField)((EventField)EventFields.Boolean((String)"isSuccess")), null, (int)4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\bJ>\u0010D\u001a\u00020B2\u0006\u0010E\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020 2\u0006\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020 2\u0006\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020 J\u0016\u0010L\u001a\u00020B2\u0006\u0010M\u001a\u00020(2\u0006\u0010N\u001a\u00020(J\u000e\u0010O\u001a\u00020B2\u0006\u0010P\u001a\u00020(J\u000e\u0010Q\u001a\u00020B2\u0006\u0010R\u001a\u00020#J\u0016\u0010S\u001a\u00020B2\u0006\u0010R\u001a\u00020#2\u0006\u0010T\u001a\u00020%J\u000e\u0010U\u001a\u00020B2\u0006\u0010V\u001a\u00020(J \u0010W\u001a\u00020B2\u0006\u0010X\u001a\u00020+2\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020ZJ0\u0010\\\u001a\u00020B2\u0006\u0010]\u001a\u00020\u00172\u0006\u0010^\u001a\u00020\u00192\u0006\u0010_\u001a\u00020\u000b2\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020ZJ\u0006\u0010`\u001a\u00020BJ\u0016\u0010a\u001a\u00020B2\u0006\u0010T\u001a\u00020.2\u0006\u0010b\u001a\u00020-J\u000e\u0010c\u001a\u00020B2\u0006\u0010d\u001a\u000202J\u0016\u0010e\u001a\u00020B2\u0006\u0010f\u001a\u0002022\u0006\u0010g\u001a\u00020(J\u0016\u0010h\u001a\u00020B2\u0006\u0010f\u001a\u0002022\u0006\u0010g\u001a\u00020(J\u0016\u0010i\u001a\u00020B2\u0006\u0010j\u001a\u00020-2\u0006\u0010g\u001a\u00020(J\u000e\u0010k\u001a\u00020B2\u0006\u0010g\u001a\u00020(J\u0016\u0010l\u001a\u00020B2\u0006\u0010T\u001a\u0002072\u0006\u0010m\u001a\u000208J\u0006\u0010n\u001a\u00020BJ\u0006\u0010o\u001a\u00020BJ\u0006\u0010p\u001a\u00020BJ\u000e\u0010q\u001a\u00020B2\u0006\u0010r\u001a\u00020(J\u0016\u0010s\u001a\u00020B2\u0006\u0010t\u001a\u00020-2\u0006\u0010u\u001a\u00020vJ\u000e\u0010w\u001a\u00020B2\u0006\u0010b\u001a\u00020-R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020%0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020(0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020(0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020(0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020(0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u0002080\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020(0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020(0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020?0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020-0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/intellij/jupyter/core/fus/JupyterFeaturesCollector$Companion;", "", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "outputEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/intellij/notebooks/visualization/outputs/statistic/NotebookOutputKeyType;", "versionField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "notebookSizeField", "Lcom/intellij/internal/statistic/eventLog/events/RoundedIntEventField;", "cellCountField", "cellCodeCountField", "cellMarkdownCountField", "cellSqlCountField", "cellWithTagsCountField", "executionDurationField", "Lcom/intellij/internal/statistic/eventLog/events/RoundedLongEventField;", "executionStatusField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "mimeTypeField", "Lcom/intellij/jupyter/core/jupyter/nbformat/MimeType;", "tableTypeField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "notebookOpenEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "notebookLoadedTimeEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "notebookLoadedMemoryEvent", "widgetField", "Lcom/intellij/jupyter/core/fus/WidgetsToCollectStatistic;", "widgetLoadEvent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/models/WidgetScriptSource$Source;", "widgetLoadErrorEvent", "fileDownloadFromCefEvent", "", "executionFinishEvent", "executionFinishErrorEvent", "Lcom/intellij/jupyter/core/fus/JupyterErrorType;", "jupyterInstallPackage", "", "Lcom/intellij/jupyter/core/fus/JupyterInstallSource;", "outputLinkToCellEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "jupyterGotoRunningCell", "Lcom/intellij/jupyter/core/fus/JupyterFusCellRunStatus;", "finishedCellNotificationSettingSwitched", "finishedCellNotificationDurationChanged", "finishedCellNotificationClicked", "addTagEvent", "Lcom/intellij/jupyter/core/fus/JupyterFusAddTagSource;", "Lcom/intellij/jupyter/core/fus/JupyterFusAddTagResult;", "removeTagEvent", "interruptKernelEvent", "consoleOpenEvent", "runSelectionInConsoleEvent", "finishedCellNotificationShown", "cefOutputUpdateErrorEvent", "Lcom/intellij/jupyter/core/fus/JupyterFusScreenScale;", "restoreRemoteSessionClickedEvent", "registryOutputType", "", "outputKeyType", "notebookOpened", "version", "size", "cellCount", "cellCode", "cellMarkdown", "cellSql", "cellWithTags", "notebookLoadedTime", "fullLoad", "postEditInitTime", "notebookLoadedMemory", "memoryUsed", "widgetLoadError", "widget", "widgetIsLoaded", "source", "collectFileDownLoadFromCef", "totalBytes", "executionFinishError", "errorType", "startTime", "Ljava/time/ZonedDateTime;", "endTime", "executionFinish", "jupyterStatus", "mimeType", "tableDataType", "onLinkToCellInError", "jupyterPackageInstallResult", "isSuccess", "onClickGotoButton", "cellRunStatus", "onClickCellFinishedNotification", "cellStatus", "durationSeconds", "onCellFinishedNotificationShown", "onCellFinishedNotificationSettingChanged", "newSetting", "onCellFinishedNotificationDurationChanged", "onAddTagDialogClosed", "result", "onCellTagRemoved", "onInterruptKernel", "onConsoleOpen", "onRunSelectionInConsole", "numLines", "onCefOutputUpdateError", "hiDpi", "screenScale", "", "onRestoreRemoteSessionClicked", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void registryOutputType(@NotNull NotebookOutputKeyType outputKeyType) {
            Intrinsics.checkNotNullParameter((Object)outputKeyType, (String)"outputKeyType");
            outputEvent.log((Object)outputKeyType);
        }

        public final void notebookOpened(@NotNull String version, int size, int cellCount, int cellCode, int cellMarkdown, int cellSql, int cellWithTags) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            EventPair[] eventPairArray = new EventPair[]{new EventPair((EventField)versionField, (Object)version), new EventPair((EventField)notebookSizeField, (Object)size), new EventPair((EventField)cellCountField, (Object)cellCount), new EventPair((EventField)cellCodeCountField, (Object)cellCode), new EventPair((EventField)cellMarkdownCountField, (Object)cellMarkdown), new EventPair((EventField)cellSqlCountField, (Object)cellSql), new EventPair((EventField)cellWithTagsCountField, (Object)cellWithTags)};
            notebookOpenEvent.log(eventPairArray);
        }

        public final void notebookLoadedTime(long fullLoad, long postEditInitTime) {
            notebookLoadedTimeEvent.log((Object)((int)fullLoad), (Object)((int)postEditInitTime));
        }

        public final void notebookLoadedMemory(long memoryUsed) {
            notebookLoadedMemoryEvent.log((Object)((int)memoryUsed));
        }

        public final void widgetLoadError(@NotNull WidgetsToCollectStatistic widget) {
            Intrinsics.checkNotNullParameter((Object)((Object)widget), (String)"widget");
            widgetLoadErrorEvent.log((Object)widget);
        }

        public final void widgetIsLoaded(@NotNull WidgetsToCollectStatistic widget, @NotNull WidgetScriptSource.Source source) {
            Intrinsics.checkNotNullParameter((Object)((Object)widget), (String)"widget");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            widgetLoadEvent.log((Object)widget, (Object)source);
        }

        public final void collectFileDownLoadFromCef(long totalBytes) {
            fileDownloadFromCefEvent.log((Object)totalBytes);
        }

        public final void executionFinishError(@NotNull JupyterErrorType errorType, @Nullable ZonedDateTime startTime, @NotNull ZonedDateTime endTime) {
            Intrinsics.checkNotNullParameter((Object)((Object)errorType), (String)"errorType");
            Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
            ZonedDateTime zonedDateTime = startTime;
            long durationMs = zonedDateTime != null ? Duration.between(zonedDateTime, endTime).toMillis() : 0L;
            executionFinishErrorEvent.log((Object)errorType, (Object)durationMs);
        }

        public final void executionFinish(@NotNull JupyterExecutionStatus jupyterStatus, @NotNull MimeType mimeType, @NotNull String tableDataType, @Nullable ZonedDateTime startTime, @NotNull ZonedDateTime endTime) {
            Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
            Intrinsics.checkNotNullParameter((Object)((Object)mimeType), (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)tableDataType, (String)"tableDataType");
            Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
            ZonedDateTime zonedDateTime = startTime;
            long durationMs = zonedDateTime != null ? Duration.between(zonedDateTime, endTime).toMillis() : 0L;
            EventPair[] eventPairArray = new EventPair[]{new EventPair((EventField)executionStatusField, (Object)jupyterStatus), new EventPair((EventField)mimeTypeField, (Object)mimeType), new EventPair((EventField)tableTypeField, (Object)tableDataType), new EventPair((EventField)executionDurationField, (Object)durationMs)};
            executionFinishEvent.log(eventPairArray);
        }

        public final void onLinkToCellInError() {
            outputLinkToCellEvent.log();
        }

        public final void jupyterPackageInstallResult(@NotNull JupyterInstallSource source, boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            jupyterInstallPackage.log((Object)isSuccess, (Object)source);
        }

        public final void onClickGotoButton(@NotNull JupyterFusCellRunStatus cellRunStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)cellRunStatus), (String)"cellRunStatus");
            jupyterGotoRunningCell.log((Object)cellRunStatus);
        }

        public final void onClickCellFinishedNotification(@NotNull JupyterFusCellRunStatus cellStatus, long durationSeconds) {
            Intrinsics.checkNotNullParameter((Object)((Object)cellStatus), (String)"cellStatus");
            finishedCellNotificationClicked.log((Object)cellStatus, (Object)durationSeconds);
        }

        public final void onCellFinishedNotificationShown(@NotNull JupyterFusCellRunStatus cellStatus, long durationSeconds) {
            Intrinsics.checkNotNullParameter((Object)((Object)cellStatus), (String)"cellStatus");
            finishedCellNotificationShown.log((Object)cellStatus, (Object)durationSeconds);
        }

        public final void onCellFinishedNotificationSettingChanged(boolean newSetting, long durationSeconds) {
            finishedCellNotificationSettingSwitched.log((Object)newSetting, (Object)durationSeconds);
        }

        public final void onCellFinishedNotificationDurationChanged(long durationSeconds) {
            finishedCellNotificationDurationChanged.log((Object)durationSeconds);
        }

        public final void onAddTagDialogClosed(@NotNull JupyterFusAddTagSource source, @NotNull JupyterFusAddTagResult result) {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
            addTagEvent.log((Object)source, (Object)result);
        }

        public final void onCellTagRemoved() {
            removeTagEvent.log();
        }

        public final void onInterruptKernel() {
            interruptKernelEvent.log();
        }

        public final void onConsoleOpen() {
            consoleOpenEvent.log();
        }

        public final void onRunSelectionInConsole(long numLines) {
            runSelectionInConsoleEvent.log((Object)numLines);
        }

        public final void onCefOutputUpdateError(boolean hiDpi, float screenScale) {
            cefOutputUpdateErrorEvent.log((Object)hiDpi, (Object)JupyterFusScreenScale.Companion.getCurrentScale(screenScale));
        }

        public final void onRestoreRemoteSessionClicked(boolean isSuccess) {
            restoreRemoteSessionClickedEvent.log((Object)isSuccess);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

