/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.data.input.InputCellFileAction;
import com.intellij.jupyter.core.jupyter.data.input.InputCellTableAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterAttachNewFileAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputFileName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputTableInfo;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputValuesContributorExtensionPoint;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fileName", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;", "tableInfo", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputTableInfo;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputTableInfo;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "createLabel", "Ljavax/swing/JLabel;", "text", "font", "Ljava/awt/Font;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputSelectPopupAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputSelectPopupAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,199:1\n1374#2:200\n1460#2,5:201\n1374#2:206\n1460#2,5:207\n1491#2:212\n1516#2,3:213\n1519#2,3:223\n382#3,7:216\n216#4,2:226\n*S KotlinDebug\n*F\n+ 1 JupyterDataInputSelectPopupAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction\n*L\n115#1:200\n115#1:201,5\n116#1:206\n116#1:207,5\n129#1:212\n129#1:213,3\n129#1:223,3\n129#1:216,7\n129#1:226,2\n*E\n"})
public final class JupyterDataInputSelectPopupAction
extends DumbAwareAction
implements CustomComponentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final JupyterDataInputFileName fileName;
    @NotNull
    private final JupyterDataInputTableInfo tableInfo;
    @NotNull
    private static final Key<String> IS_FILE_OR_TABLE_SET;

    public JupyterDataInputSelectPopupAction(@NotNull Editor editor, @NotNull JupyterDataInputFileName fileName, @NotNull JupyterDataInputTableInfo tableInfo) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)tableInfo, (String)"tableInfo");
        this.editor = editor;
        this.fileName = fileName;
        this.tableInfo = tableInfo;
        Presentation it = presentation = this.getTemplatePresentation();
        boolean bl = false;
        it.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        it.putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String name = this.fileName.get();
        if (name != null) {
            e.getPresentation().setText(StringUtil.escapeMnemonics((String)name));
            e.getPresentation().putClientProperty(IS_FILE_OR_TABLE_SET, (Object)"FILE");
        } else if (this.tableInfo.hasData()) {
            String tableName = this.tableInfo.getTableName();
            Presentation presentation = e.getPresentation();
            String string = tableName;
            if (string == null) {
                string = "";
            }
            presentation.setText(StringUtil.escapeMnemonics((String)string));
            e.getPresentation().putClientProperty(IS_FILE_OR_TABLE_SET, (Object)"TABLE");
        } else {
            e.getPresentation().setText(JupyterBundle.message("jupyter.data.input.toolbar.dnd.text.no.file", new Object[0]));
            e.getPresentation().putClientProperty(IS_FILE_OR_TABLE_SET, (Object)"NOTHING");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        JComponent component2 = jComponent;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JBPopup popup = this.createPopup(dataContext, project2);
        if (popup == null) {
            JupyterAttachNewFileAction.Companion.attachNewFile$intellij_jupyter_core(project2, this.editor, this.fileName);
        } else {
            popup.showUnderneathOf((Component)component2);
        }
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButtonWithText button2 = new ActionButtonWithText(this, presentation, place, dimension){

            public Insets getInsets() {
                JBInsets jBInsets = JBInsets.emptyInsets();
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
                return (Insets)jBInsets;
            }

            protected boolean shallPaintDownArrow() {
                return true;
            }
        };
        button2.setHorizontalTextAlignment(2);
        button2.setFont((Font)JBFont.small());
        String text = this.fileName.get() != null ? JupyterBundle.message("jupyter.data.input.toolbar.file", new Object[0]) : JupyterBundle.message("jupyter.data.input.toolbar.table", new Object[0]);
        Font font = button2.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        JLabel textLabel = this.createLabel(text, font);
        textLabel.setVisible(this.fileName.get() != null || this.tableInfo.hasData());
        presentation.addPropertyChangeListener(arg_0 -> JupyterDataInputSelectPopupAction.createCustomComponent$lambda$1(this, textLabel, arg_0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(textLabel);
        panel.add((Component)button2);
        return panel;
    }

    private final JLabel createLabel(@Nls String text, Font font) {
        JLabel label = new JLabel(text);
        label.setFont(font);
        label.setForeground(UIUtil.getLabelInfoForeground());
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        return label;
    }

    /*
     * WARNING - void declaration
     */
    private final JBPopup createPopup(DataContext dataContext, Project project) {
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        Iterable $this$flatMap$iv = JupyterDataInputValuesContributorExtensionPoint.Companion.getEP_NAME$intellij_jupyter_core().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            JupyterDataInputValuesContributorExtensionPoint it = (JupyterDataInputValuesContributorExtensionPoint)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles(project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files = (List)destination$iv$iv;
        Iterable $this$flatMap$iv2 = JupyterDataInputValuesContributorExtensionPoint.Companion.getEP_NAME$intellij_jupyter_core().getExtensionList();
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JupyterDataInputValuesContributorExtensionPoint it = (JupyterDataInputValuesContributorExtensionPoint)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTables(project);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List tables = (List)destination$iv$iv2;
        if (files.isEmpty() && tables.isEmpty()) {
            return null;
        }
        if (!((Collection)files).isEmpty()) {
            actionGroup.add((AnAction)Separator.create((String)JupyterBundle.message("jupyter.data.input.toolbar.text.files", new Object[0])));
            for (VirtualFile file : files) {
                actionGroup.add((AnAction)new InputCellFileAction(file, this.editor, this.fileName));
            }
        }
        if (!((Collection)tables).isEmpty()) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = tables;
            boolean $i$f$groupBy = false;
            $this$flatMapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                JupyterDataInputValuesContributorExtensionPoint.TableInfo it = (JupyterDataInputValuesContributorExtensionPoint.TableInfo)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getConnectionName();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String connectionName = (String)entry.getKey();
                List tables2 = (List)entry.getValue();
                actionGroup.add((AnAction)Separator.create((String)connectionName));
                for (JupyterDataInputValuesContributorExtensionPoint.TableInfo table : tables2) {
                    actionGroup.add((AnAction)new InputCellTableAction(table, this.tableInfo));
                }
            }
        }
        actionGroup.add((AnAction)Separator.getInstance());
        actionGroup.add((AnAction)new JupyterAttachNewFileAction(this.editor, this.fileName));
        Condition preselectCondition = arg_0 -> JupyterDataInputSelectPopupAction.createPopup$lambda$6(this, arg_0);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, null, -1, preselectCondition, null);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        return (JBPopup)popup;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final void createCustomComponent$lambda$1(JupyterDataInputSelectPopupAction this$0, JLabel $textLabel, PropertyChangeEvent event) {
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)IS_FILE_OR_TABLE_SET.toString())) {
            String text = this$0.fileName.get() != null ? JupyterBundle.message("jupyter.data.input.toolbar.file", new Object[0]) : JupyterBundle.message("jupyter.data.input.toolbar.table", new Object[0]);
            $textLabel.setText(text);
            $textLabel.setVisible(this$0.fileName.get() != null || this$0.tableInfo.hasData());
        }
    }

    private static final boolean createPopup$lambda$6(JupyterDataInputSelectPopupAction this$0, AnAction it) {
        return it instanceof InputCellFileAction && Intrinsics.areEqual((Object)((Object)((InputCellFileAction)it).getRelativePath()).toString(), (Object)this$0.fileName.get()) || it instanceof InputCellTableAction && Intrinsics.areEqual((Object)((InputCellTableAction)it).getJupyterTableInfo(), (Object)this$0.tableInfo);
    }

    static {
        Key key = Key.create((String)"IS_FILE_OR_TABLE_SET");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_FILE_OR_TABLE_SET = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction$Companion;", "", "<init>", "()V", "IS_FILE_OR_TABLE_SET", "Lcom/intellij/openapi/util/Key;", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

