/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterImageOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.ImageComponentWrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterImageOutputGutterIconRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "outputDataKey", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterImageOutputDataKey;", "imageComponent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageComponentWrapper;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterImageOutputDataKey;Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageComponentWrapper;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getOutputDataKey", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterImageOutputDataKey;", "getImageComponent", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageComponentWrapper;", "showCopyFeedback", "", "equals", "other", "", "hashCode", "", "getIcon", "Ljavax/swing/Icon;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "runCopyIconFeedback", "", "getTooltipText", "", "isNavigateAction", "intellij.jupyter.core"})
final class JupyterImageOutputGutterIconRenderer
extends GutterIconRenderer {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final JupyterImageOutputDataKey outputDataKey;
    @NotNull
    private final ImageComponentWrapper imageComponent;
    private boolean showCopyFeedback;

    public JupyterImageOutputGutterIconRenderer(@NotNull EditorImpl editor, @NotNull JupyterImageOutputDataKey outputDataKey, @NotNull ImageComponentWrapper imageComponent) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        Intrinsics.checkNotNullParameter((Object)imageComponent, (String)"imageComponent");
        this.editor = editor;
        this.outputDataKey = outputDataKey;
        this.imageComponent = imageComponent;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final JupyterImageOutputDataKey getOutputDataKey() {
        return this.outputDataKey;
    }

    @NotNull
    public final ImageComponentWrapper getImageComponent() {
        return this.imageComponent;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.editor.outputs.JupyterImageOutputGutterIconRenderer");
        JupyterImageOutputGutterIconRenderer cfr_ignored_0 = (JupyterImageOutputGutterIconRenderer)((Object)other);
        return Intrinsics.areEqual((Object)this.outputDataKey, (Object)((JupyterImageOutputGutterIconRenderer)((Object)other)).outputDataKey) && this.showCopyFeedback == ((JupyterImageOutputGutterIconRenderer)((Object)other)).showCopyFeedback;
    }

    public int hashCode() {
        return this.outputDataKey.hashCode() + 31 * Boolean.hashCode(this.showCopyFeedback);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon;
        if (this.showCopyFeedback) {
            Icon icon2 = AllIcons.General.GreenCheckmark;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GreenCheckmark");
        } else {
            Icon icon3 = AllIcons.Actions.Copy;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Copy");
        }
        return icon;
    }

    @Nullable
    public AnAction getClickAction() {
        return (AnAction)new DumbAwareAction(this){
            final /* synthetic */ JupyterImageOutputGutterIconRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DataContext dataContext = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                DataContext dataContext2 = dataContext;
                if (this.this$0.getImageComponent().isCopyEnabled(dataContext2)) {
                    this.this$0.getImageComponent().performCopy(dataContext2);
                    JupyterImageOutputGutterIconRenderer.access$runCopyIconFeedback(this.this$0);
                }
            }
        };
    }

    private final void runCopyIconFeedback() {
        this.showCopyFeedback = true;
        this.editor.getGutterComponentEx().repaint();
        Timer timer = new Timer(1000, arg_0 -> JupyterImageOutputGutterIconRenderer.runCopyIconFeedback$lambda$0(this, arg_0));
        timer.setRepeats(false);
        timer.start();
    }

    @NotNull
    public String getTooltipText() {
        return JupyterBundle.message("tooltip.copy.plot", new Object[0]);
    }

    public boolean isNavigateAction() {
        return true;
    }

    private static final void runCopyIconFeedback$lambda$0(JupyterImageOutputGutterIconRenderer this$0, ActionEvent event) {
        this$0.showCopyFeedback = false;
        this$0.editor.getGutterComponentEx().repaint();
    }

    public static final /* synthetic */ void access$runCopyIconFeedback(JupyterImageOutputGutterIconRenderer $this) {
        $this.runCopyIconFeedback();
    }
}

