/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.editor.settings.JupyterStructureShowPythonCellsMode;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterDisplayDataOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.core.jupyter.structure.JupyterCellTitleInfo;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureItemPresentation;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewModel;
import com.intellij.navigation.ItemPresentation;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001fH\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020'0\u00162\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "model", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "<init>", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;)V", "mdParser", "Lorg/intellij/markdown/parser/MarkdownParser;", "rootPresentation", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureItemPresentation;", "parentStack", "", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;", "settings", "Lcom/intellij/jupyter/core/editor/settings/JupyterSettings;", "getChildren", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "extractCellTitles", "", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterCellTitleInfo;", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "extractCodeCellTitles", "extractMarkdownCellTitles", "extractMarkdownOutputTitles", "extractMarkdownTitlesFromText", "text", "", "addToStructure", "", "titleInfo", "rootChildren", "handleCodeCellStatus", "extractNodeText", "node", "Lorg/intellij/markdown/ast/ASTNode;", "contentText", "collectTextNodes", "isMarkdownHeading", "", "getMarkdownTitleLevel", "", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getValue", "", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureViewRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureViewRoot.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1869#2,2:186\n1617#2,9:194\n1869#2:203\n1870#2:205\n1626#2:206\n1374#2:207\n1460#2,5:208\n774#2:213\n865#2,2:214\n1374#2:216\n1460#2,5:217\n1374#2:222\n1460#2,5:223\n1869#2,2:228\n37#3:188\n36#3,3:189\n183#4,2:192\n1#5:204\n*S KotlinDebug\n*F\n+ 1 JupyterStructureViewRoot.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot\n*L\n41#1:186,2\n85#1:194,9\n85#1:203\n85#1:205\n85#1:206\n91#1:207\n91#1:208,5\n149#1:213\n149#1:214,2\n150#1:216\n150#1:217,5\n158#1:222\n158#1:223,5\n103#1:228,2\n45#1:188\n45#1:189,3\n59#1:192,2\n85#1:204\n*E\n"})
public final class JupyterStructureViewRoot
implements StructureViewTreeElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterFile psiFile;
    @NotNull
    private final JupyterStructureViewModel model;
    @NotNull
    private final MarkdownParser mdParser;
    @NotNull
    private final JupyterStructureItemPresentation rootPresentation;
    @NotNull
    private final List<JupyterStructureViewCellElement> parentStack;
    @NotNull
    private final JupyterSettings settings;
    private static final int CODE_CELL_HEADING_LEVEL = 7;
    @NotNull
    private static final String CODE_CELL_HEADING_PREFIX = "# ";
    private static final int MAX_LABEL_LENGTH = 50;
    @NotNull
    private static final String TRUNCATION_SUFFIX = "...";
    @NotNull
    private static final Regex HTML_TAG_REGEX = new Regex("<[^>]*>");
    @NotNull
    private static final Regex MULTI_SPACE_REGEX = new Regex("\\s+");
    @NotNull
    private static final Map<IElementType, Integer> headingTypes;

    public JupyterStructureViewRoot(@NotNull JupyterFile psiFile, @NotNull JupyterStructureViewModel model) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.psiFile = psiFile;
        this.model = model;
        this.mdParser = new MarkdownParser((MarkdownFlavourDescriptor)new GFMFlavourDescriptor(false, false, false, 7, null));
        this.rootPresentation = new JupyterStructureItemPresentation(this.psiFile.getName(), null, null, 0);
        this.parentStack = new ArrayList();
        this.settings = JupyterSettings.Companion.getInstance();
    }

    @NotNull
    public TreeElement[] getChildren() {
        Document document = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        if (!NotebookCellLines.Companion.hasSupport(document)) {
            return new TreeElement[0];
        }
        Document document2 = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getFileDocument(...)");
        List intervals = NotebookCellLines.Companion.get(document2).getIntervals();
        List rootChildren = new ArrayList();
        this.parentStack.clear();
        for (NotebookCellLines.Interval interval : intervals) {
            List<JupyterCellTitleInfo> titles = this.extractCellTitles(interval);
            Iterable $this$forEach$iv = titles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JupyterCellTitleInfo it = (JupyterCellTitleInfo)element$iv;
                boolean bl = false;
                this.addToStructure(interval, it, rootChildren);
            }
            if (JupyterCellLinesExtensionsKt.toJupyterCellType(interval.getType()) != JupyterCellType.CODE) continue;
            this.handleCodeCellStatus(interval);
        }
        Collection $this$toTypedArray$iv = rootChildren;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TreeElement[0]);
    }

    private final List<JupyterCellTitleInfo> extractCellTitles(NotebookCellLines.Interval cell) {
        return switch (WhenMappings.$EnumSwitchMapping$0[JupyterCellLinesExtensionsKt.toJupyterCellType(cell.getType()).ordinal()]) {
            case 1 -> CollectionsKt.plus((Collection)this.extractCodeCellTitles(cell), (Iterable)this.extractMarkdownOutputTitles(cell));
            case 2 -> this.extractMarkdownCellTitles(cell);
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<JupyterCellTitleInfo> extractCodeCellTitles(NotebookCellLines.Interval cell) {
        Object title;
        boolean includeCell;
        Object v2;
        block5: {
            if (!this.settings.getShowPythonCellsInStructure()) {
                return CollectionsKt.emptyList();
            }
            Document document = this.psiFile.getFileDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
            CharSequence source = cell.getContentText(document);
            Sequence $this$firstOrNull$iv = StringsKt.lineSequence((CharSequence)source);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        String string = v2;
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String firstNonEmptyLine = string;
        boolean hasCodeHeading = StringsKt.startsWith$default((String)firstNonEmptyLine, (String)CODE_CELL_HEADING_PREFIX, (boolean)false, (int)2, null);
        boolean bl = includeCell = this.settings.getShowPythonCellsInStructureMode() == JupyterStructureShowPythonCellsMode.ALL || this.settings.getShowPythonCellsInStructureMode() == JupyterStructureShowPythonCellsMode.STARTS_WITH_COMMENT && hasCodeHeading;
        if (!includeCell) {
            return CollectionsKt.emptyList();
        }
        Object object = title = hasCodeHeading ? ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)firstNonEmptyLine, (CharSequence)CODE_CELL_HEADING_PREFIX))).toString() : firstNonEmptyLine;
        if (((String)title).length() > 50) {
            title = StringsKt.take((String)title, (int)50) + TRUNCATION_SUFFIX;
        }
        String label = cell.getOrdinal() + 1 + ". " + (String)title;
        return CollectionsKt.listOf((Object)new JupyterCellTitleInfo(7, label, JupyterCellType.CODE, hasCodeHeading));
    }

    private final List<JupyterCellTitleInfo> extractMarkdownCellTitles(NotebookCellLines.Interval cell) {
        Document document = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        String text = ((Object)cell.getContentText(document)).toString();
        return this.extractMarkdownTitlesFromText(text);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JupyterCellTitleInfo> extractMarkdownOutputTitles(NotebookCellLines.Interval cell) {
        void $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        JupyterCell jupyterCell = JupyterCellLinesExtensionsKt.toJupyterCell(cell, this.psiFile);
        if (jupyterCell == null) {
            return CollectionsKt.emptyList();
        }
        JupyterCell jupyterCell2 = jupyterCell;
        Object object = jupyterCell2.getOutputs();
        if (object != null && (object = object.getOutputs()) != null && (object = CollectionsKt.withIndex((Iterable)((Iterable)object))) != null) {
            void $this$mapNotNullTo$iv$iv;
            Object $this$mapNotNull$iv = object;
            boolean $i$f$mapNotNull = false;
            Object object2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IndexedValue indexedValue;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IndexedValue indexedValue2 = (IndexedValue)element$iv$iv;
                boolean bl2 = false;
                int index = indexedValue2.component1();
                JupyterOutput value = (JupyterOutput)indexedValue2.component2();
                Object object3 = value instanceof JupyterDisplayDataOutput ? (JupyterDisplayDataOutput)value : null;
                if (object3 == null || (object3 = ((JupyterDisplayDataOutput)object3).getData()) == null || (object3 = object3.getAsString(MimeType.TEXT_MARKDOWN.getMimeType())) == null) {
                    indexedValue = null;
                } else {
                    Object markdownOutput = object3;
                    indexedValue = new IndexedValue(index, markdownOutput);
                }
                if (indexedValue == null) continue;
                IndexedValue it$iv$iv = indexedValue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return CollectionsKt.emptyList();
        }
        List markdownOutputs = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = markdownOutputs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            destination$iv$iv = (IndexedValue)element$iv$iv;
            boolean bl = false;
            String markdownOutput = (String)destination$iv$iv.component2();
            Iterable list$iv$iv = this.extractMarkdownTitlesFromText(markdownOutput);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final List<JupyterCellTitleInfo> extractMarkdownTitlesFromText(String text) {
        ASTNode parsedTree = MarkdownParser.parse$default((MarkdownParser)this.mdParser, (IElementType)new IElementType("ROOT"), (String)text, (boolean)false, (int)4, null);
        List titles = new ArrayList();
        JupyterStructureViewRoot.extractMarkdownTitlesFromText$walk(this, text, titles, parsedTree);
        return titles;
    }

    private final void addToStructure(NotebookCellLines.Interval cell, JupyterCellTitleInfo titleInfo, List<JupyterStructureViewCellElement> rootChildren) {
        JupyterStructureViewCellElement structureViewElement = new JupyterStructureViewCellElement(cell, titleInfo.getTitle(), titleInfo.getLevel(), null, this.model, titleInfo.getCellType(), titleInfo.isCodeCellHeading());
        while (!((Collection)this.parentStack).isEmpty() && ((JupyterStructureViewCellElement)CollectionsKt.last(this.parentStack)).getLevel() >= titleInfo.getLevel()) {
            this.parentStack.remove(this.parentStack.size() - 1);
        }
        boolean bl = !((Collection)this.parentStack).isEmpty() ? ((JupyterStructureViewCellElement)CollectionsKt.last(this.parentStack)).addChild((TreeElement)structureViewElement) : rootChildren.add(structureViewElement);
        this.model.setIntervalToComponent(cell, structureViewElement);
        this.parentStack.add(structureViewElement);
    }

    private final void handleCodeCellStatus(NotebookCellLines.Interval cell) {
        JupyterStructureViewCellElement jupyterStructureViewCellElement = (JupyterStructureViewCellElement)CollectionsKt.lastOrNull(this.parentStack);
        if (jupyterStructureViewCellElement == null) {
            return;
        }
        JupyterStructureViewCellElement parentElement = jupyterStructureViewCellElement;
        parentElement.associateInterval(cell);
        this.model.setIntervalToComponent(cell, parentElement);
        parentElement.updateStatus(this.model.getCellStatus(cell.getOrdinal()));
    }

    /*
     * WARNING - void declaration
     */
    private final String extractNodeText(ASTNode node, String contentText) {
        void $this$flatMapTo$iv$iv;
        ASTNode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = node.getChildren();
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getType().getName(), (Object)"ATX_HEADER"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectTextNodes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        CharSequence charSequence = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, arg_0 -> JupyterStructureViewRoot.extractNodeText$lambda$7(contentText, arg_0), (int)30, null);
        Regex regex = HTML_TAG_REGEX;
        object = "";
        charSequence = regex.replace(charSequence, (String)object);
        regex = MULTI_SPACE_REGEX;
        object = " ";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, (String)object))).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> collectTextNodes(ASTNode node) {
        List list;
        if (node.getChildren().isEmpty()) {
            list = CollectionsKt.listOf((Object)node);
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = node.getChildren();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ASTNode it = (ASTNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.collectTextNodes(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final boolean isMarkdownHeading(ASTNode node) {
        return headingTypes.containsKey(node.getType());
    }

    private final int getMarkdownTitleLevel(ASTNode node) {
        Integer n = headingTypes.get(node.getType());
        if (n == null) {
            throw new IllegalStateException("Node is not a heading".toString());
        }
        return n;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return (ItemPresentation)this.rootPresentation;
    }

    @NotNull
    public Object getValue() {
        String string = this.psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final void extractMarkdownTitlesFromText$walk(JupyterStructureViewRoot this$0, String $text, List<JupyterCellTitleInfo> titles, ASTNode node) {
        if (this$0.isMarkdownHeading(node)) {
            String titleText = this$0.extractNodeText(node, $text);
            titles.add(new JupyterCellTitleInfo(this$0.getMarkdownTitleLevel(node), titleText, JupyterCellType.MARKDOWN, false, 8, null));
        }
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            JupyterStructureViewRoot.extractMarkdownTitlesFromText$walk(this$0, $text, titles, it);
        }
    }

    private static final CharSequence extractNodeText$lambda$7(String $contentText, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ASTUtilKt.getTextInNode((ASTNode)it, (CharSequence)$contentText);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.ATX_1, (Object)1), TuplesKt.to((Object)MarkdownElementTypes.ATX_2, (Object)2), TuplesKt.to((Object)MarkdownElementTypes.ATX_3, (Object)3), TuplesKt.to((Object)MarkdownElementTypes.ATX_4, (Object)4), TuplesKt.to((Object)MarkdownElementTypes.ATX_5, (Object)5), TuplesKt.to((Object)MarkdownElementTypes.ATX_6, (Object)6), TuplesKt.to((Object)MarkdownElementTypes.SETEXT_1, (Object)1), TuplesKt.to((Object)MarkdownElementTypes.SETEXT_2, (Object)2)};
        headingTypes = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot$Companion;", "", "<init>", "()V", "CODE_CELL_HEADING_LEVEL", "", "CODE_CELL_HEADING_PREFIX", "", "MAX_LABEL_LENGTH", "TRUNCATION_SUFFIX", "HTML_TAG_REGEX", "Lkotlin/text/Regex;", "MULTI_SPACE_REGEX", "headingTypes", "", "Lorg/intellij/markdown/IElementType;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterCellType.values().length];
            try {
                nArray[JupyterCellType.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.MARKDOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

