/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel;

import com.intellij.database.datagrid.color.TableHeatmapColorLayer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.scientific.tables.api.DSPanelInfo;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DisposableDSPanelInfo;
import com.intellij.scientific.tables.panel.DSTable;
import com.intellij.scientific.tables.panel.DSTableKt;
import com.intellij.scientific.tables.panel.DSTableProviderImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u0012H\u0002J*\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0017\u001a\u00020\u00112\b\b\u0001\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R!\u0010\u001e\u001a\u0015\u0012\f\u0012\n  *\u0004\u0018\u00010\u00110\u00110\u001f\u00a2\u0006\u0002\b!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/scientific/tables/panel/DSTableContentManager;", "", "<init>", "()V", "updateOrCreateTableContent", "", "project", "Lcom/intellij/openapi/project/Project;", "tableVariableExpression", "", "tableDataRetriever", "Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;", "panelInfo", "Lcom/intellij/scientific/tables/api/DisposableDSPanelInfo;", "dataType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "getContentWithTable", "Lcom/intellij/ui/content/Content;", "Lcom/intellij/scientific/tables/api/DSPanelInfo;", "createNewContentWithTable", "commandText", "createContentBasicWithTable", "title", "createContentBasic", "panel", "Ljavax/swing/JComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "registerContentDisposal", "content", "CONTENT_FOR_TABLE", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "UpdateOrCreateTableContentTask", "intellij.scientific.tables"})
@SourceDebugExtension(value={"SMAP\nDSTableContentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSTableContentManager.kt\ncom/intellij/scientific/tables/panel/DSTableContentManager\n+ 2 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,128:1\n56#2:129\n*S KotlinDebug\n*F\n+ 1 DSTableContentManager.kt\ncom/intellij/scientific/tables/panel/DSTableContentManager\n*L\n71#1:129\n*E\n"})
public final class DSTableContentManager {
    @NotNull
    public static final DSTableContentManager INSTANCE = new DSTableContentManager();
    @NotNull
    private static final Key<Content> CONTENT_FOR_TABLE;

    private DSTableContentManager() {
    }

    public final void updateOrCreateTableContent(@NotNull Project project, @NlsSafe @NotNull String tableVariableExpression, @NotNull DSTableDataRetrieverFromDataSource tableDataRetriever, @NotNull DisposableDSPanelInfo panelInfo, @NotNull DSTableDataType dataType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableVariableExpression, (String)"tableVariableExpression");
        Intrinsics.checkNotNullParameter((Object)tableDataRetriever, (String)"tableDataRetriever");
        Intrinsics.checkNotNullParameter((Object)panelInfo, (String)"panelInfo");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        UpdateOrCreateTableContentTask task = new UpdateOrCreateTableContentTask(project, tableVariableExpression, tableDataRetriever, panelInfo, dataType);
        if (panelInfo.isDisposed()) {
            return;
        }
        Disposer.register((Disposable)((Disposable)panelInfo), () -> DSTableContentManager.updateOrCreateTableContent$lambda$0(task));
        ApplicationManager.getApplication().invokeLater((Runnable)task);
    }

    /*
     * WARNING - void declaration
     */
    private final Content getContentWithTable(DSPanelInfo panelInfo) {
        void $this$getUserData$iv;
        JComponent jComponent = panelInfo.getMainPanel();
        Key<Content> key$iv = CONTENT_FOR_TABLE;
        boolean $i$f$getUserData = false;
        Object object = $this$getUserData$iv.getClientProperty(key$iv);
        if (!(object instanceof Content)) {
            object = null;
        }
        return (Content)object;
    }

    private final Content createNewContentWithTable(Project project, @NlsSafe String commandText, DSPanelInfo panelInfo, DSTableDataType dataType) {
        Content content = this.createContentBasicWithTable(project, commandText, panelInfo, dataType);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            panelInfo.getMainPanel().add(content.getComponent());
        }
        UiUtils.putUserData((JComponent)panelInfo.getMainPanel(), CONTENT_FOR_TABLE, (Object)content);
        return content;
    }

    private final Content createContentBasicWithTable(Project project, @NlsContexts.TabTitle String title, DSPanelInfo panelInfo, DSTableDataType dataType) {
        boolean enableHierarchicalSupport = Registry.Companion.is("grid.tables.hierarchical.enabled", false) && dataType == DSTableDataType.EXTERNAL;
        DSTable table = DSTableProviderImpl.INSTANCE.createTable(project, panelInfo, enableHierarchicalSupport, dataType);
        JComponent component = UiDataProvider.Companion.wrapComponent(table.getComponent(), arg_0 -> DSTableContentManager.createContentBasicWithTable$lambda$1(table, arg_0));
        Content content = this.createContentBasic(title, component, table.getDisposable());
        content.putUserData(DSTableKt.getDS_TABLE_KEY(), (Object)table);
        content.putUserData(TableHeatmapColorLayer.Companion.getHEATMAP_OLD_COLORS(), (Object)true);
        return content;
    }

    private final Content createContentBasic(@NlsContexts.TabTitle String title, JComponent panel, Disposable disposable) {
        Content content = ContentFactory.getInstance().createContent(panel, title, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setShouldDisposeContent(true);
        Disposer.register((Disposable)((Disposable)content2), (Disposable)disposable);
        return content2;
    }

    private final void registerContentDisposal(Content content, DisposableDSPanelInfo panelInfo, DSTableDataRetrieverFromDataSource tableDataRetriever) {
        Disposer.register((Disposable)((Disposable)panelInfo), (Disposable)((Disposable)content));
        tableDataRetriever.registerDisposable((Disposable)content);
    }

    private static final void updateOrCreateTableContent$lambda$0(UpdateOrCreateTableContentTask $task) {
        $task.setCanceled(true);
    }

    private static final void createContentBasicWithTable$lambda$1(DSTable $table, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(DSTableKt.getDS_TABLE_DATA_KEY(), (Object)$table);
    }

    static {
        Key key = Key.create((String)"CONTENT_FOR_TABLE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CONTENT_FOR_TABLE = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/intellij/scientific/tables/panel/DSTableContentManager$UpdateOrCreateTableContentTask;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "tableVariableExpression", "", "tableDataRetriever", "Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;", "panelInfo", "Lcom/intellij/scientific/tables/api/DisposableDSPanelInfo;", "dataType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;Lcom/intellij/scientific/tables/api/DisposableDSPanelInfo;Lcom/intellij/scientific/tables/api/DSTableDataType;)V", "canceled", "", "getCanceled", "()Z", "setCanceled", "(Z)V", "run", "", "intellij.scientific.tables"})
    private static final class UpdateOrCreateTableContentTask
    implements Runnable {
        @NotNull
        private final Project project;
        @NotNull
        private final String tableVariableExpression;
        @NotNull
        private final DSTableDataRetrieverFromDataSource tableDataRetriever;
        @NotNull
        private final DisposableDSPanelInfo panelInfo;
        @NotNull
        private final DSTableDataType dataType;
        private boolean canceled;

        public UpdateOrCreateTableContentTask(@NotNull Project project, @NotNull String tableVariableExpression, @NotNull DSTableDataRetrieverFromDataSource tableDataRetriever, @NotNull DisposableDSPanelInfo panelInfo, @NotNull DSTableDataType dataType) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)tableVariableExpression, (String)"tableVariableExpression");
            Intrinsics.checkNotNullParameter((Object)tableDataRetriever, (String)"tableDataRetriever");
            Intrinsics.checkNotNullParameter((Object)panelInfo, (String)"panelInfo");
            Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
            this.project = project;
            this.tableVariableExpression = tableVariableExpression;
            this.tableDataRetriever = tableDataRetriever;
            this.panelInfo = panelInfo;
            this.dataType = dataType;
        }

        public final boolean getCanceled() {
            return this.canceled;
        }

        public final void setCanceled(boolean bl) {
            this.canceled = bl;
        }

        @Override
        public void run() {
            block1: {
                DSTable table;
                block2: {
                    if (this.canceled) break block1;
                    Content content = INSTANCE.getContentWithTable(this.panelInfo);
                    Content content2 = content;
                    if (content2 == null) {
                        content2 = INSTANCE.createNewContentWithTable(this.project, this.tableVariableExpression, this.panelInfo, this.dataType);
                    }
                    Content finalContent = content2;
                    INSTANCE.registerContentDisposal(finalContent, this.panelInfo, this.tableDataRetriever);
                    table = (DSTable)finalContent.getUserData(DSTableKt.getDS_TABLE_KEY());
                    if (content != null) break block2;
                    DSTable dSTable = table;
                    if (dSTable == null) break block1;
                    dSTable.fetchData(this.tableDataRetriever, false);
                    break block1;
                }
                DSTable dSTable = table;
                if (dSTable == null) break block1;
                dSTable.fetchData(this.tableDataRetriever, true);
            }
        }
    }
}

