/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel;

import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.csv.CsvSettingsService;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilKt;
import com.intellij.database.datagrid.color.TableHeatmapColorLayer;
import com.intellij.database.extractors.BaseObjectFormatter;
import com.intellij.database.extractors.NestedTableAwareObjectFormatter;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.HierarchicalTableResultPanel;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelperImpl;
import com.intellij.database.run.ui.grid.renderers.CollapsedCellRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultBooleanRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultNumericRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.run.ui.grid.renderers.NestedTableCellRendererFactory;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.scientific.tables.DSDataHookUp;
import com.intellij.scientific.tables.api.DSPanelInfo;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.panel.DSGridHelper;
import com.intellij.scientific.tables.panel.DSTable;
import com.intellij.scientific.tables.panel.DSTableKt;
import com.intellij.scientific.tables.panel.DSTableProvider;
import com.intellij.scientific.tables.panel.DSTableProviderImpl;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.scientific.tables.panel.HierarchicalGridHelper;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/scientific/tables/panel/DSTableProviderImpl;", "Lcom/intellij/scientific/tables/panel/DSTableProvider;", "<init>", "()V", "createTable", "Lcom/intellij/scientific/tables/panel/DSTable;", "project", "Lcom/intellij/openapi/project/Project;", "panelInfo", "Lcom/intellij/scientific/tables/api/DSPanelInfo;", "enableHierarchicalSupport", "", "dataType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "getCellRendererFactories", "", "Lcom/intellij/database/run/ui/grid/renderers/GridCellRendererFactory;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "isHierarchicalTable", "configureCommonTableSettings", "", "appearance", "Lcom/intellij/database/datagrid/DataGridAppearance;", "helper", "Lcom/intellij/database/datagrid/GridHelper;", "getLeftToolbarActionsGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getRightToolbarActionsGroup", "intellij.scientific.tables"})
public final class DSTableProviderImpl
implements DSTableProvider {
    @NotNull
    public static final DSTableProviderImpl INSTANCE = new DSTableProviderImpl();

    private DSTableProviderImpl() {
    }

    @Override
    @NotNull
    public DSTable createTable(@NotNull Project project, @NotNull DSPanelInfo panelInfo, boolean enableHierarchicalSupport, @NotNull DSTableDataType dataType) {
        TableResultPanel tableResultPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)panelInfo, (String)"panelInfo");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        DSDataHookUp hookUp = new DSDataHookUp(project, enableHierarchicalSupport);
        DSGridHelper helper = new DSGridHelper(panelInfo.getInsideNotebook(), enableHierarchicalSupport ? hookUp.getDataModel() : null);
        GridUtilKt.setPageSize((GridDataHookUp)((GridDataHookUp)hookUp), (GridHelper)((GridHelper)helper));
        Function2 configureTable = (arg_0, arg_1) -> DSTableProviderImpl.createTable$lambda$1(helper, panelInfo, arg_0, arg_1);
        Function2 configureHierarchicalTable = (arg_0, arg_1) -> DSTableProviderImpl.createTable$lambda$3(helper, panelInfo, arg_0, arg_1);
        if (enableHierarchicalSupport) {
            var10_9 = ActionManager.getInstance().getAction("DS.Table.TableResult.PopupGroup");
            var11_10 = (arg_0, arg_1) -> DSTableProviderImpl.createTable$lambda$4(configureHierarchicalTable, arg_0, arg_1);
            tableResultPanel = (TableResultPanel)new HierarchicalTableResultPanel(project, hookUp, var10_9, var11_10){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    GridDataHookUp gridDataHookUp = (GridDataHookUp)$hookUp;
                    Intrinsics.checkNotNull((Object)$super_call_param$1, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                    super($project, gridDataHookUp, (ActionGroup)$super_call_param$1, $super_call_param$2);
                }

                protected void uiDataSnapshot(DataSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    super.uiDataSnapshot(sink);
                    DataKey dataKey = PlatformCoreDataKeys.FILE_EDITOR;
                    Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"FILE_EDITOR");
                    sink.set(dataKey, (Object)GridUtil.getOrCreateEditorWrapper((DataGrid)((DataGrid)this), (Project)this.$project, createTable.grid.1::uiDataSnapshot$lambda$0));
                }

                protected int getInitialPosition(GridColumn column) {
                    Intrinsics.checkNotNullParameter((Object)column, (String)"column");
                    return 0;
                }

                private static final String uiDataSnapshot$lambda$0() {
                    return "";
                }
            };
        } else {
            var10_9 = ActionManager.getInstance().getAction("DS.Table.TableResult.PopupGroup");
            var11_10 = (arg_0, arg_1) -> DSTableProviderImpl.createTable$lambda$5(configureTable, arg_0, arg_1);
            tableResultPanel = new TableResultPanel(project, hookUp, var10_9, var11_10){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    GridDataHookUp gridDataHookUp = (GridDataHookUp)$hookUp;
                    Intrinsics.checkNotNull((Object)$super_call_param$1, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                    super($project, gridDataHookUp, (ActionGroup)$super_call_param$1, $super_call_param$2);
                }

                protected void uiDataSnapshot(DataSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    super.uiDataSnapshot(sink);
                    DataKey dataKey = PlatformCoreDataKeys.FILE_EDITOR;
                    Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"FILE_EDITOR");
                    sink.set(dataKey, (Object)GridUtil.getOrCreateEditorWrapper((DataGrid)((DataGrid)this), (Project)this.$project, createTable.grid.2::uiDataSnapshot$lambda$0));
                }

                private static final String uiDataSnapshot$lambda$0() {
                    return "";
                }
            };
        }
        TableResultPanel grid2 = tableResultPanel;
        grid2.addResultViewMouseListener((MouseListener)new MouseAdapter(project, grid2){
            final /* synthetic */ Project $project;
            final /* synthetic */ TableResultPanel $grid;
            {
                this.$project = $project;
                this.$grid = $grid;
            }

            public void mouseClicked(MouseEvent e) {
                IdeFocusManager.getInstance((Project)this.$project).requestFocus((Component)this.$grid.getPreferredFocusedComponent(), true);
            }
        });
        ActionGroup leftToolbarActions = this.getLeftToolbarActionsGroup();
        ActionGroup rightToolbarActions = this.getRightToolbarActionsGroup(dataType);
        GridUtil.addGridHeaderComponent((DataGrid)((DataGrid)grid2), (boolean)true, (ActionGroup)leftToolbarActions, (ActionGroup)rightToolbarActions);
        DSTableWithStatistics dsTable = new DSTableWithStatistics((DataGrid)grid2, hookUp.getLoader());
        grid2.putUserData(DSTableKt.getDS_TABLE_KEY(), (Object)dsTable);
        grid2.putUserData(TableHeatmapColorLayer.Companion.getHEATMAP_OLD_COLORS(), (Object)true);
        return dsTable;
    }

    private final List<GridCellRendererFactory> getCellRendererFactories(DataGrid grid2, boolean isHierarchicalTable) {
        List list;
        Object[] objectArray = new GridCellRendererFactory[]{new DefaultBooleanRendererFactory(grid2), new DefaultNumericRendererFactory(grid2), new DefaultTextRendererFactory(grid2)};
        List defaultFactories = CollectionsKt.listOf((Object[])objectArray);
        if (isHierarchicalTable) {
            objectArray = new GridCellRendererFactory[]{new CollapsedCellRendererFactory(grid2), new NestedTableCellRendererFactory(grid2)};
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)defaultFactories);
        } else {
            list = defaultFactories;
        }
        return list;
    }

    private final void configureCommonTableSettings(DataGrid grid2, DataGridAppearance appearance, GridHelper helper, DSPanelInfo panelInfo) {
        block2: {
            GridCellEditorHelper.set((CoreGrid)((CoreGrid)grid2), (GridCellEditorHelper)((GridCellEditorHelper)new GridCellEditorHelperImpl()));
            GridHelper.set((CoreGrid)((CoreGrid)grid2), (GridHelper)helper);
            CsvFormatsSettings csvFormatsSettings = CsvSettingsService.getDatabaseSettings();
            GridUtil.putSettings((DataGrid)grid2, (DataGridSettings)(csvFormatsSettings instanceof DataGridSettings ? (DataGridSettings)csvFormatsSettings : null));
            appearance.setTransparentColumnHeaderBackground(false);
            appearance.setTransparentRowHeaderBackground(true);
            appearance.setAnonymousColumnName("");
            appearance.setResultViewAllowMultilineColumnLabels(true);
            appearance.setResultViewStriped(DataGridAppearanceSettings.getSettings().isStripedTable());
            appearance.addSpaceForHorizontalScrollbar(true);
            if (panelInfo.getScrollPastLastLine()) {
                appearance.setResultViewAdditionalRowsCount(5);
            }
            if (panelInfo.getShowBorder()) {
                grid2.getPanel().getComponent().setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)1));
            }
            DataGridSettings dataGridSettings = GridUtil.getSettings((DataGrid)grid2);
            if (dataGridSettings == null) break block2;
            dataGridSettings.setEnableLocalFilterByDefault(false);
        }
    }

    private final ActionGroup getLeftToolbarActionsGroup() {
        AnAction anAction = ActionManager.getInstance().getAction("DS.Tables.Left.Toolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        return (ActionGroup)anAction;
    }

    /*
     * WARNING - void declaration
     */
    private final ActionGroup getRightToolbarActionsGroup(DSTableDataType dataType) {
        ActionGroup actionGroup;
        if (PlatformUtils.isDataSpell()) {
            AnAction anAction = ActionManager.getInstance().getAction("DS.Tables.Right.Toolbar");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            actionGroup = (ActionGroup)anAction;
        } else if (dataType == DSTableDataType.EXTERNAL || dataType == DSTableDataType.KOTLIN_DATAFRAME) {
            AnAction anAction = ActionManager.getInstance().getAction("KT.Tables.Right.Toolbar");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            actionGroup = (ActionGroup)anAction;
        } else {
            void var2_2;
            DefaultActionGroup actionGroup2 = new DefaultActionGroup();
            AnAction customActionsGroup = CustomActionsSchema.Companion.getInstance().getCorrectedAction("PY.Tables.Right.Toolbar.Customize.Actions.Group");
            if (customActionsGroup != null) {
                actionGroup2.add(customActionsGroup);
            }
            actionGroup = (ActionGroup)var2_2;
        }
        return actionGroup;
    }

    private static final ObjectFormatter createTable$lambda$1$lambda$0(DataGrid dataGrid) {
        return (ObjectFormatter)new BaseObjectFormatter();
    }

    private static final Unit createTable$lambda$1(DSGridHelper $helper, DSPanelInfo $panelInfo, DataGrid grid2, DataGridAppearance appearance) {
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
        INSTANCE.configureCommonTableSettings(grid2, appearance, (GridHelper)$helper, $panelInfo);
        grid2.setObjectFormatterProvider(DSTableProviderImpl::createTable$lambda$1$lambda$0);
        GridCellRendererFactories.set((DataGrid)grid2, (GridCellRendererFactories)new GridCellRendererFactories(INSTANCE.getCellRendererFactories(grid2, false)));
        return Unit.INSTANCE;
    }

    private static final ObjectFormatter createTable$lambda$3$lambda$2(DataGrid dataGrid) {
        return (ObjectFormatter)new NestedTableAwareObjectFormatter();
    }

    private static final Unit createTable$lambda$3(DSGridHelper $helper, DSPanelInfo $panelInfo, DataGrid grid2, DataGridAppearance appearance) {
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
        INSTANCE.configureCommonTableSettings(grid2, appearance, new HierarchicalGridHelper($helper), $panelInfo);
        grid2.setObjectFormatterProvider(DSTableProviderImpl::createTable$lambda$3$lambda$2);
        GridCellRendererFactories.set((DataGrid)grid2, (GridCellRendererFactories)new GridCellRendererFactories(INSTANCE.getCellRendererFactories(grid2, true)));
        appearance.setResultViewSetShowHorizontalLines(true);
        appearance.setHoveredRowBgHighlightingEnabled(true);
        DataGridSettings dataGridSettings = GridUtil.getSettings((DataGrid)grid2);
        if (dataGridSettings != null) {
            dataGridSettings.setFloatingToolbarCustomizable(false);
        }
        appearance.setResultViewAdditionalRowsCount(Registry.Companion.intValue("grid.tables.hierarchical.additional.rows", 0));
        int defaultPageSize = Registry.Companion.intValue("grid.tables.hierarchical.default.page.size", -1);
        if (defaultPageSize > 0) {
            $helper.setLimitDefaultPageSize(true);
            $helper.setDefaultPageSize(defaultPageSize);
        }
        return Unit.INSTANCE;
    }

    private static final void createTable$lambda$4(Function2 $tmp0, DataGrid p0, DataGridAppearance p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void createTable$lambda$5(Function2 $tmp0, DataGrid p0, DataGridAppearance p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }
}

