/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0084\b\u00f8\u0001\u0000J\b\u0010\u0017\u001a\u00020\u0013H\u0004J\u0012\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0004J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "<set-?>", "", "isDisposed", "()Z", "isFirstFrameRendered", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "dispose", "", "inDrawScope", "body", "Lkotlin/Function0;", "onContextInit", "onDeviceChosen", "deviceName", "", "update", "nanoTime", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nAWTRedrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SkiaLayer.awt.kt\norg/jetbrains/skiko/SkiaLayer\n+ 4 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,72:1\n1#2:73\n1#2:75\n571#3:74\n572#3,8:76\n580#3,5:88\n159#4,4:84\n*S KotlinDebug\n*F\n+ 1 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n*L\n64#1:75\n64#1:74\n64#1:76,8\n64#1:88,5\n64#1:84,4\n*E\n"})
public abstract class AWTRedrawer
implements Redrawer {
    @NotNull
    private final SkiaLayer layer;
    @NotNull
    private final SkiaLayerAnalytics analytics;
    @NotNull
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    @NotNull
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    @Nullable
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    public AWTRedrawer(@NotNull SkiaLayer layer, @NotNull SkiaLayerAnalytics analytics, @NotNull GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"graphicsApi");
        this.layer = layer;
        this.analytics = analytics;
        this.graphicsApi = graphicsApi;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected final boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    protected final void onDeviceChosen(@Nullable String deviceName) {
        block2: {
            if (!(!this.isDisposed)) {
                boolean $i$a$-require-AWTRedrawer$onDeviceChosen$32 = false;
                String $i$a$-require-AWTRedrawer$onDeviceChosen$32 = this.getClass() + " is disposed";
                throw new IllegalArgumentException($i$a$-require-AWTRedrawer$onDeviceChosen$32.toString());
            }
            if (!(this.deviceAnalytics == null)) {
                boolean bl = false;
                String string = "deviceAnalytics is not null";
                throw new IllegalArgumentException(string.toString());
            }
            this.rendererAnalytics.deviceChosen();
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, deviceName);
            if (deviceAnalytics == null) break block2;
            deviceAnalytics.init();
        }
    }

    protected final void onContextInit() {
        block2: {
            if (!(!this.isDisposed)) {
                boolean $i$a$-require-AWTRedrawer$onContextInit$22 = false;
                String $i$a$-require-AWTRedrawer$onContextInit$22 = this.getClass() + " is disposed";
                throw new IllegalArgumentException($i$a$-require-AWTRedrawer$onContextInit$22.toString());
            }
            if (this.deviceAnalytics == null) {
                boolean bl = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics == null) break block2;
            deviceAnalytics.contextInit();
        }
    }

    protected final void update(long nanoTime) {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.layer.update$skiko(nanoTime);
    }

    protected final void inDrawScope(@NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$inDrawScope = false;
        if (this.deviceAnalytics == null) {
            boolean $i$a$-requireNotNull-AWTRedrawer$inDrawScope$22 = false;
            String $i$a$-requireNotNull-AWTRedrawer$inDrawScope$22 = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException($i$a$-requireNotNull-AWTRedrawer$inDrawScope$22.toString());
        }
        if (!this.isDisposed) {
            block15: {
                if (!this.isFirstFrameRendered) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer this_$iv = this.layer;
                boolean $i$f$inDrawScope$skiko = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$1$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$1$iv22 = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$1$iv22.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(this_$iv))) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$2$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$2$iv22 = "SkiaLayer is disposed";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$2$iv22.toString());
                }
                try {
                    body.invoke();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException e$iv) {
                    if (SkiaLayer.access$isDisposed$p(this_$iv)) break block15;
                    Logger this_$iv$iv = Logger.INSTANCE;
                    boolean $i$f$warn = false;
                    if (this_$iv$iv.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = e$iv;
                        SkikoLoggerInterface skikoLoggerInterface = this_$iv$iv.getLoggerImpl();
                        boolean bl = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(this_$iv), false, 1, null);
                    Redrawer redrawer = this_$iv.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.redrawImmediately();
                    }
                }
            }
            if (!this.isFirstFrameRendered && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
            this.isFirstFrameRendered = true;
        }
    }

    @Override
    public void syncBounds() {
        Redrawer.DefaultImpls.syncBounds(this);
    }

    @Override
    public void setVisible(boolean isVisible) {
        Redrawer.DefaultImpls.setVisible(this, isVisible);
    }
}

