/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model;

import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureFilter;
import com.jetbrains.ml.api.model.MLModel;
import com.jetbrains.ml.tools.model.ClassesProbabilities;
import com.jetbrains.ml.tools.model.Classifier;
import com.jetbrains.ml.tools.model.ColumnsCompiler;
import com.jetbrains.ml.tools.model.DatasetColumns;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\u0011\u001a\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015H\u0016JD\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\r0\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J*\u0010\u001a\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/ml/tools/model/ClassifierModel;", "Lcom/jetbrains/ml/api/model/MLModel;", "Lcom/jetbrains/ml/tools/model/ClassesProbabilities;", "columnsCompiler", "Lcom/jetbrains/ml/tools/model/ColumnsCompiler;", "decisionFunction", "Lcom/jetbrains/ml/tools/model/Classifier;", "(Lcom/jetbrains/ml/tools/model/ColumnsCompiler;Lcom/jetbrains/ml/tools/model/Classifier;)V", "knownFeatures", "Lcom/jetbrains/ml/api/feature/FeatureFilter;", "getKnownFeatures", "()Lcom/jetbrains/ml/api/feature/FeatureFilter;", "predictedClasses", "", "", "getPredictedClasses", "()Ljava/util/List;", "predict", "features", "Lcom/jetbrains/ml/api/feature/Feature;", "parameters", "", "", "predictBatch", "contextFeatures", "itemFeatures", "predictClass", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nClassicalMLModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalMLModels.kt\ncom/jetbrains/ml/tools/model/ClassifierModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public class ClassifierModel
implements MLModel<ClassesProbabilities> {
    @NotNull
    private final ColumnsCompiler columnsCompiler;
    @NotNull
    private final Classifier decisionFunction;
    @NotNull
    private final List<String> predictedClasses;
    @NotNull
    private final FeatureFilter knownFeatures;

    public ClassifierModel(@NotNull ColumnsCompiler columnsCompiler, @NotNull Classifier decisionFunction) {
        Intrinsics.checkNotNullParameter((Object)columnsCompiler, (String)"columnsCompiler");
        Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
        this.columnsCompiler = columnsCompiler;
        this.decisionFunction = decisionFunction;
        this.predictedClasses = this.decisionFunction.getPredictedClasses();
        this.knownFeatures = FeatureFilter.Companion.ofNames(this.columnsCompiler.getKnownFeatures());
    }

    @NotNull
    public final List<String> getPredictedClasses() {
        return this.predictedClasses;
    }

    @NotNull
    public FeatureFilter getKnownFeatures() {
        return this.knownFeatures;
    }

    @NotNull
    public ClassesProbabilities predict(@NotNull List<? extends Feature> features, @NotNull Map<String, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        DatasetColumns columns = this.columnsCompiler.compileRow(features);
        return (ClassesProbabilities)this.decisionFunction.predict(columns, parameters);
    }

    @NotNull
    public List<ClassesProbabilities> predictBatch(@NotNull List<? extends Feature> contextFeatures, @NotNull List<? extends List<? extends Feature>> itemFeatures, @NotNull Map<String, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter(contextFeatures, (String)"contextFeatures");
        Intrinsics.checkNotNullParameter(itemFeatures, (String)"itemFeatures");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        List<DatasetColumns> columns = this.columnsCompiler.compileRows(contextFeatures, itemFeatures);
        return this.decisionFunction.predictBatch(columns, parameters);
    }

    @NotNull
    public final String predictClass(@NotNull List<? extends Feature> features, @NotNull Map<String, ? extends Object> parameters) {
        Object t;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Map<String, Double> probabilities = ((ClassesProbabilities)this.predict((List)features, (Map)parameters)).getProbas();
        Iterable iterable = probabilities.entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Object t2 = iterator.next();
        if (!iterator.hasNext()) {
            t = t2;
        } else {
            Map.Entry it = (Map.Entry)t2;
            boolean bl = false;
            double d = ((Number)it.getValue()).doubleValue();
            do {
                Object t3 = iterator.next();
                Map.Entry it2 = (Map.Entry)t3;
                $i$a$-maxByOrThrow-ClassifierModel$predictClass$1 = false;
                double d2 = ((Number)it2.getValue()).doubleValue();
                if (Double.compare(d, d2) >= 0) continue;
                t2 = t3;
                d = d2;
            } while (iterator.hasNext());
            t = t2;
        }
        return (String)((Map.Entry)t).getKey();
    }

    public static /* synthetic */ String predictClass$default(ClassifierModel classifierModel, List list, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: predictClass");
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return classifierModel.predictClass(list, map);
    }

    @NotNull
    public <T> Map<T, ClassesProbabilities> predictBatch(@NotNull List<? extends Feature> contextFeatures, @NotNull Map<T, ? extends List<? extends Feature>> itemFeatures, @NotNull Map<String, ? extends Object> parameters) {
        return MLModel.DefaultImpls.predictBatch((MLModel)this, contextFeatures, itemFeatures, parameters);
    }
}

