/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.XmlEmmetParser;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZenCodingGenerator {
    private static final ExtensionPointName<ZenCodingGenerator> EP_NAME = new ExtensionPointName("com.intellij.xml.zenCodingGenerator");

    public abstract TemplateImpl generateTemplate(@NotNull TemplateToken var1, boolean var2, @NotNull PsiElement var3);

    @Nullable
    public TemplateImpl createTemplateByKey(@NotNull String key, boolean forceSingleTag) {
        if (key == null) {
            ZenCodingGenerator.$$$reportNull$$$0(0);
        }
        return null;
    }

    public abstract boolean isMyContext(@NotNull CustomTemplateCallback var1, boolean var2);

    @Nullable
    public String getSuffix() {
        return null;
    }

    public abstract boolean isAppliedByDefault(@NotNull PsiElement var1);

    public abstract boolean isEnabled();

    @NotNull
    public static List<ZenCodingGenerator> getInstances() {
        List list = EP_NAME.getExtensionList();
        if (list == null) {
            ZenCodingGenerator.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            ZenCodingGenerator.$$$reportNull$$$0(2);
        }
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        int startOffset = editor.getDocument().getLineStartOffset(editor.getCaretModel().getLogicalPosition().line);
        String key = this.computeKey(editor.getDocument().getCharsSequence().subSequence(startOffset, currentOffset));
        return !StringUtil.isEmpty((String)key) && ZenCodingTemplate.checkTemplateKey(key, callback, this) ? key : null;
    }

    @Nullable
    protected String computeKey(@NotNull CharSequence text) {
        if (text == null) {
            ZenCodingGenerator.$$$reportNull$$$0(3);
        }
        int currentOffset = text.length();
        int groupCount = 0;
        int bracketCount = 0;
        int textCount = 0;
        while (currentOffset > 0) {
            char c;
            if ((c = text.charAt(--currentOffset)) == ']') {
                ++bracketCount;
                continue;
            }
            if (c == '[') {
                if (bracketCount == 0) {
                    ++currentOffset;
                    break;
                }
                --bracketCount;
                continue;
            }
            if (c == '}') {
                ++textCount;
                continue;
            }
            if (c == '{') {
                if (textCount == 0) {
                    ++currentOffset;
                    break;
                }
                --textCount;
                continue;
            }
            if (c == ')') {
                ++groupCount;
                continue;
            }
            if (c == '(') {
                if (groupCount == 0) {
                    ++currentOffset;
                    break;
                }
                --groupCount;
                continue;
            }
            if (bracketCount > 0 || textCount > 0 || this.isAllowedChar(c)) continue;
            ++currentOffset;
            break;
        }
        return groupCount == 0 && textCount == 0 && bracketCount == 0 && currentOffset < text.length() ? text.subSequence(currentOffset, text.length()).toString().replaceFirst("^[*+>^]+", "") : null;
    }

    protected boolean isAllowedChar(char c) {
        return Character.isDigit(c) || Character.isLetter(c) || StringUtil.containsChar((String)"/>+^[](){}#.*:$-_!@|%", (char)c);
    }

    @NotNull
    public EmmetParser createParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        return new XmlEmmetParser(tokens, callback, generator, surroundWithTemplate);
    }

    @Nullable
    public Configurable createConfigurable() {
        return null;
    }

    public boolean addToCompletion() {
        return this.hasCompletionItem();
    }

    public boolean hasCompletionItem() {
        return false;
    }

    public boolean isHtml(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            ZenCodingGenerator.$$$reportNull$$$0(4);
        }
        return false;
    }

    public void disableEmmet() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateByKey";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isHtml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

