/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.JUnit3IdeaTestRunner;
import com.intellij.junit3.TestRunnerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestAllInPackage2
extends TestSuite {
    public TestAllInPackage2(JUnit3IdeaTestRunner runner, String name, String[] classMethodNames) {
        super(name);
        Test suite;
        int testClassCount = 0;
        HashSet<String> allNames = new HashSet<String>(Arrays.asList(classMethodNames));
        for (String classMethodName : classMethodNames) {
            suite = TestRunnerUtil.createClassOrMethodSuite(runner, classMethodName);
            if (suite == null) continue;
            TestAllInPackage2.skipSuiteComponents(allNames, suite);
        }
        for (String classMethodName : classMethodNames) {
            boolean skip;
            suite = TestRunnerUtil.createClassOrMethodSuite(runner, classMethodName);
            if (suite == null || (skip = suite instanceof TestSuite ? !allNames.contains(((TestSuite)suite).getName()) : (suite instanceof TestRunnerUtil.SuiteMethodWrapper ? !allNames.contains(((TestRunnerUtil.SuiteMethodWrapper)suite).getClassName()) : false))) continue;
            if (suite instanceof TestSuite && ((TestSuite)suite).getName() == null) {
                TestAllInPackage2.attachSuiteInfo(suite, classMethodName);
            }
            this.addTest(suite);
            ++testClassCount;
        }
        String message = TestRunnerUtil.testsFoundInPackageMessage(testClassCount, name);
        System.out.println(message);
    }

    private static void skipSuiteComponents(Set<String> allNames, Test suite) {
        if (suite instanceof TestRunnerUtil.SuiteMethodWrapper) {
            Test test = ((TestRunnerUtil.SuiteMethodWrapper)suite).getSuite();
            String currentSuiteName = ((TestRunnerUtil.SuiteMethodWrapper)suite).getClassName();
            TestAllInPackage2.skipSubtests(allNames, test, currentSuiteName);
        }
    }

    private static void skipSubtests(Set<String> allNames, Test test, String currentSuiteName) {
        if (test instanceof TestSuite) {
            for (int idx = 0; idx < ((TestSuite)test).testCount(); ++idx) {
                Test childTest = ((TestSuite)test).testAt(idx);
                String testName = childTest.toString();
                if (!currentSuiteName.equals(testName)) {
                    allNames.remove(testName);
                }
                TestAllInPackage2.skipSubtests(allNames, childTest, currentSuiteName);
            }
        }
    }

    private static void attachSuiteInfo(Test test, String name) {
        TestSuite testSuite;
        if (test instanceof TestSuite && (testSuite = (TestSuite)test).getName() == null) {
            testSuite.setName(name);
        }
    }
}

