/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.named.providers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import shaded.org.eclipse.aether.named.support.FileLockNamedLock;
import shaded.org.eclipse.aether.named.support.FileSystemFriendly;
import shaded.org.eclipse.aether.named.support.NamedLockFactorySupport;
import shaded.org.eclipse.aether.named.support.NamedLockSupport;

@Singleton
@Named(value="file-lock")
public class FileLockNamedLockFactory
extends NamedLockFactorySupport
implements FileSystemFriendly {
    public static final String NAME = "file-lock";
    private final ConcurrentMap<String, FileChannel> fileChannels = new ConcurrentHashMap<String, FileChannel>();

    @Override
    protected NamedLockSupport createLock(String name) {
        Path path = Paths.get(name, new String[0]);
        FileChannel fileChannel = this.fileChannels.computeIfAbsent(name, k -> {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                return FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to open file channel for '" + name + "'", e);
            }
        });
        return new FileLockNamedLock(name, fileChannel, this);
    }

    @Override
    protected void destroyLock(String name) {
        FileChannel fileChannel = (FileChannel)this.fileChannels.remove(name);
        if (fileChannel == null) {
            throw new IllegalStateException("File channel expected, but does not exist: " + name);
        }
        try {
            fileChannel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close file channel for '" + name + "'", e);
        }
    }
}

