/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    private static final Logger LOG = LoggerFactory.getLogger(XMLX509SKI.class);
    public static final String SKI_OID = "2.5.29.14";

    public XMLX509SKI(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public XMLX509SKI(Document document, X509Certificate x509Certificate) throws XMLSecurityException {
        super(document);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509Certificate));
    }

    public XMLX509SKI(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate x509Certificate) throws XMLSecurityException {
        if (x509Certificate.getVersion() < 3) {
            Object[] objectArray = new Object[]{x509Certificate.getVersion()};
            throw new XMLSecurityException("certificate.noSki.lowVersion", objectArray);
        }
        byte[] byArray = x509Certificate.getExtensionValue(SKI_OID);
        if (byArray == null) {
            throw new XMLSecurityException("certificate.noSki.null");
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Base64 of SKI is " + XMLUtils.encodeToString(byArray2));
        }
        return byArray2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XMLX509SKI)) {
            return false;
        }
        XMLX509SKI xMLX509SKI = (XMLX509SKI)object;
        try {
            return Arrays.equals(xMLX509SKI.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException xMLSecurityException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 17;
        try {
            byte[] byArray = this.getSKIBytes();
            for (int i = 0; i < byArray.length; ++i) {
                n = 31 * n + byArray[i];
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug(xMLSecurityException.getMessage(), xMLSecurityException);
        }
        return n;
    }

    @Override
    public String getBaseLocalName() {
        return "X509SKI";
    }
}

