/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.man.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.man.FileParser;
import org.aesh.command.man.parser.ManSection;
import org.aesh.terminal.utils.Config;

public class ManFileParser
implements FileParser {
    private final List<ManSection> sections = new ArrayList<ManSection>();
    private String name;
    private InputStreamReader reader;

    public void setInput(InputStream input) throws IOException {
        if (input != null) {
            this.reader = new InputStreamReader(input);
            this.name = null;
            this.sections.clear();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> loadPage(int columns) throws IOException {
        if (!this.sections.isEmpty()) {
            return this.getAsList();
        }
        if (this.reader == null) {
            throw new IOException("InputStreamReader is null, cannot read file.");
        }
        try (BufferedReader br = new BufferedReader(this.reader);){
            ManSection manSection;
            String line = br.readLine();
            boolean foundHeader = false;
            boolean foundEmptyLine = true;
            ArrayList<String> section = new ArrayList<String>();
            while (line != null) {
                if (line.trim().isEmpty() && !foundEmptyLine) {
                    foundEmptyLine = true;
                    section.add(line);
                } else if (line.isEmpty() && foundEmptyLine) {
                    if (!foundHeader) {
                        this.processHeader(section, columns);
                        foundHeader = true;
                    } else {
                        manSection = new ManSection().parseSection(section, columns);
                        this.sections.add(manSection);
                    }
                    foundEmptyLine = false;
                    section.clear();
                } else {
                    if (foundEmptyLine) {
                        foundEmptyLine = false;
                    }
                    section.add(line);
                }
                line = br.readLine();
            }
            if (!section.isEmpty()) {
                manSection = new ManSection().parseSection(section, columns);
                this.sections.add(manSection);
            }
            List<String> list = this.getAsList();
            return list;
        }
    }

    private void processHeader(List<String> header, int columns) throws IOException {
        if (header.size() != 4) {
            throw new IOException("File did not include the correct header.");
        }
        this.name = header.get(0);
        if (!header.get(2).equals(":doctype: manpage")) {
            throw new IOException("File did not include the correct header: \":doctype: manpage\"");
        }
    }

    public List<ManSection> getSections() {
        return this.sections;
    }

    public List<String> getAsList() {
        ArrayList<String> out = new ArrayList<String>();
        for (ManSection section : this.sections) {
            out.addAll(section.getAsList());
        }
        return out;
    }

    public String print() {
        StringBuilder builder = new StringBuilder();
        for (ManSection section : this.sections) {
            builder.append(section.printToTerminal()).append(Config.getLineSeparator());
        }
        return builder.toString();
    }
}

