"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveQueryById = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Utility function to fetch query by id and time range
const retrieveQueryById = async (core, dataSourceId, start, end, id, verbose) => {
  const nullResponse = {
    response: {
      top_queries: []
    }
  };
  const params = {
    query: {
      dataSourceId,
      from: start,
      to: end,
      id,
      verbose
    }
  };
  const fetchMetric = async endpoint => {
    try {
      var _response$response;
      const response = await core.http.get(endpoint, params);
      return {
        response: {
          top_queries: Array.isArray(response === null || response === void 0 || (_response$response = response.response) === null || _response$response === void 0 ? void 0 : _response$response.top_queries) ? response.response.top_queries : []
        }
      };
    } catch (error) {
      console.error('Error occurred while fetching the data:', error);
      return nullResponse;
    }
  };
  try {
    const endpoints = [`/api/top_queries/latency`, `/api/top_queries/cpu`, `/api/top_queries/memory`];
    for (const endpoint of endpoints) {
      const result = await fetchMetric(endpoint);
      if (result.response.top_queries.length > 0) {
        return result.response.top_queries[0];
      }
    }
    return null;
  } catch (error) {
    console.error('Error retrieving query details:', error);
    return null;
  }
};
exports.retrieveQueryById = retrieveQueryById;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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