"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceEndpoints = exports.SEARCH_RELEVANCE_EXPERIMENTAL_WORKBENCH_UI_EXPERIENCE_ENABLED = exports.SEARCH_API = exports.Routes = exports.RouteTemplateType = exports.QUERY_NUMBER_TWO = exports.QUERY_NUMBER_ONE = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.COMPARE_SEARCH_RESULTS_TITLE = exports.BackendEndpoints = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'searchRelevance';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'Search Relevance';
const COMPARE_SEARCH_RESULTS_TITLE = exports.COMPARE_SEARCH_RESULTS_TITLE = 'Compare Search Results';
const SEARCH_RELEVANCE_EXPERIMENTAL_WORKBENCH_UI_EXPERIENCE_ENABLED = exports.SEARCH_RELEVANCE_EXPERIMENTAL_WORKBENCH_UI_EXPERIENCE_ENABLED = 'search-relevance:experimental_workbench_ui_enabled';
const SEARCH_RELEVANCE_WORKBENCH_BASE_PATH = '/api/relevancy';
const ServiceEndpoints = exports.ServiceEndpoints = Object.freeze({
  // OpenSearch node APIs
  GetIndexes: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/search/indexes`,
  GetPipelines: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/search/pipelines`,
  GetSearchResults: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/search`,
  GetSingleSearchResults: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/single_search`,
  GetStats: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/stats`,
  GetClusterSettings: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/cluster_settings`,
  // Search Relevance node APIs
  QuerySets: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/query_sets`,
  SearchConfigurations: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/search_configurations`,
  Judgments: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/judgments`,
  Experiments: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/experiments`
});
const SEARCH_RELEVANCE_PLUGIN_BASE_PATH = '/_plugins/_search_relevance';
const BackendEndpoints = exports.BackendEndpoints = Object.freeze({
  QuerySets: `${SEARCH_RELEVANCE_PLUGIN_BASE_PATH}/query_sets`,
  SearchConfigurations: `${SEARCH_RELEVANCE_PLUGIN_BASE_PATH}/search_configurations`,
  Judgments: `${SEARCH_RELEVANCE_PLUGIN_BASE_PATH}/judgments`,
  Experiments: `${SEARCH_RELEVANCE_PLUGIN_BASE_PATH}/experiments`
});
const SEARCH_API = exports.SEARCH_API = '/_search';

// Query1 for the left search and Query2 for the right search page
const QUERY_NUMBER_ONE = exports.QUERY_NUMBER_ONE = '1';
const QUERY_NUMBER_TWO = exports.QUERY_NUMBER_TWO = '2';
let RouteTemplateType = exports.RouteTemplateType = /*#__PURE__*/function (RouteTemplateType) {
  RouteTemplateType["SingleQueryComparison"] = "singleQueryComparison";
  RouteTemplateType["QuerySetComparison"] = "querySetComparison";
  RouteTemplateType["SearchEvaluation"] = "searchEvaluation";
  RouteTemplateType["HybridOptimizer"] = "hybridOptimizer";
  return RouteTemplateType;
}({});
let Routes = exports.Routes = function (Routes) {
  Routes["Home"] = "/";
  Routes["ExperimentListing"] = "/experiment";
  Routes["ExperimentView"] = "/experiment/view/:entityId";
  Routes["ExperimentViewPrefix"] = "/experiment/view";
  Routes["ExperimentCreate"] = "/experiment/create";
  Routes["ExperimentCreateSingleQueryComparison"] = "/experiment/create/singleQueryComparison";
  Routes["ExperimentCreateQuerySetComparison"] = "/experiment/create/querySetComparison";
  Routes["ExperimentCreateSearchEvaluation"] = "/experiment/create/searchEvaluation";
  Routes["ExperimentCreateHybridOptimizer"] = "/experiment/create/hybridOptimizer";
  Routes[Routes["ExperimentCreateTemplate"] = `/experiment/create/:templateId(${Object.values(RouteTemplateType).join('|')})`] = "ExperimentCreateTemplate";
  Routes["QuerySetListing"] = "/querySet";
  Routes["QuerySetView"] = "/querySet/view/:entityId";
  Routes["QuerySetViewPrefix"] = "/querySet/view";
  Routes["QuerySetCreate"] = "/querySet/create";
  Routes["SearchConfigurationListing"] = "/searchConfiguration";
  Routes["SearchConfigurationView"] = "/searchConfiguration/view/:entityId";
  Routes["SearchConfigurationViewPrefix"] = "/searchConfiguration/view";
  Routes["SearchConfigurationCreate"] = "/searchConfiguration/create";
  Routes["JudgmentListing"] = "/judgment";
  Routes["JudgmentView"] = "/judgment/view/:entityId";
  Routes["JudgmentViewPrefix"] = "/judgment/view";
  Routes["JudgmentCreate"] = "/judgment/create";
  return Routes;
}({});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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