/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.collect.Collections2;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.TabletType;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.InitialMultiScan;
import org.apache.accumulo.core.dataImpl.thrift.InitialScan;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.dataImpl.thrift.ScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TColumn;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TRange;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.scan.ScanDispatcher;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.ScanServerBusyException;
import org.apache.accumulo.core.tabletserver.thrift.TSampleNotPresentException;
import org.apache.accumulo.core.tabletserver.thrift.TSamplerConfiguration;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.tserver.TabletClientHandler;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.WriteTracker;
import org.apache.accumulo.tserver.scan.LookupTask;
import org.apache.accumulo.tserver.scan.NextBatchTask;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.session.SingleScanSession;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftScanClientHandler
implements TabletScanClientService.Iface {
    private static final Logger log = LoggerFactory.getLogger(ThriftScanClientHandler.class);
    private final TabletHostingServer server;
    protected final ServerContext context;
    protected final AuditedSecurityOperation security;
    private final WriteTracker writeTracker;
    private final long MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS;

    public ThriftScanClientHandler(TabletHostingServer server, WriteTracker writeTracker) {
        this.server = server;
        this.context = server.getContext();
        this.writeTracker = writeTracker;
        this.security = this.context.getSecurityOperation();
        this.MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS = server.getContext().getConfiguration().getTimeInMillis(Property.TSERV_SCAN_RESULTS_MAX_TIMEOUT);
    }

    private NamespaceId getNamespaceId(TCredentials credentials, TableId tableId) throws ThriftSecurityException {
        try {
            return this.server.getContext().getNamespaceId(tableId);
        }
        catch (TableNotFoundException e1) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    private ScanDispatcher getScanDispatcher(KeyExtent extent) {
        if (extent.isRootTablet() || extent.isMeta()) {
            return null;
        }
        return this.context.getTableConfiguration(extent.tableId()).getScanDispatcher();
    }

    public InitialScan startScan(TInfo tinfo, TCredentials credentials, TKeyExtent textent, TRange range, List<TColumn> columns, int batchSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String contextArg, Map<String, String> executionHints, long busyTimeout) throws NotServingTabletException, ThriftSecurityException, TooManyFilesException, TSampleNotPresentException, ScanServerBusyException {
        KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)textent);
        ScanSession.TabletResolver resolver = new ScanSession.TabletResolver(){

            @Override
            public Tablet getTablet(KeyExtent extent) {
                return ThriftScanClientHandler.this.server.getOnlineTablet(extent);
            }

            @Override
            public void close() {
            }
        };
        return this.startScan(tinfo, credentials, extent, range, columns, batchSize, ssiList, ssio, authorizations, waitForWrites, isolated, readaheadThreshold, tSamplerConfig, batchTimeOut, contextArg, executionHints, resolver, busyTimeout);
    }

    public InitialScan startScan(TInfo tinfo, TCredentials credentials, KeyExtent extent, TRange range, List<TColumn> columns, int batchSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String contextArg, Map<String, String> executionHints, ScanSession.TabletResolver tabletResolver, long busyTimeout) throws NotServingTabletException, ThriftSecurityException, TooManyFilesException, TSampleNotPresentException, ScanServerBusyException {
        ScanResult scanResult;
        TabletBase tablet;
        NamespaceId namespaceId;
        this.server.getScanMetrics().incrementStartScan(1.0);
        TableId tableId = extent.tableId();
        try {
            namespaceId = this.server.getContext().getNamespaceId(tableId);
        }
        catch (TableNotFoundException e1) {
            throw new NotServingTabletException(extent.toThrift());
        }
        if (!this.security.canScan(credentials, tableId, namespaceId, range, columns, ssiList, ssio, authorizations)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (!this.security.authenticatedUserHasAuthorizations(credentials, authorizations)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
        }
        if (waitForWrites) {
            this.writeTracker.waitForWrites(TabletType.type((KeyExtent)extent));
        }
        if ((tablet = tabletResolver.getTablet(extent)) == null) {
            throw new NotServingTabletException(extent.toThrift());
        }
        HashSet<Column> columnSet = new HashSet<Column>();
        for (TColumn tcolumn : columns) {
            columnSet.add(new Column(tcolumn));
        }
        ScanParameters scanParams = new ScanParameters(batchSize, new Authorizations(authorizations), columnSet, ssiList, ssio, isolated, SamplerConfigurationImpl.fromThrift((TSamplerConfiguration)tSamplerConfig), batchTimeOut, contextArg);
        SingleScanSession scanSession = new SingleScanSession(credentials, extent, scanParams, readaheadThreshold, executionHints, tabletResolver);
        scanSession.scanner = tablet.createScanner(new Range(range), scanParams, scanSession.interruptFlag);
        long sid = this.server.getSessionManager().createSession(scanSession, true);
        scanParams.setScanSessionId(sid);
        try {
            scanResult = this.continueScan(tinfo, sid, scanSession, busyTimeout);
        }
        catch (NoSuchScanIDException e) {
            log.error("The impossible happened", (Throwable)e);
            throw new RuntimeException();
        }
        finally {
            this.server.getSessionManager().unreserveSession(sid);
        }
        return new InitialScan(sid, scanResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult continueScan(TInfo tinfo, long scanID, long busyTimeout) throws NoSuchScanIDException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, ScanServerBusyException {
        SingleScanSession scanSession = (SingleScanSession)this.server.getSessionManager().reserveSession(scanID);
        if (scanSession == null) {
            throw new NoSuchScanIDException();
        }
        try {
            ScanResult scanResult = this.continueScan(tinfo, scanID, scanSession, busyTimeout);
            return scanResult;
        }
        finally {
            this.server.getSessionManager().unreserveSession(scanSession);
        }
    }

    protected ScanResult continueScan(TInfo tinfo, long scanID, SingleScanSession scanSession, long busyTimeout) throws NoSuchScanIDException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, ScanServerBusyException {
        ScanBatch bresult;
        this.server.getScanMetrics().incrementContinueScan(1.0);
        if (scanSession.getScanTask() == null) {
            scanSession.setScanTask(new NextBatchTask(this.server, scanID, scanSession.interruptFlag));
            this.server.getResourceManager().executeReadAhead(scanSession.extent, this.getScanDispatcher(scanSession.extent), scanSession, scanSession.getScanTask());
        }
        try {
            bresult = (ScanBatch)scanSession.getScanTask().get(busyTimeout, this.MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS, TimeUnit.MILLISECONDS);
            scanSession.clearScanTask();
        }
        catch (ExecutionException e) {
            this.server.getSessionManager().removeSession(scanID);
            if (e.getCause() instanceof NotServingTabletException) {
                throw (NotServingTabletException)e.getCause();
            }
            if (e.getCause() instanceof org.apache.accumulo.server.fs.TooManyFilesException) {
                throw new TooManyFilesException(scanSession.extent.toThrift());
            }
            if (e.getCause() instanceof SampleNotPresentException) {
                throw new TSampleNotPresentException(scanSession.extent.toThrift());
            }
            if (e.getCause() instanceof IOException) {
                UtilWaitThread.sleepUninterruptibly((long)this.MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS);
                List<KVEntry> empty = Collections.emptyList();
                bresult = new ScanBatch(empty, true);
                scanSession.clearScanTask();
            }
            throw new RuntimeException(e);
        }
        catch (CancellationException ce) {
            this.server.getSessionManager().removeSession(scanID);
            TabletBase tablet = scanSession.getTabletResolver().getTablet(scanSession.extent);
            if (busyTimeout > 0L) {
                this.server.getScanMetrics().incrementBusy(1.0);
                throw new ScanServerBusyException();
            }
            if (tablet == null || tablet.isClosed()) {
                throw new NotServingTabletException(scanSession.extent.toThrift());
            }
            throw new NoSuchScanIDException();
        }
        catch (TimeoutException e) {
            List param = Collections.emptyList();
            long timeout = this.server.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
            this.server.getSessionManager().removeIfNotAccessed(scanID, timeout);
            return new ScanResult(param, true);
        }
        catch (Exception t) {
            this.server.getSessionManager().removeSession(scanID);
            log.warn("Failed to get next batch", (Throwable)t);
            throw new RuntimeException(t);
        }
        ScanResult scanResult = new ScanResult(Key.compress(bresult.getResults()), bresult.isMore());
        scanSession.entriesReturned += (long)scanResult.results.size();
        ++scanSession.batchCount;
        if (scanResult.more && scanSession.batchCount > scanSession.readaheadThreshold) {
            scanSession.setScanTask(new NextBatchTask(this.server, scanID, scanSession.interruptFlag));
            this.server.getResourceManager().executeReadAhead(scanSession.extent, this.getScanDispatcher(scanSession.extent), scanSession, scanSession.getScanTask());
        }
        if (!scanResult.more) {
            this.closeScan(tinfo, scanID);
        }
        return scanResult;
    }

    public void closeScan(TInfo tinfo, long scanID) {
        this.server.getScanMetrics().incrementCloseScan(1.0);
        SingleScanSession ss = (SingleScanSession)this.server.getSessionManager().removeSession(scanID);
        if (ss != null) {
            long t2 = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                log.trace(String.format("ScanSess tid %s %s %,d entries in %.2f secs, nbTimes = [%s] ", TServerUtils.clientAddress.get(), ss.extent.tableId(), ss.entriesReturned, (double)(t2 - ss.startTime) / 1000.0, ss.runStats.toString()));
            }
            this.server.getScanMetrics().addScan(t2 - ss.startTime);
            this.server.getScanMetrics().addResult(ss.entriesReturned);
        }
    }

    public InitialMultiScan startMultiScan(TInfo tinfo, TCredentials credentials, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String contextArg, Map<String, String> executionHints, long busyTimeout) throws ThriftSecurityException, TSampleNotPresentException, ScanServerBusyException {
        HashMap<KeyExtent, List<TRange>> batch = new HashMap<KeyExtent, List<TRange>>();
        tbatch.forEach((k, v) -> batch.put(KeyExtent.fromThrift((TKeyExtent)k), (List<TRange>)v));
        ScanSession.TabletResolver resolver = new ScanSession.TabletResolver(){

            @Override
            public Tablet getTablet(KeyExtent extent) {
                return ThriftScanClientHandler.this.server.getOnlineTablet(extent);
            }

            @Override
            public void close() {
            }
        };
        return this.startMultiScan(tinfo, credentials, tcolumns, ssiList, batch, ssio, authorizations, waitForWrites, tSamplerConfig, batchTimeOut, contextArg, executionHints, resolver, busyTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitialMultiScan startMultiScan(TInfo tinfo, TCredentials credentials, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<KeyExtent, List<TRange>> tbatch, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String contextArg, Map<String, String> executionHints, ScanSession.TabletResolver tabletResolver, long busyTimeout) throws ThriftSecurityException, TSampleNotPresentException, ScanServerBusyException {
        MultiScanResult result;
        this.server.getScanMetrics().incrementStartScan(1.0);
        HashSet<TableId> tables = new HashSet<TableId>();
        for (KeyExtent keyExtent : tbatch.keySet()) {
            tables.add(keyExtent.tableId());
        }
        if (tables.size() != 1) {
            throw new IllegalArgumentException("Cannot batch scan over multiple tables");
        }
        for (TableId tableId : tables) {
            NamespaceId namespaceId;
            if (this.security.canScan(credentials, tableId, namespaceId = this.getNamespaceId(credentials, tableId), tbatch, tcolumns, ssiList, ssio, authorizations)) continue;
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (!this.security.authenticatedUserHasAuthorizations(credentials, authorizations)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
        }
        Map<KeyExtent, List<Range>> batch = tbatch.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(Range::new).collect(Collectors.toList())));
        KeyExtent threadPoolExtent = batch.keySet().iterator().next();
        if (waitForWrites) {
            this.writeTracker.waitForWrites(TabletType.type(batch.keySet()));
        }
        HashSet<Column> columnSet = tcolumns.isEmpty() ? Collections.emptySet() : new HashSet<Column>(Collections2.transform(tcolumns, Column::new));
        ScanParameters scanParams = new ScanParameters(-1, new Authorizations(authorizations), columnSet, ssiList, ssio, false, SamplerConfigurationImpl.fromThrift((TSamplerConfiguration)tSamplerConfig), batchTimeOut, contextArg);
        MultiScanSession mss = new MultiScanSession(credentials, threadPoolExtent, batch, scanParams, executionHints, tabletResolver);
        mss.numTablets = batch.size();
        for (List<Range> ranges : batch.values()) {
            mss.numRanges += ranges.size();
        }
        long sid = this.server.getSessionManager().createSession(mss, true);
        scanParams.setScanSessionId(sid);
        try {
            result = this.continueMultiScan(sid, mss, busyTimeout);
        }
        finally {
            this.server.getSessionManager().unreserveSession(sid);
        }
        return new InitialMultiScan(sid, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiScanResult continueMultiScan(TInfo tinfo, long scanID, long busyTimeout) throws NoSuchScanIDException, TSampleNotPresentException, ScanServerBusyException {
        MultiScanSession session = (MultiScanSession)this.server.getSessionManager().reserveSession(scanID);
        if (session == null) {
            throw new NoSuchScanIDException();
        }
        try {
            MultiScanResult multiScanResult = this.continueMultiScan(scanID, session, busyTimeout);
            return multiScanResult;
        }
        finally {
            this.server.getSessionManager().unreserveSession(session);
        }
    }

    private MultiScanResult continueMultiScan(long scanID, MultiScanSession session, long busyTimeout) throws TSampleNotPresentException, ScanServerBusyException {
        this.server.getScanMetrics().incrementContinueScan(1.0);
        if (session.getScanTask() == null) {
            session.setScanTask(new LookupTask(this.server, scanID));
            this.server.getResourceManager().executeReadAhead(session.threadPoolExtent, this.getScanDispatcher(session.threadPoolExtent), session, session.getScanTask());
        }
        try {
            MultiScanResult scanResult = (MultiScanResult)session.getScanTask().get(busyTimeout, this.MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS, TimeUnit.MILLISECONDS);
            session.clearScanTask();
            return scanResult;
        }
        catch (ExecutionException e) {
            this.server.getSessionManager().removeSession(scanID);
            if (e.getCause() instanceof SampleNotPresentException) {
                throw new TSampleNotPresentException();
            }
            log.warn("Failed to get multiscan result", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (CancellationException ce) {
            this.server.getSessionManager().removeSession(scanID);
            if (busyTimeout > 0L) {
                this.server.getScanMetrics().incrementBusy(1.0);
                throw new ScanServerBusyException();
            }
            log.warn("Failed to get multiscan result", (Throwable)ce);
            throw new RuntimeException(ce);
        }
        catch (TimeoutException e1) {
            long timeout = this.server.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
            this.server.getSessionManager().removeIfNotAccessed(scanID, timeout);
            List results = Collections.emptyList();
            Map failures = Collections.emptyMap();
            List fullScans = Collections.emptyList();
            return new MultiScanResult(results, failures, fullScans, null, null, false, true);
        }
        catch (Exception t) {
            this.server.getSessionManager().removeSession(scanID);
            log.warn("Failed to get multiscan result", (Throwable)t);
            throw new RuntimeException(t);
        }
    }

    public void closeMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException {
        this.server.getScanMetrics().incrementCloseScan(1.0);
        MultiScanSession session = (MultiScanSession)this.server.getSessionManager().removeSession(scanID);
        if (session == null) {
            throw new NoSuchScanIDException();
        }
        long t2 = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            log.trace(String.format("MultiScanSess %s %,d entries in %.2f secs (lookup_time:%.2f secs tablets:%,d ranges:%,d) ", TServerUtils.clientAddress.get(), session.numEntries, (double)(t2 - session.startTime) / 1000.0, (double)session.totalLookupTime / 1000.0, session.numTablets, session.numRanges));
        }
    }

    public List<ActiveScan> getActiveScans(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        TabletClientHandler.checkPermission(this.context, this.server, credentials, null, "getScans");
        return this.server.getSessionManager().getActiveScans();
    }
}

