/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.Date;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeBody;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.CoreLargeServerMessage;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public final class LargeServerMessageImpl
extends CoreMessage
implements CoreLargeServerMessage {
    private static final int ESTIMATE_RECORD_TRAIL = 512;
    private final LargeBody largeBody;
    private static final Logger logger = Logger.getLogger(LargeServerMessageImpl.class);
    private final StorageManager storageManager;
    private volatile int memoryEstimate = -1;

    @Override
    public Message toMessage() {
        return this;
    }

    public static Message checkLargeMessage(Message message, StorageManager storageManager) throws Exception {
        if (message.isLargeMessage()) {
            return message;
        }
        if ((long)(message.getEncodeSize() + 512) > storageManager.getMaxRecordSize()) {
            return LargeServerMessageImpl.asLargeMessage(message, storageManager);
        }
        return message;
    }

    @Override
    public void finishParse() throws Exception {
    }

    private static Message asLargeMessage(Message message, StorageManager storageManager) throws Exception {
        ICoreMessage coreMessage = message.toCore();
        LargeServerMessage lsm = storageManager.createLargeMessage(storageManager.generateID(), (Message)coreMessage);
        ActiveMQBuffer buffer = coreMessage.getReadOnlyBodyBuffer();
        int readableBytes = buffer.readableBytes();
        lsm.addBytes(buffer);
        lsm.releaseResources(true);
        lsm.toMessage().putLongProperty(Message.HDR_LARGE_BODY_SIZE, (long)readableBytes);
        return lsm.toMessage();
    }

    public LargeServerMessageImpl(StorageManager storageManager) {
        this.largeBody = new LargeBody(this, storageManager);
        this.storageManager = storageManager;
    }

    public long getBodySize() throws ActiveMQException {
        return this.largeBody.getBodySize();
    }

    public LargeServerMessageImpl(LargeServerMessageImpl copy, TypedProperties properties, SequentialFile fileCopy, long newID) {
        super((CoreMessage)copy, properties);
        this.storageManager = copy.storageManager;
        this.largeBody = new LargeBody(this, this.storageManager, fileCopy);
        this.largeBody.setBodySize(copy.largeBody.getStoredBodySize());
        this.setMessageID(newID);
    }

    public LargeServerMessageImpl(byte type, long id, StorageManager storageManager, SequentialFile fileCopy) {
        this.storageManager = storageManager;
        this.setMessageID(id);
        this.setType(type);
        this.largeBody = new LargeBody(this, storageManager, fileCopy);
    }

    private static String toDate(long timestamp) {
        if (timestamp == 0L) {
            return "0";
        }
        return new Date(timestamp).toString();
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public boolean isServerMessage() {
        return true;
    }

    @Override
    public long getPendingRecordID() {
        return this.largeBody.getPendingRecordID();
    }

    @Override
    public void clearPendingRecordID() {
        this.largeBody.clearPendingRecordID();
    }

    @Override
    public boolean hasPendingRecord() {
        return this.largeBody.hasPendingRecord();
    }

    @Override
    public void setPendingRecordID(long pendingRecordID) {
        this.largeBody.setPendingRecordID(pendingRecordID);
    }

    @Override
    public void setPaged() {
        this.largeBody.setPaged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBytes(byte[] bytes) throws Exception {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.addBytes(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBytes(ActiveMQBuffer bytes) throws Exception {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.addBytes(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEncodeSize() {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            return this.getHeadersAndPropertiesEncodeSize();
        }
    }

    public void encode(ActiveMQBuffer buffer1) {
        super.encodeHeadersAndProperties(buffer1.byteBuf());
    }

    public void decode(ActiveMQBuffer buffer1) {
        this.largeBody.clearFile();
        super.decodeHeadersAndProperties(buffer1.byteBuf());
    }

    @Override
    public LargeBodyReader getLargeBodyReader() {
        return this.largeBody.getLargeBodyReader();
    }

    protected void releaseComplete() {
        this.largeBody.deleteFile();
    }

    public ActiveMQBuffer getReadOnlyBodyBuffer() {
        return this.largeBody.getReadOnlyBodyBuffer();
    }

    public int getBodyBufferSize() {
        return this.largeBody.getBodyBufferSize();
    }

    public boolean isLargeMessage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile() throws Exception {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.deleteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMemoryEstimate() {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            if (this.memoryEstimate == -1) {
                this.memoryEstimate = this.getHeadersAndPropertiesEncodeSize() + 4 + this.getEncodeSize() + 40 + 1;
            }
            return this.memoryEstimate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResources(boolean sync) {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.releaseResources(sync);
        }
    }

    public void referenceOriginalMessage(Message original, String originalQueue) {
        super.referenceOriginalMessage(original, originalQueue);
        if (original instanceof LargeServerMessageImpl) {
            this.largeBody.referenceOriginalMessage(((LargeServerMessageImpl)original).largeBody);
        }
    }

    @Override
    public void setStorageManager(StorageManager storageManager) {
        this.largeBody.setStorageManager(storageManager);
    }

    public Message copy() {
        SequentialFile newfile = this.storageManager.createFileForLargeMessage(this.messageID, this.durable);
        LargeServerMessageImpl newMessage = new LargeServerMessageImpl(this, this.properties, newfile, this.messageID);
        newMessage.setParentRef((RefCountMessage)this);
        return newMessage;
    }

    @Override
    public LargeBody getLargeBody() {
        return this.largeBody;
    }

    public Message copy(long newID) {
        try {
            LargeServerMessage newMessage = this.storageManager.createLargeMessage(newID, (Message)this);
            this.largeBody.copyInto(newMessage);
            newMessage.finishParse();
            newMessage.releaseResources(true);
            return newMessage.toMessage();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.lareMessageErrorCopying(e, this);
            return null;
        }
    }

    @Override
    public SequentialFile getAppendFile() throws ActiveMQException {
        return this.largeBody.getAppendFile();
    }

    public long getPersistentSize() throws ActiveMQException {
        long size = super.getPersistentSize();
        return size += this.getBodySize();
    }

    public String toString() {
        try {
            return "LargeServerMessage[messageID=" + this.messageID + ",durable=" + this.isDurable() + ",userID=" + this.getUserID() + ",priority=" + this.getPriority() + ", timestamp=" + LargeServerMessageImpl.toDate(this.getTimestamp()) + ",expiration=" + LargeServerMessageImpl.toDate(this.getExpiration()) + ", durable=" + this.durable + ", address=" + this.getAddress() + ", properties=" + (this.properties != null ? this.properties.toString() : "") + "]@" + System.identityHashCode(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "LargeServerMessage[messageID=" + this.messageID + "]";
        }
    }

    @Override
    public void validateFile() throws ActiveMQException {
        this.ensureFileExists(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureFileExists(boolean toOpen) throws ActiveMQException {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.ensureFileExists(toOpen);
        }
    }
}

