/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;

public class ConcurrencyLimiter {
    private final AtomicInteger permits = new AtomicInteger(0);
    private final IntSupplier concurrencyLimitSupplier;

    public ConcurrencyLimiter(IntSupplier concurrencyLimitSupplier) {
        this.concurrencyLimitSupplier = concurrencyLimitSupplier;
    }

    public boolean tryAcquire() {
        int next;
        int current;
        int limit = this.concurrencyLimitSupplier.getAsInt();
        do {
            if ((next = (current = this.permits.get()) + 1) <= limit) continue;
            return false;
        } while (!this.permits.compareAndSet(current, next));
        return true;
    }

    public void releasePermit() {
        this.permits.updateAndGet(current -> {
            int next = current - 1;
            return Math.max(next, 0);
        });
    }

    public int limit() {
        return this.concurrencyLimitSupplier.getAsInt();
    }

    public int acquiredPermits() {
        return this.permits.get();
    }
}

