/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.cassandra.sidecar.config.MetricsFilteringConfiguration;

public abstract class MetricFilter {
    public abstract boolean matches(String var1);

    public static List<MetricFilter> parse(List<MetricsFilteringConfiguration> filterConfigurations) {
        if (filterConfigurations == null) {
            return Collections.emptyList();
        }
        ArrayList<MetricFilter> filters = new ArrayList<MetricFilter>();
        for (MetricsFilteringConfiguration filterConfiguration : filterConfigurations) {
            if (filterConfiguration.type().equalsIgnoreCase("regex")) {
                filters.add(new Regex(filterConfiguration.value()));
                continue;
            }
            if (!filterConfiguration.type().equalsIgnoreCase("equals")) continue;
            filters.add(new Equals(filterConfiguration.value()));
        }
        return filters;
    }

    public static class Equals
    extends MetricFilter {
        private final String value;

        public Equals(String value) {
            Objects.requireNonNull(value);
            this.value = value;
        }

        @Override
        public boolean matches(String name) {
            return name.equals(this.value);
        }
    }

    public static class Regex
    extends MetricFilter {
        private final Pattern pattern;

        public Regex(String regex) {
            Objects.requireNonNull(regex);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean matches(String name) {
            return this.pattern.matcher(name).matches();
        }
    }
}

