/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.server;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;
import java.util.function.Function;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class RestoreMetrics {
    public static final String DOMAIN = "Sidecar.Server.Restore";
    protected final MetricRegistry metricRegistry;
    public final NamedMetric<Timer> sliceReplicationTime;
    public final NamedMetric<Timer> jobCompletionTime;
    public final NamedMetric<Timer> consistencyCheckTime;
    public final NamedMetric<DeltaGauge> successfulJobs;
    public final NamedMetric<DeltaGauge> failedJobs;
    public final NamedMetric<DefaultSettableGauge<Integer>> activeJobs;
    public final NamedMetric<DeltaGauge> tokenRefreshed;
    public final NamedMetric<DeltaGauge> tokenUnauthorized;
    public final NamedMetric<DeltaGauge> tokenExpired;

    public RestoreMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        this.sliceReplicationTime = this.createMetric("SliceReplicationTime", arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0));
        this.jobCompletionTime = this.createMetric("JobCompletionTime", arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0));
        this.consistencyCheckTime = this.createMetric("ConsistencyCheckTime", arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0));
        this.successfulJobs = this.createMetric("SuccessfulJobs", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.failedJobs = this.createMetric("FailedJobs", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.activeJobs = this.createMetric("ActiveJobs", name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0)));
        this.tokenRefreshed = this.createMetric("TokenRefreshed", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.tokenUnauthorized = this.createMetric("TokenUnauthorized", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
        this.tokenExpired = this.createMetric("TokenExpired", name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new));
    }

    private <T extends Metric> NamedMetric<T> createMetric(String simpleName, Function<String, T> metricCreator) {
        return NamedMetric.builder(metricCreator).withDomain(DOMAIN).withName(simpleName).build();
    }
}

