/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.cli.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Properties;
import org.apache.celeborn.cli.common.CliLogging;
import org.apache.celeborn.cli.config.CliConfig;
import org.apache.celeborn.cli.config.CliConfigManager$;
import org.apache.celeborn.common.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011<QAD\b\t\u0002i1Q\u0001H\b\t\u0002uAQ\u0001J\u0001\u0005\u0002\u0015BqAJ\u0001C\u0002\u0013\u0005q\u0005\u0003\u00044\u0003\u0001\u0006I\u0001\u000b\u0004\u00059=\u0001A\u0007C\u0003%\u000b\u0011\u00051\bC\u0004>\u000b\t\u0007I\u0011\u0002 \t\r\u001d+\u0001\u0015!\u0003@\u0011\u0015AU\u0001\"\u0001J\u0011\u0015\u0001V\u0001\"\u0003R\u0011\u00159V\u0001\"\u0001Y\u0011\u0015iV\u0001\"\u0001_\u0011\u0015\u0001W\u0001\"\u0001b\u0003A\u0019E.[\"p]\u001aLw-T1oC\u001e,'O\u0003\u0002\u0011#\u000511m\u001c8gS\u001eT!AE\n\u0002\u0007\rd\u0017N\u0003\u0002\u0015+\u0005A1-\u001a7fE>\u0014hN\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001\u0001\t\u00037\u0005i\u0011a\u0004\u0002\u0011\u00072L7i\u001c8gS\u001el\u0015M\\1hKJ\u001c\"!\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!$A\tdY&\u001cuN\u001c4jO\u001aKG.\u001a)bi\",\u0012\u0001\u000b\t\u0003SAr!A\u000b\u0018\u0011\u0005-\u0002S\"\u0001\u0017\u000b\u00055J\u0012A\u0002\u001fs_>$h(\u0003\u00020A\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\ty\u0003%\u0001\ndY&\u001cuN\u001c4jO\u001aKG.\u001a)bi\"\u00043cA\u0003\u001fkA\u0011a'O\u0007\u0002o)\u0011\u0001(E\u0001\u0007G>lWn\u001c8\n\u0005i:$AC\"mS2{wmZ5oOR\tA\b\u0005\u0002\u001c\u000b\u0005Q\u0001O]8qKJ$\u0018.Z:\u0016\u0003}\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\tU$\u0018\u000e\u001c\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1\u0015I\u0001\u0006Qe>\u0004XM\u001d;jKN\f1\u0002\u001d:pa\u0016\u0014H/[3tA\u0005QAn\\1e\u0007>tg-[4\u0015\u0003)\u00032aH&N\u0013\ta\u0005E\u0001\u0004PaRLwN\u001c\t\u000379K!aT\b\u0003\u0013\rc\u0017nQ8oM&<\u0017AC:bm\u0016\u001cuN\u001c4jOR\u0011!+\u0016\t\u0003?MK!\u0001\u0016\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006-*\u0001\r!T\u0001\nG2L7i\u001c8gS\u001e\f1!\u00193e)\r\u0011\u0016l\u0017\u0005\u00065.\u0001\r\u0001K\u0001\u0004W\u0016L\b\"\u0002/\f\u0001\u0004A\u0013!\u0002<bYV,\u0017A\u0002:f[>4X\r\u0006\u0002S?\")!\f\u0004a\u0001Q\u0005\u0019q-\u001a;\u0015\u0005\t\u001c\u0007cA\u0010LQ!)!,\u0004a\u0001Q\u0001")
public class CliConfigManager
implements CliLogging {
    private final Properties properties;

    public static String cliConfigFilePath() {
        return CliConfigManager$.MODULE$.cliConfigFilePath();
    }

    @Override
    public void log(String msg) {
        CliLogging.log$((CliLogging)this, msg);
    }

    @Override
    public void log(Object obj) {
        CliLogging.log$((CliLogging)this, obj);
    }

    @Override
    public void logInfo(String msg) {
        CliLogging.logInfo$(this, msg);
    }

    @Override
    public void logError(String msg) {
        CliLogging.logError$(this, msg);
    }

    private Properties properties() {
        return this.properties;
    }

    public Option<CliConfig> loadConfig() {
        File file = new File(CliConfigManager$.MODULE$.cliConfigFilePath());
        if (!file.exists()) {
            return None$.MODULE$;
        }
        return (Option)Utils$.MODULE$.tryWithResources((Function0 & Serializable & scala.Serializable)() -> new FileInputStream(file), (Function1 & Serializable & scala.Serializable)inputStream -> {
            this.properties().load((InputStream)inputStream);
            return new Some((Object)new CliConfig((Map<String, String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(this.properties().stringPropertyNames().toArray())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)this.properties().getProperty((String)key)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())));
        });
    }

    private void saveConfig(CliConfig cliConfig) {
        try {
            Object object;
            File file = new File(CliConfigManager$.MODULE$.cliConfigFilePath());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                object = BoxesRunTime.boxToBoolean((boolean)file.createNewFile());
            } else {
                object = BoxedUnit.UNIT;
            }
            this.properties().clear();
            FileOutputStream outputStream = new FileOutputStream(file);
            Utils$.MODULE$.tryWithResources((Function0 & Serializable & scala.Serializable)() -> outputStream, (Function1 & Serializable & scala.Serializable)os -> {
                CliConfigManager.$anonfun$saveConfig$2(this, cliConfig, os);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logError(new StringBuilder(21).append("Error saving config: ").append(e.getMessage()).toString());
        }
    }

    public void add(String key, String value) {
        CliConfig config = (CliConfig)this.loadConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> new CliConfig((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))));
        CliConfig updatedConfig = config.copy((Map<String, String>)config.cliConfigData().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        this.saveConfig(updatedConfig);
    }

    public void remove(String key) {
        CliConfig config = (CliConfig)this.loadConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> new CliConfig((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))));
        CliConfig updatedConfig = config.copy((Map<String, String>)((Map)config.cliConfigData().$minus((Object)key)));
        this.saveConfig(updatedConfig);
    }

    public Option<String> get(String key) {
        return this.loadConfig().flatMap((Function1 & Serializable & scala.Serializable)config -> config.cliConfigData().get((Object)key));
    }

    public static final /* synthetic */ void $anonfun$saveConfig$2(CliConfigManager $this, CliConfig cliConfig$1, FileOutputStream os) {
        cliConfig$1.cliConfigData().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return $this.properties().setProperty(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        $this.properties().store(os, new StringBuilder(21).append("Last updated conf at ").append(LocalDateTime.now()).toString());
    }

    public CliConfigManager() {
        CliLogging.$init$(this);
        this.properties = new Properties();
    }
}

