/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http.authentication;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import javax.security.sasl.AuthenticationException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.authentication.HttpAuthSchemes$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.server.common.http.HttpAuthUtils$;
import org.apache.celeborn.server.common.http.authentication.AuthenticationHandler;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u000b\u0016\u0001\u0011B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005o!)1\t\u0001C\u0001\t\"I\u0001\n\u0001a\u0001\u0002\u0004%I!\u0013\u0005\n%\u0002\u0001\r\u00111A\u0005\nMC\u0011\"\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002&\t\u0013i\u0003\u0001\u0019!a\u0001\n\u0013Y\u0006\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0003b\u0011%\u0019\u0007\u00011A\u0001B\u0003&A\fC\u0004e\u0001\u0001\u0007I\u0011B3\t\u000fA\u0004\u0001\u0019!C\u0005c\"11\u000f\u0001Q!\n\u0019Dq\u0001\u001e\u0001C\u0002\u0013\u0005S\u000fC\u0004\u0002\u0012\u0001\u0001\u000b\u0011\u0002<\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013\u00121d\u00159oK\u001e|\u0017)\u001e;iK:$\u0018nY1uS>t\u0007*\u00198eY\u0016\u0014(B\u0001\f\u0018\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!\u0001G\r\u0002\t!$H\u000f\u001d\u0006\u00035m\taaY8n[>t'B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\u0011adH\u0001\tG\u0016dWMY8s]*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0013,_A\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u0017\u000e\u0003UI!AL\u000b\u0003+\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7feB\u0011\u0001\u0007N\u0007\u0002c)\u0011!gM\u0001\tS:$XM\u001d8bY*\u0011!$H\u0005\u0003kE\u0012q\u0001T8hO&tw-\u0001\u0004lKf$\u0018M\u0019\t\u0003q}r!!O\u001f\u0011\u0005i:S\"A\u001e\u000b\u0005q\u001a\u0013A\u0002\u001fs_>$h(\u0003\u0002?O\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tqt%A\u0005qe&t7-\u001b9bY\u00061A(\u001b8jiz\"2!\u0012$H!\ta\u0003\u0001C\u00037\u0007\u0001\u0007q\u0007C\u0003C\u0007\u0001\u0007q'\u0001\u0006hgNl\u0015M\\1hKJ,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bAA[4tg*\u0011q*I\u0001\u0005S\u0016$h-\u0003\u0002R\u0019\nQqiU*NC:\fw-\u001a:\u0002\u001d\u001d\u001c8/T1oC\u001e,'o\u0018\u0013fcR\u0011Ak\u0016\t\u0003MUK!AV\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b1\u0016\t\t\u00111\u0001K\u0003\rAH%M\u0001\fON\u001cX*\u00198bO\u0016\u0014\b%\u0001\u0003d_:4W#\u0001/\u0011\u0005usV\"A\u001a\n\u0005}\u001b$\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017\u0001C2p]\u001a|F%Z9\u0015\u0005Q\u0013\u0007b\u0002-\t\u0003\u0003\u0005\r\u0001X\u0001\u0006G>tg\rI\u0001\u000eg\u0016\u0014h/\u001a:Tk\nTWm\u0019;\u0016\u0003\u0019\u0004\"a\u001a8\u000e\u0003!T!!\u001b6\u0002\t\u0005,H\u000f\u001b\u0006\u0003W2\f\u0001b]3dkJLG/\u001f\u0006\u0002[\u0006)!.\u0019<bq&\u0011q\u000e\u001b\u0002\b'V\u0014'.Z2u\u0003E\u0019XM\u001d<feN+(M[3di~#S-\u001d\u000b\u0003)JDq\u0001W\u0006\u0002\u0002\u0003\u0007a-\u0001\btKJ4XM]*vE*,7\r\u001e\u0011\u0002\u0015\u0005,H\u000f[*dQ\u0016lW-F\u0001w!\r9\u00181\u0002\b\u0004q\u0006\u0015abA=\u0002\u00049\u0019!0!\u0001\u000f\u0005m|hB\u0001?\u007f\u001d\tQT0C\u0001#\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011!$H\u0005\u0003-MJA!a\u0002\u0002\n\u0005y\u0001\n\u001e;q\u0003V$\bnU2iK6,7O\u0003\u0002\u0017g%!\u0011QBA\b\u00059AE\u000f\u001e9BkRD7k\u00195f[\u0016TA!a\u0002\u0002\n\u0005Y\u0011-\u001e;i'\u000eDW-\\3!\u0003]\tW\u000f\u001e5f]RL7-\u0019;j_:\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0002\u0018A\u0019a%!\u0007\n\u0007\u0005mqEA\u0004C_>dW-\u00198\u0002\t%t\u0017\u000e\u001e\u000b\u0004)\u0006\u0005\u0002\"\u0002.\u0011\u0001\u0004a\u0016a\u00023fgR\u0014x.\u001f\u000b\u0002)\u0006a\u0011-\u001e;iK:$\u0018nY1uKR)q'a\u000b\u0002>!9\u0011Q\u0006\nA\u0002\u0005=\u0012a\u0002:fcV,7\u000f\u001e\t\u0005\u0003c\tI$\u0004\u0002\u00024)\u0019\u0001$!\u000e\u000b\u0007\u0005]B.A\u0004tKJ4H.\u001a;\n\t\u0005m\u00121\u0007\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH\u000fC\u0004\u0002@I\u0001\r!!\u0011\u0002\u0011I,7\u000f]8og\u0016\u0004B!!\r\u0002D%!\u0011QIA\u001a\u0005MAE\u000f\u001e9TKJ4H.\u001a;SKN\u0004xN\\:f\u0003A\u0011XO\\,ji\"\u0004&/\u001b8dSB\fG\u000eF\u00048\u0003\u0017\ny%a\u0018\t\r\u000553\u00031\u00018\u0003=\u0019XM\u001d<feB\u0013\u0018N\\2ja\u0006d\u0007bBA)'\u0001\u0007\u00111K\u0001\fG2LWM\u001c;U_.,g\u000eE\u0003'\u0003+\nI&C\u0002\u0002X\u001d\u0012Q!\u0011:sCf\u00042AJA.\u0013\r\tif\n\u0002\u0005\u0005f$X\rC\u0004\u0002@M\u0001\r!!\u0011")
public class SpnegoAuthenticationHandler
implements AuthenticationHandler,
Logging {
    private final String keytab;
    private final String principal;
    private GSSManager gssManager;
    private CelebornConf conf;
    private Subject serverSubject;
    private final Enumeration.Value authScheme;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    @Override
    public boolean matchAuthScheme(String authorization) {
        return AuthenticationHandler.matchAuthScheme$(this, authorization);
    }

    @Override
    public String getAuthorization(HttpServletRequest request) {
        return AuthenticationHandler.getAuthorization$(this, request);
    }

    private Logger log$lzycompute() {
        SpnegoAuthenticationHandler spnegoAuthenticationHandler = this;
        synchronized (spnegoAuthenticationHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private GSSManager gssManager() {
        return this.gssManager;
    }

    private void gssManager_$eq(GSSManager x$1) {
        this.gssManager = x$1;
    }

    private CelebornConf conf() {
        return this.conf;
    }

    private void conf_$eq(CelebornConf x$1) {
        this.conf = x$1;
    }

    private Subject serverSubject() {
        return this.serverSubject;
    }

    private void serverSubject_$eq(Subject x$1) {
        this.serverSubject = x$1;
    }

    @Override
    public Enumeration.Value authScheme() {
        return this.authScheme;
    }

    @Override
    public boolean authenticationSupported() {
        return new StringOps(Predef$.MODULE$.augmentString(this.keytab)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(this.principal)).nonEmpty();
    }

    @Override
    public void init(CelebornConf conf) {
        this.conf_$eq(conf);
        if (this.authenticationSupported()) {
            File keytabFile = new File(this.keytab);
            if (!keytabFile.exists()) {
                throw new ServletException(new StringBuilder(24).append("Keytab[").append(this.keytab).append("] does not exists").toString());
            }
            if (!this.principal.startsWith("HTTP/")) {
                throw new ServletException(new StringBuilder(44).append("SPNEGO principal[").append(this.principal).append("] does not start with HTTP/").toString());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Using keytab ").append($this.keytab).append(", for principal ").append($this.principal).toString());
            this.serverSubject().getPrivateCredentials().add(KeyTab.getInstance(keytabFile));
            this.serverSubject().getPrincipals().add(new KerberosPrincipal(this.principal));
            if (!KerberosName.hasRulesBeenSet()) {
                KerberosName.setRules((String)"DEFAULT");
            }
            try {
                this.gssManager_$eq(Subject.doAs(this.serverSubject(), new PrivilegedExceptionAction<GSSManager>(null){

                    public GSSManager run() {
                        return GSSManager.getInstance();
                    }
                }));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            return;
        }
    }

    @Override
    public void destroy() {
        this.serverSubject_$eq(null);
    }

    @Override
    public String authenticate(HttpServletRequest request, HttpServletResponse response) {
        String authUser = null;
        String authorization = this.getAuthorization(request);
        byte[] clientToken = Base64.getDecoder().decode(authorization);
        try {
            String serverPrincipal = KerberosUtil.getTokenServerName((byte[])clientToken);
            if (!serverPrincipal.startsWith("HTTP/")) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Invalid server principal ").append(serverPrincipal).append(" decoded from client request").toString());
            }
            authUser = Subject.doAs(this.serverSubject(), new PrivilegedExceptionAction<String>(this, serverPrincipal, clientToken, response){
                private final /* synthetic */ SpnegoAuthenticationHandler $outer;
                private final String serverPrincipal$1;
                private final byte[] clientToken$1;
                private final HttpServletResponse response$1;

                public String run() {
                    return this.$outer.runWithPrincipal(this.serverPrincipal$1, this.clientToken$1, this.response$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.serverPrincipal$1 = serverPrincipal$1;
                    this.clientToken$1 = clientToken$1;
                    this.response$1 = response$1;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception exception = ex.getException();
            if (exception instanceof IOException) {
                IOException iOException = (IOException)exception;
                throw iOException;
            }
            if (exception != null) {
                Exception exception2 = exception;
                throw new AuthenticationException("SPNEGO authentication failed", exception2);
            }
            throw new MatchError((Object)exception);
        }
        catch (Exception e) {
            throw new AuthenticationException("SPNEGO authentication failed", e);
        }
        return authUser;
    }

    public String runWithPrincipal(String serverPrincipal, byte[] clientToken, HttpServletResponse response) {
        GSSContext gssContext = null;
        GSSCredential gssCreds = null;
        String authUser = null;
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("SPNEGO initialized with server principal ").append(serverPrincipal).toString());
            gssCreds = this.gssManager().createCredential(this.gssManager().createName(serverPrincipal, KerberosUtil.NT_GSS_KRB5_PRINCIPAL_OID), Integer.MAX_VALUE, (Oid[])((Object[])new Oid[]{KerberosUtil.GSS_SPNEGO_MECH_OID, KerberosUtil.GSS_KRB5_MECH_OID}), 2);
            gssContext = this.gssManager().createContext(gssCreds);
            byte[] serverToken = gssContext.acceptSecContext(clientToken, 0, clientToken.length);
            if (serverToken != null && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(serverToken)).nonEmpty()) {
                String authenticate = Base64.getEncoder().encodeToString(serverToken);
                response.setHeader(HttpAuthUtils$.MODULE$.WWW_AUTHENTICATE_HEADER(), new StringBuilder(1).append(HttpAuthSchemes$.MODULE$.NEGOTIATE()).append(" ").append(authenticate).toString());
            }
            if (!gssContext.isEstablished()) {
                response.setStatus(401);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SPNEGO in progress");
            } else {
                String userName;
                String clientPrincipal = ((Object)gssContext.getSrcName()).toString();
                KerberosName kerberosName = new KerberosName(clientPrincipal);
                authUser = userName = kerberosName.getShortName();
                response.setStatus(200);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("SPNEGO completed for client principal ").append(clientPrincipal).toString());
            }
        }
        finally {
            if (gssContext != null) {
                gssContext.dispose();
            }
            if (gssCreds != null) {
                gssCreds.dispose();
            }
        }
        return authUser;
    }

    public SpnegoAuthenticationHandler(String keytab, String principal) {
        this.keytab = keytab;
        this.principal = principal;
        AuthenticationHandler.$init$(this);
        Logging.$init$((Logging)this);
        this.serverSubject = new Subject();
        this.authScheme = HttpAuthSchemes$.MODULE$.NEGOTIATE();
    }
}

