/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage.segment;

import io.netty.channel.Channel;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.service.deploy.worker.storage.MapPartitionData;
import org.apache.celeborn.service.deploy.worker.storage.MapPartitionDataReader;
import org.apache.celeborn.service.deploy.worker.storage.segment.SegmentMapPartitionDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMapPartitionData
extends MapPartitionData {
    public static final Logger logger = LoggerFactory.getLogger(SegmentMapPartitionData.class);

    public SegmentMapPartitionData(int minReadBuffers, int maxReadBuffers, ConcurrentHashMap<String, ExecutorService> storageFetcherPool, int threadsPerMountPoint, DiskFileInfo fileInfo, Consumer<Long> recycleStream, int minBuffersToTriggerRead) throws IOException {
        super(minReadBuffers, maxReadBuffers, storageFetcherPool, threadsPerMountPoint, fileInfo, recycleStream, minBuffersToTriggerRead);
    }

    @Override
    public void setupDataPartitionReader(int startSubIndex, int endSubIndex, long streamId, Channel channel) {
        SegmentMapPartitionDataReader mapPartitionDataReader = new SegmentMapPartitionDataReader(startSubIndex, endSubIndex, this.getDiskFileInfo(), streamId, channel, () -> this.recycleStream.accept(streamId));
        logger.debug("Setup data partition reader from {} to {} with streamId {}", new Object[]{startSubIndex, endSubIndex, streamId});
        this.readers.put(streamId, mapPartitionDataReader);
    }

    @Override
    protected void openReader(MapPartitionDataReader reader) throws IOException {
        super.openReader(reader);
        if (reader instanceof SegmentMapPartitionDataReader) {
            ((SegmentMapPartitionDataReader)reader).updateSegmentId();
        } else {
            logger.warn("openReader only expects SegmentMapPartitionDataReader.");
        }
    }

    @Override
    public String toString() {
        return String.format("SegmentMapPartitionData{filePath=%s}", this.diskFileInfo.getFilePath());
    }

    public void notifyRequiredSegmentId(int segmentId, long streamId, int subPartitionId) {
        MapPartitionDataReader streamReader = this.getStreamReader(streamId);
        if (!(streamReader instanceof SegmentMapPartitionDataReader)) {
            logger.warn("notifyRequiredSegmentId only expects non-null SegmentMapPartitionDataReader.");
            return;
        }
        ((SegmentMapPartitionDataReader)streamReader).notifyRequiredSegmentId(segmentId, subPartitionId);
        this.readExecutor.submit(() -> {
            try {
                streamReader.sendData();
            }
            catch (Throwable throwable) {
                logger.error("Failed to send data.", throwable);
            }
        });
    }
}

