/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.relation.AspectualTextRelation;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.CoreferenceRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.cr.UriCollectionReader;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class THYMEAnaforaXMLReader
extends JCasAnnotator_ImplBase {
    private static Logger LOGGER = Logger.getLogger(THYMEAnaforaXMLReader.class);
    public static final String PARAM_ANAFORA_DIRECTORY = "anaforaDirectory";
    @ConfigurationParameter(name="anaforaDirectory", description="root directory of the Anafora-annotated files, with one subdirectory for each annotated file")
    protected File anaforaDirectory;
    public static final String PARAM_ANAFORA_XML_SUFFIXES = "anaforaSuffixes";
    @ConfigurationParameter(name="anaforaSuffixes", mandatory=false, description="list of suffixes that might be added to a file name to identify the Anafora XML annotations file; only the first suffix corresponding to a file will be used")
    protected String[] anaforaXMLSuffixes = new String[]{".Temporal-Relations.gold.completed.xml", ".Temporal-Relation.gold.completed.xml", ".Temporal.dave.completed.xml", ".Temporal-Relation-Adjudication.gold.completed.xml", ".Temporal-Entity-Adjudication.gold.completed.xml", ".temporal.Temporal-Adjudication.gold.completed.xml", ".temporal.Temporal-Entities.gold.completed.xml", ".Temporal-Entity.gold.completed.xml", ".Gold_Temporal_Entities.xml", ".Gold_Temporal_Relations.xml"};

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(THYMEAnaforaXMLReader.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getDescription(File anaforaDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(THYMEAnaforaXMLReader.class, (Object[])new Object[]{PARAM_ANAFORA_DIRECTORY, anaforaDirectory});
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        File textFile = new File(ViewUriUtil.getURI((JCas)jCas));
        LOGGER.info((Object)("processing " + textFile));
        File corefFile = new File(textFile.getPath() + ".Coreference.gold.completed.xml");
        ArrayList possibleXMLFiles = Lists.newArrayList();
        for (String anaforaXMLSuffix : this.anaforaXMLSuffixes) {
            if (this.anaforaDirectory == null) {
                possibleXMLFiles.add(new File(textFile + anaforaXMLSuffix));
                continue;
            }
            possibleXMLFiles.add(new File(textFile.getPath() + anaforaXMLSuffix));
        }
        File xmlFile = null;
        for (File possibleXMLFile : possibleXMLFiles) {
            if (!possibleXMLFile.exists()) continue;
            xmlFile = possibleXMLFile;
            break;
        }
        if (this.anaforaXMLSuffixes.length > 0 && xmlFile == null) {
            throw new IllegalArgumentException("no Anafora XML file found from " + possibleXMLFiles);
        }
        if (xmlFile != null) {
            THYMEAnaforaXMLReader.processXmlFile(jCas, xmlFile);
        }
        if (corefFile.exists()) {
            THYMEAnaforaXMLReader.processXmlFile(jCas, corefFile);
        }
    }

    private static void processXmlFile(JCas jCas, File xmlFile) throws AnalysisEngineProcessException {
        Element dataElem;
        try {
            dataElem = new SAXBuilder().build(xmlFile.toURI().toURL()).getRootElement();
        }
        catch (MalformedURLException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        int curEventId = 1;
        int curTimexId = 1;
        int curRelId = 1;
        int docLen = jCas.getDocumentText().length();
        for (Element annotationsElem : dataElem.getChildren("annotations")) {
            String id;
            HashMap idToAnnotation = Maps.newHashMap();
            for (Element entityElem : annotationsElem.getChildren("entity")) {
                TimeMention timeMention;
                TimeMention annotation;
                id = THYMEAnaforaXMLReader.removeSingleChildText(entityElem, "id", null);
                Element spanElem = THYMEAnaforaXMLReader.removeSingleChild(entityElem, "span", id);
                String type = THYMEAnaforaXMLReader.removeSingleChildText(entityElem, "type", id);
                Element propertiesElem = THYMEAnaforaXMLReader.removeSingleChild(entityElem, "properties", id);
                int begin = Integer.MAX_VALUE;
                int end = Integer.MIN_VALUE;
                for (String spanString : spanElem.getText().split(";")) {
                    String[] beginEndStrings = spanString.split(",");
                    if (beginEndStrings.length != 2) {
                        THYMEAnaforaXMLReader.error("span not of the format 'number,number'", id);
                    }
                    int spanBegin = Integer.parseInt(beginEndStrings[0]);
                    int spanEnd = Integer.parseInt(beginEndStrings[1]);
                    if (spanBegin < begin) {
                        begin = spanBegin;
                    }
                    if (spanEnd <= end) continue;
                    end = spanEnd;
                }
                if (begin < 0 || end >= docLen) {
                    THYMEAnaforaXMLReader.error("Illegal begin or end boundary", id);
                    continue;
                }
                if (type.equals("EVENT")) {
                    String docTimeRel = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "DocTimeRel", id);
                    if (docTimeRel == null) {
                        THYMEAnaforaXMLReader.error("no docTimeRel, assuming OVERLAP", id);
                        docTimeRel = "OVERLAP";
                    }
                    String eventType = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Type", id);
                    String degree = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Degree", id);
                    String polarity = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Polarity", id);
                    String contextualModality = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "ContextualModality", id);
                    String contextualAspect = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "ContextualAspect", id);
                    String permanence = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Permanence", id);
                    EventMention eventMention = new EventMention(jCas, begin, end);
                    Event event = new Event(jCas);
                    EventProperties eventProperties = new EventProperties(jCas);
                    eventProperties.setDocTimeRel(docTimeRel);
                    eventProperties.setCategory(eventType);
                    eventProperties.setDegree(degree);
                    if (polarity.equals("POS")) {
                        eventProperties.setPolarity(1);
                    } else if (polarity.equals("NEG")) {
                        eventProperties.setPolarity(-1);
                    } else {
                        THYMEAnaforaXMLReader.error("polarity that was not POS or NEG", id);
                    }
                    eventProperties.setContextualModality(contextualModality);
                    eventProperties.setContextualAspect(contextualAspect);
                    eventProperties.setPermanence(permanence);
                    eventProperties.addToIndexes();
                    event.setConfidence(1.0);
                    event.setDiscoveryTechnique(2);
                    event.setProperties(eventProperties);
                    event.setMentions(new FSArray(jCas, 1));
                    event.setMentions(0, (IdentifiedAnnotation)eventMention);
                    event.addToIndexes();
                    eventMention.setId(curEventId++);
                    eventMention.setConfidence(1.0f);
                    eventMention.setDiscoveryTechnique(2);
                    eventMention.setEvent(event);
                    eventMention.addToIndexes();
                    annotation = eventMention;
                } else if (type.equals("TIMEX3")) {
                    String timeClass = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Class", id);
                    TimeMention timeMention2 = new TimeMention(jCas, begin, end);
                    timeMention2.setId(curTimexId++);
                    timeMention2.setTimeClass(timeClass);
                    timeMention2.addToIndexes();
                    annotation = timeMention2;
                } else if (type.equals("DOCTIME")) {
                    timeMention = new TimeMention(jCas, begin, end);
                    timeMention.setId(curTimexId++);
                    timeMention.setTimeClass(type);
                    timeMention.addToIndexes();
                    annotation = timeMention;
                } else if (type.equals("SECTIONTIME")) {
                    timeMention = new TimeMention(jCas, begin, end);
                    timeMention.setId(curTimexId++);
                    timeMention.setTimeClass(type);
                    timeMention.addToIndexes();
                    annotation = timeMention;
                } else if (type.equals("Markable")) {
                    while (end >= begin && (jCas.getDocumentText().charAt(end - 1) == '\n' || jCas.getDocumentText().charAt(end - 1) == '\r')) {
                        --end;
                    }
                    Markable markable = new Markable(jCas, begin, end);
                    markable.addToIndexes();
                    annotation = markable;
                } else {
                    if (type.equals("DUPLICATE")) {
                        LOGGER.warn((Object)"Ignoring duplicate sections in annotations.");
                        continue;
                    }
                    throw new UnsupportedOperationException("unsupported entity type: " + type);
                }
                idToAnnotation.put(id, annotation);
                THYMEAnaforaXMLReader.removeSingleChild(entityElem, "parentsType", id);
                if (propertiesElem.getChildren().isEmpty() && entityElem.getChildren().isEmpty()) continue;
                ArrayList children = Lists.newArrayList();
                for (Element child : propertiesElem.getChildren()) {
                    children.add(child.getName());
                }
                for (Element child : entityElem.getChildren()) {
                    children.add(child.getName());
                }
                THYMEAnaforaXMLReader.error("unprocessed children " + children, id);
            }
            for (Element relationElem : annotationsElem.getChildren("relation")) {
                TemporalTextRelation relation;
                String targetID;
                String sourceID;
                id = THYMEAnaforaXMLReader.removeSingleChildText(relationElem, "id", null);
                String type = THYMEAnaforaXMLReader.removeSingleChildText(relationElem, "type", id);
                Element propertiesElem = THYMEAnaforaXMLReader.removeSingleChild(relationElem, "properties", id);
                if (type.equals("TLINK")) {
                    sourceID = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Source", id);
                    targetID = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Target", id);
                    String tlinkType = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Type", id);
                    relation = new TemporalTextRelation(jCas);
                    relation.setId(curRelId++);
                    THYMEAnaforaXMLReader.addRelation(jCas, (BinaryTextRelation)relation, sourceID, targetID, tlinkType, idToAnnotation, id);
                } else if (type.equals("ALINK")) {
                    sourceID = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Source", id);
                    targetID = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Target", id);
                    String alinkType = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "Type", id);
                    relation = new AspectualTextRelation(jCas);
                    THYMEAnaforaXMLReader.addRelation(jCas, (BinaryTextRelation)relation, sourceID, targetID, alinkType, idToAnnotation, id);
                } else if (type.equals("Identical")) {
                    NonEmptyFSList list;
                    CollectionTextRelation chain = new CollectionTextRelation(jCas);
                    String mention = THYMEAnaforaXMLReader.removeSingleChildText(propertiesElem, "FirstInstance", id);
                    NonEmptyFSList root = list = new NonEmptyFSList(jCas);
                    Markable antecedent = (Markable)idToAnnotation.get(mention);
                    list.setHead((TOP)antecedent);
                    List corefs = propertiesElem.getChildren("Coreferring_String");
                    for (Element coref : corefs) {
                        mention = coref.getText();
                        NonEmptyFSList child = new NonEmptyFSList(jCas);
                        Markable anaphor = (Markable)idToAnnotation.get(mention);
                        child.setHead((TOP)anaphor);
                        CoreferenceRelation pair = new CoreferenceRelation(jCas);
                        pair.setCategory("Identity");
                        RelationArgument arg1 = new RelationArgument(jCas);
                        arg1.setArgument((Annotation)antecedent);
                        arg1.setRole("antecedent");
                        pair.setArg1(arg1);
                        RelationArgument arg2 = new RelationArgument(jCas);
                        arg2.setArgument((Annotation)anaphor);
                        arg2.setRole("anaphor");
                        pair.setArg2(arg2);
                        pair.addToIndexes();
                        list.setTail((FSList)child);
                        list = child;
                        antecedent = anaphor;
                    }
                    propertiesElem.removeChildren("Coreferring_String");
                    EmptyFSList tail = new EmptyFSList(jCas);
                    list.setTail((FSList)tail);
                    root.addToIndexes();
                    chain.setMembers((FSList)root);
                    chain.addToIndexes();
                } else if (type.equals("Set/Subset")) {
                    THYMEAnaforaXMLReader.error("This reader has not implemented reading of Set/Subset relations yet", id);
                } else if (type.equals("Whole/Part")) {
                    THYMEAnaforaXMLReader.error("This reader has not implemented reading of Whole/Part relations yet", id);
                } else if (type.equals("Appositive")) {
                    THYMEAnaforaXMLReader.error("This reader has not implemented reading of Appositive relations yet", id);
                } else {
                    throw new UnsupportedOperationException("unsupported relation type: " + type);
                }
                THYMEAnaforaXMLReader.removeSingleChild(relationElem, "parentsType", id);
                if (propertiesElem.getChildren().isEmpty() && relationElem.getChildren().isEmpty()) continue;
                ArrayList children = Lists.newArrayList();
                for (Element child : propertiesElem.getChildren()) {
                    children.add(child.getName());
                }
                for (Element child : relationElem.getChildren()) {
                    children.add(child.getName());
                }
                THYMEAnaforaXMLReader.error("unprocessed children " + children, id);
            }
        }
    }

    private static Element getSingleChild(Element elem, String elemName, String causeID) {
        List children = elem.getChildren(elemName);
        if (children.size() != 1) {
            THYMEAnaforaXMLReader.error(String.format("not exactly one '%s' child", elemName), causeID);
        }
        return children.size() > 0 ? (Element)children.get(0) : null;
    }

    private static Element removeSingleChild(Element elem, String elemName, String causeID) {
        Element child = THYMEAnaforaXMLReader.getSingleChild(elem, elemName, causeID);
        elem.removeChildren(elemName);
        return child;
    }

    private static String removeSingleChildText(Element elem, String elemName, String causeID) {
        Element child = THYMEAnaforaXMLReader.getSingleChild(elem, elemName, causeID);
        String text = child.getText();
        if (text.isEmpty()) {
            THYMEAnaforaXMLReader.error(String.format("an empty '%s' child", elemName), causeID);
            text = null;
        }
        elem.removeChildren(elemName);
        return text;
    }

    private static void addRelation(JCas jCas, BinaryTextRelation relation, String sourceID, String targetID, String category, Map<String, Annotation> idToAnnotation, String causeID) {
        if (sourceID != null && targetID != null) {
            Annotation source = THYMEAnaforaXMLReader.getArgument(sourceID, idToAnnotation, causeID);
            Annotation target = THYMEAnaforaXMLReader.getArgument(targetID, idToAnnotation, causeID);
            if (source != null && target != null) {
                RelationArgument sourceArg = new RelationArgument(jCas);
                sourceArg.setArgument(source);
                sourceArg.addToIndexes();
                RelationArgument targetArg = new RelationArgument(jCas);
                targetArg.setArgument(target);
                targetArg.addToIndexes();
                relation.setCategory(category);
                relation.setArg1(sourceArg);
                relation.setArg2(targetArg);
                relation.addToIndexes();
            }
        }
    }

    private static Annotation getArgument(String id, Map<String, Annotation> idToAnnotation, String causeID) {
        Annotation annotation = idToAnnotation.get(id);
        if (annotation == null) {
            THYMEAnaforaXMLReader.error("no annotation with id " + id, causeID);
        }
        return annotation;
    }

    private static void error(String found, String id) {
        LOGGER.error((Object)String.format("found %s in annotation with ID %s", found, id));
    }

    public static void main(String[] args) throws Exception {
        ArrayList files = Lists.newArrayList();
        for (String path : args) {
            files.add(new File(path));
        }
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles((Collection)files);
        AnalysisEngine engine = AnalysisEngineFactory.createEngine(THYMEAnaforaXMLReader.class, (Object[])new Object[0]);
        SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngine[])new AnalysisEngine[]{engine});
    }
}

