/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.baselines;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;

public class TreeHeightBaseline
extends RelationExtractorAnnotator {
    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TreeHeightBaseline.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    public String classify(List<Feature> features) {
        return "CONTAINS";
    }

    protected List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> getFeatureExtractors() {
        return new ArrayList<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>>();
    }

    protected List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Annotation sentence) {
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> results = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        ArrayList<EventMention> events = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence);
        ArrayList<EventMention> realEvents = new ArrayList<EventMention>();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        events = realEvents;
        if (events.size() < 2) {
            return results;
        }
        int minDepth = Integer.MAX_VALUE;
        EventMention anchorMention = null;
        for (EventMention event : events) {
            TreebankNode node = AnnotationTreeUtils.annotationNode((JCas)jCas, (Annotation)event);
            int depth = 0;
            while (node.getParent() != null) {
                ++depth;
                node = node.getParent();
            }
            if (depth >= minDepth) continue;
            minDepth = depth;
            anchorMention = event;
        }
        for (EventMention event : events) {
            if (event == anchorMention) continue;
            results.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair(anchorMention, (IdentifiedAnnotation)event));
        }
        return results;
    }
}

