/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import info.bethard.timenorm.DefaultTokenizer$;
import info.bethard.timenorm.TemporalExpressionParser;
import info.bethard.timenorm.TimeSpan;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;
import scala.Function1;
import scala.util.Try;

public class PrintFailedTimeNormalizations {
    private static Pattern DOC_TIME_PATTERN = Pattern.compile("rev_date=\"([^\"]+)\"");

    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<File> files = THYMEData.getFilesFor(trainItems, options.getRawTextDirectory());
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles(files);
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(UriToDocumentTextAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.XMIReader.class, (Object[])new Object[]{"XMIDirectory", options.getXMIDirectory()}), new String[0]);
        String grammarPath = "/org/apache/ctakes/temporal/timenorm.en.grammar";
        URL grammarURL = PrintFailedTimeNormalizations.class.getResource(grammarPath);
        TemporalExpressionParser parser = new TemporalExpressionParser(grammarURL, (Function1)DefaultTokenizer$.MODULE$);
        JCasIterator casIter = new JCasIterator(reader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            JCas goldView = jCas.getView("GoldView");
            Matcher matcher = DOC_TIME_PATTERN.matcher(goldView.getDocumentText());
            if (!matcher.find()) {
                System.err.println(goldView.getDocumentText());
                continue;
            }
            Try anchorTry = parser.parse(matcher.group(1), TimeSpan.of((int)1, (int)1, (int)1));
            if (!anchorTry.isSuccess() || !(anchorTry.get() instanceof TimeSpan)) continue;
            TimeSpan anchor = (TimeSpan)anchorTry.get();
            for (Segment segment : JCasUtil.select((JCas)jCas, Segment.class)) {
                if (THYMEData.SEGMENTS_TO_SKIP.contains(segment.getId())) continue;
                for (TimeMention time : JCasUtil.selectCovered((JCas)goldView, TimeMention.class, (AnnotationFS)segment)) {
                    String timeText = time.getCoveredText();
                    Try parsedTime = parser.parse(timeText, anchor);
                    if (parsedTime.isSuccess()) continue;
                    System.err.println(timeText);
                    System.err.println(parsedTime);
                }
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi"})
        public File getXMIDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"text"})
        public File getRawTextDirectory();
    }
}

