/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.duration;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class PreserveCertainEventTimeRelationsInGold
extends JCasAnnotator_ImplBase {
    public static final String GOLD_VIEW_NAME = "GoldView";

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCas goldView;
        File durationLookup = new File("/Users/dima/Boston/Thyme/Duration/Data/Combined/Distribution/all.txt");
        Map textToDistribution = null;
        try {
            textToDistribution = (Map)Files.readLines((File)durationLookup, (Charset)Charsets.UTF_8, (LineProcessor)new Utils.Callback());
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            goldView = jCas.getView(GOLD_VIEW_NAME);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, BinaryTextRelation.class))) {
            String eventText;
            String timeText;
            RelationArgument arg1 = relation.getArg1();
            RelationArgument arg2 = relation.getArg2();
            if (arg1.getArgument() instanceof TimeMention && arg2.getArgument() instanceof EventMention) {
                timeText = arg1.getArgument().getCoveredText().toLowerCase();
                eventText = Utils.normalizeEventText(jCas, arg2.getArgument());
            } else {
                if (!(arg1.getArgument() instanceof EventMention) || !(arg2.getArgument() instanceof TimeMention)) continue;
                eventText = Utils.normalizeEventText(jCas, arg1.getArgument());
                timeText = arg2.getArgument().getCoveredText().toLowerCase();
            }
            HashSet<String> timeUnits = Utils.getTimeUnits(timeText);
            if (textToDistribution.containsKey(eventText) && timeUnits.size() > 0) continue;
            arg1.removeFromIndexes();
            arg2.removeFromIndexes();
            relation.removeFromIndexes();
        }
        for (EventMention mention : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, EventMention.class))) {
            String eventText = Utils.normalizeEventText(jCas, (Annotation)mention);
            if (textToDistribution.containsKey(eventText)) continue;
            mention.removeFromIndexes();
        }
        for (EventMention mention : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, TimeMention.class))) {
            HashSet<String> timeUnits = Utils.getTimeUnits(mention.getCoveredText().toLowerCase());
            if (timeUnits.size() > 0) continue;
            mention.removeFromIndexes();
        }
    }
}

