/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.lexicalscope.jewel.cli.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ctakes.chunker.ae.Chunker;
import org.apache.ctakes.chunker.ae.DefaultChunkCreator;
import org.apache.ctakes.chunker.ae.adjuster.ChunkAdjuster;
import org.apache.ctakes.constituency.parser.ae.ConstituencyParser;
import org.apache.ctakes.contexttokenizer.ae.ContextDependentTokenizerAnnotator;
import org.apache.ctakes.core.ae.OverlapAnnotator;
import org.apache.ctakes.core.ae.SentenceDetector;
import org.apache.ctakes.core.ae.TokenizerAnnotatorPTB;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.dependency.parser.ae.ClearNLPDependencyParserAE;
import org.apache.ctakes.dependency.parser.ae.ClearNLPSemanticRoleLabelerAE;
import org.apache.ctakes.dictionary.lookup2.ae.DefaultJCasTermAnnotator;
import org.apache.ctakes.lvg.ae.LvgAnnotator;
import org.apache.ctakes.postagger.POSTagger;
import org.apache.ctakes.temporal.ae.I2B2TemporalXMLReader;
import org.apache.ctakes.temporal.ae.THYMEAnaforaXMLReader;
import org.apache.ctakes.temporal.ae.THYMEKnowtatorXMLReader;
import org.apache.ctakes.temporal.ae.THYMETreebankReader;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.Chunk;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.LookupWindowAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.component.ViewTextCopierAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.TypePrioritiesFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.XMLSerializer;
import org.cleartk.timeml.util.TimeWordsExtractor;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class Evaluation_ImplBase<STATISTICS_TYPE>
extends org.cleartk.eval.Evaluation_ImplBase<Integer, STATISTICS_TYPE> {
    static Logger LOGGER = Logger.getLogger(Evaluation_ImplBase.class);
    private static final String LOOKUP_PATH = "/org/apache/ctakes/temporal/badEEContainNotes.txt";
    private static boolean isTraining;
    public static HashSet<String> badNotes;
    public static final String GOLD_VIEW_NAME = "GoldView";
    public static final String PROB_VIEW_NAME = "ProbView";
    protected File rawTextDirectory;
    protected File xmlDirectory;
    protected XMLFormat xmlFormat;
    protected Subcorpus subcorpus;
    protected File xmiDirectory;
    private boolean xmiExists;
    protected File treebankDirectory;
    protected boolean printErrors = false;
    protected boolean printOverlapping = false;
    protected String i2b2Output = null;
    protected String anaforaOutput = null;
    protected String[] kernelParams;

    public static List<Integer> getTrainItems(Options options) {
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, options.getTrainRemainders().getList());
        if (options.getTest()) {
            trainItems.addAll(THYMEData.getPatientSets(patientSets, options.getDevRemainders().getList()));
        }
        return trainItems;
    }

    public static List<Integer> getTestItems(Options options) {
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> testItems = options.getTest() ? THYMEData.getPatientSets(patientSets, options.getTestRemainders().getList()) : THYMEData.getPatientSets(patientSets, options.getDevRemainders().getList());
        return testItems;
    }

    public Evaluation_ImplBase(File baseDirectory, File rawTextDirectory, File xmlDirectory, XMLFormat xmlFormat, Subcorpus subcorpus, File xmiDirectory, File treebankDirectory) {
        super(baseDirectory);
        this.rawTextDirectory = rawTextDirectory;
        this.xmlDirectory = xmlDirectory;
        this.xmlFormat = xmlFormat;
        this.subcorpus = subcorpus;
        this.xmiDirectory = xmiDirectory;
        this.xmiExists = this.xmiDirectory.exists() && this.xmiDirectory.listFiles().length > 0;
        this.treebankDirectory = treebankDirectory;
        isTraining = true;
        badNotes = new HashSet();
        URL url = TimeWordsExtractor.class.getResource(LOOKUP_PATH);
        try (BufferedReader br = new BufferedReader(new FileReader(url.getFile()));){
            String line;
            while ((line = br.readLine()) != null) {
                badNotes.add(line.trim());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setI2B2Output(String outDir) {
        this.i2b2Output = outDir;
    }

    public void prepareXMIsFor(List<Integer> patientSets) throws Exception {
        boolean needsXMIs = false;
        for (File textFile : this.getFilesFor(patientSets)) {
            if (Evaluation_ImplBase.getXMIFile(this.xmiDirectory, textFile).exists()) continue;
            needsXMIs = true;
            break;
        }
        if (needsXMIs) {
            CollectionReader reader = this.getCollectionReader(patientSets);
            AnalysisEngine engine = this.getXMIWritingPreprocessorAggregateBuilder().createAggregate();
            SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngine[])new AnalysisEngine[]{engine});
        }
        this.xmiExists = true;
    }

    private List<File> getFilesFor(List<Integer> patientSets) throws FileNotFoundException {
        ArrayList<File> files = new ArrayList<File>();
        if (this.xmlFormat == XMLFormat.Anafora) {
            HashSet<String> ids = new HashSet<String>();
            for (Integer n : patientSets) {
                if (this.subcorpus == Subcorpus.Colon) {
                    ids.add(String.format("ID%03d", n));
                    continue;
                }
                if (this.subcorpus == Subcorpus.DeepPhe) {
                    ids.add(String.format("patient%02d", n));
                    continue;
                }
                ids.add(String.format("doc%04d", n));
            }
            int filePrefixLen = 5;
            if (this.subcorpus == Subcorpus.Brain) {
                filePrefixLen = 7;
            } else if (this.subcorpus == Subcorpus.DeepPhe) {
                filePrefixLen = 9;
            }
            if (this.subcorpus == Subcorpus.DeepPhe) {
                for (File dir : this.xmlDirectory.listFiles()) {
                    if (!dir.isDirectory() || !ids.contains(dir.getName().substring(0, filePrefixLen))) continue;
                    File file = new File(dir, dir.getName());
                    if (file.exists()) {
                        files.add(file);
                        continue;
                    }
                    LOGGER.warn((Object)("Missing note: " + file));
                }
            } else {
                for (String section : THYMEData.SECTIONS) {
                    File xmlSubdir = new File(this.xmlDirectory, section);
                    for (File dir : xmlSubdir.listFiles()) {
                        if (!dir.isDirectory() || !ids.contains(dir.getName().substring(0, filePrefixLen))) continue;
                        File file = new File(dir, dir.getName());
                        if (file.exists()) {
                            files.add(file);
                            continue;
                        }
                        LOGGER.warn((Object)("Missing note: " + file));
                    }
                }
            }
        } else if (this.xmlFormat == XMLFormat.I2B2) {
            File trainDir = new File(this.xmlDirectory, "training");
            File testDir = new File(this.xmlDirectory, "test");
            for (Integer pt : patientSets) {
                File xmlTrain = new File(trainDir, pt + ".xml");
                File train = new File(trainDir, pt + ".xml.txt");
                if (train.exists()) {
                    if (xmlTrain.exists()) {
                        files.add(train);
                    } else {
                        System.err.println("Text file in training has no corresponding xml -- skipping: " + train);
                    }
                }
                File xmlTest = new File(testDir, pt + ".xml");
                File test = new File(testDir, pt + ".xml.txt");
                if (xmlTest.exists()) {
                    if (test.exists()) {
                        files.add(test);
                    } else {
                        throw new FileNotFoundException("Could not find the test text file -- for cTAKES usage you must copy the text files into the xml directory for the test set.");
                    }
                }
                assert (!train.exists() || !test.exists());
            }
        } else if (this.xmlFormat == XMLFormat.Knowtator) {
            LOGGER.warn((Object)"This is an old annotation format -- please upgrade to using anafora files.");
            for (Integer set : patientSets) {
                final int n = set;
                for (File file : this.rawTextDirectory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.contains(String.format("ID%03d", n));
                    }
                })) {
                    if (file.isHidden()) continue;
                    files.add(file);
                }
            }
        } else {
            LOGGER.error((Object)"Unknown data format -- please specify Anafora, i2b2, or Knowtator format.");
        }
        return files;
    }

    protected CollectionReader getCollectionReader(List<Integer> patientSets) throws Exception {
        List<File> collectedFiles = this.getFilesFor(patientSets);
        Collections.sort(collectedFiles);
        return UriCollectionReader.getCollectionReaderFromFiles(collectedFiles);
    }

    protected AggregateBuilder getPreprocessorAggregateBuilder() throws Exception {
        return this.xmiExists ? this.getXMIReadingPreprocessorAggregateBuilder() : this.getXMIWritingPreprocessorAggregateBuilder();
    }

    protected AggregateBuilder getXMIReadingPreprocessorAggregateBuilder() throws UIMAException {
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(UriToDocumentTextAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(XMIReader.class, (Object[])new Object[]{"XMIDirectory", this.xmiDirectory}), new String[0]);
        return aggregateBuilder;
    }

    protected AggregateBuilder getXMIWritingPreprocessorAggregateBuilder() throws Exception {
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(UriToDocumentTextAnnotatorCtakes.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", GOLD_VIEW_NAME}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ViewTextCopierAnnotator.class, (Object[])new Object[]{"sourceViewName", "_InitialView", "destinationViewName", GOLD_VIEW_NAME}), new String[0]);
        switch (this.xmlFormat) {
            case Anafora: {
                if (this.subcorpus == Subcorpus.DeepPhe) {
                    aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(THYMEAnaforaXMLReader.class, (Object[])new Object[]{"anaforaDirectory", this.xmlDirectory, "anaforaSuffixes", new String[0]}), new String[]{"_InitialView", GOLD_VIEW_NAME});
                    break;
                }
                aggregateBuilder.add(THYMEAnaforaXMLReader.getDescription(this.xmlDirectory), new String[]{"_InitialView", GOLD_VIEW_NAME});
                break;
            }
            case Knowtator: {
                aggregateBuilder.add(THYMEKnowtatorXMLReader.getDescription(this.xmlDirectory), new String[]{"_InitialView", GOLD_VIEW_NAME});
                break;
            }
            case I2B2: {
                aggregateBuilder.add(I2B2TemporalXMLReader.getDescription(this.xmlDirectory), new String[]{"_InitialView", GOLD_VIEW_NAME});
            }
        }
        if (this.subcorpus == Subcorpus.DeepPhe) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(PittHeaderAnnotator.class, (Object[])new Object[0]), new String[0]);
        } else {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(SegmentsFromBracketedSectionTagsAnnotator.class, (Object[])new Object[0]), new String[0]);
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(SentenceDetector.class, (Object[])new Object[]{"SentenceModelFile", "org/apache/ctakes/core/sentdetect/sd-med-model.zip"}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(TokenizerAnnotatorPTB.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ContextDependentTokenizerAnnotator.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(POSTagger.class, (TypeSystemDescription)TypeSystemDescriptionFactory.createTypeSystemDescription(), (TypePriorities)TypePrioritiesFactory.createTypePriorities((Class[])new Class[]{Segment.class, Sentence.class, BaseToken.class}), (Object[])new Object[]{"PosModelFile", "org/apache/ctakes/postagger/models/mayo-pos.zip"}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(Chunker.class, (Object[])new Object[]{"ChunkerModelFile", FileLocator.locateFile((String)"org/apache/ctakes/chunker/models/chunker-model.zip"), "ChunkCreatorClass", DefaultChunkCreator.class}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ChunkAdjuster.class, (Object[])new Object[]{"ChunkPattern", new String[]{"NP", "NP"}, "IndexOfTokenToInclude", 1}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ChunkAdjuster.class, (Object[])new Object[]{"ChunkPattern", new String[]{"NP", "PP", "NP"}, "IndexOfTokenToInclude", 2}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CopyNPChunksToLookupWindowAnnotations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(OverlapAnnotator.class, (Object[])new Object[]{"A_ObjectClass", LookupWindowAnnotation.class, "B_ObjectClass", LookupWindowAnnotation.class, "OverlapType", "A_ENV_B", "ActionType", "DELETE", "DeleteAction", new String[]{"selector=B"}}), new String[0]);
        aggregateBuilder.add(LvgAnnotator.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(DefaultJCasTermAnnotator.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(ClearNLPDependencyParserAE.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ClearNLPSemanticRoleLabelerAE.class, (Object[])new Object[0]), new String[0]);
        if (this.treebankDirectory != null) {
            aggregateBuilder.add(THYMETreebankReader.getDescription(this.treebankDirectory), new String[0]);
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(TimexAnnotationCorrector.class, (Object[])new Object[0]), new String[0]);
        } else {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ConstituencyParser.class, (Object[])new Object[]{"MODEL_FILENAME", "org/apache/ctakes/constituency/parser/models/thyme.bin"}), new String[0]);
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(XMIWriter.class, (Object[])new Object[]{"XMIDirectory", this.xmiDirectory}), new String[0]);
        return aggregateBuilder;
    }

    public static <T extends Annotation> List<T> selectExact(JCas jCas, Class<T> annotationClass, Segment segment) {
        ArrayList annotations = Lists.newArrayList();
        for (Annotation annotation : JCasUtil.selectCovered((JCas)jCas, annotationClass, (AnnotationFS)segment)) {
            if (!annotation.getClass().equals(annotationClass)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    static File getXMIFile(File xmiDirectory, File textFile) {
        String fileName = textFile.getName();
        if (!fileName.contains(".xmi")) {
            fileName = fileName + ".xmi";
        }
        return new File(xmiDirectory, fileName);
    }

    static File getXMIFile(File xmiDirectory, JCas jCas) throws AnalysisEngineProcessException {
        return Evaluation_ImplBase.getXMIFile(xmiDirectory, new File(ViewUriUtil.getURI((JCas)jCas).getPath()));
    }

    public static String getRelationId(TemporalTextRelation rel) {
        StringBuffer buffer = new StringBuffer();
        if (rel.getArg1().getArgument().getClass().getSimpleName().equals("EventMention")) {
            buffer.append('e');
        } else {
            buffer.append('t');
        }
        buffer.append(((IdentifiedAnnotation)rel.getArg1().getArgument()).getId());
        buffer.append(':');
        if (rel.getArg2().getArgument().getClass().getSimpleName().equals("EventMention")) {
            buffer.append('e');
        } else {
            buffer.append('t');
        }
        buffer.append(((IdentifiedAnnotation)rel.getArg2().getArgument()).getId());
        return buffer.toString();
    }

    public static class WriteAnaforaXML
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_OUTPUT_DIR = "PARAM_OUTPUT_DIR";
        @ConfigurationParameter(mandatory=true, description="Output directory to write xml files to.", name="PARAM_OUTPUT_DIR")
        protected String outputDir;
        public static final String PARAM_PROB_VIEW = "ProbView";
        @ConfigurationParameter(name="ProbView", mandatory=false)
        public String probViewname = null;

        public void process(JCas jcas) throws AnalysisEngineProcessException {
            try {
                Element property;
                Element parentTE;
                Element typeE;
                Element spanE;
                Element idE;
                File inFile = new File(ViewUriUtil.getURI((JCas)jcas));
                String outFile = inFile.getName().replace(".txt", "");
                File outDir = new File(this.outputDir, outFile);
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
                JCas probView = this.probViewname == null ? null : jcas.getView(this.probViewname);
                Map<Integer, List<EventMention>> mentions = this.probViewname == null ? null : WriteAnaforaXML.getMentionIdMap(jcas, probView);
                Map<String, List<TemporalTextRelation>> rels = this.probViewname == null ? null : WriteAnaforaXML.getRelationIdMap(probView);
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("data");
                Element infoElement = doc.createElement("info");
                Element saveTime = doc.createElement("savetime");
                saveTime.setTextContent("2015-0123-10:21");
                Element progress = doc.createElement("progress");
                progress.setTextContent("completed");
                infoElement.appendChild(saveTime);
                infoElement.appendChild(progress);
                Element schema = doc.createElement("schema");
                schema.setAttribute("path", "./");
                schema.setAttribute("protocol", "file");
                schema.setTextContent("temporal-schema.xml");
                Element annoElement = doc.createElement("annotations");
                HashMap<Object, String> argToId = new HashMap<Object, String>();
                int id = 1;
                for (EventMention event : JCasUtil.select((JCas)jcas, EventMention.class)) {
                    if (!event.getClass().equals(EventMention.class)) continue;
                    Element eventEl = doc.createElement("entity");
                    String eventID = id + "@e@" + outFile + "@system";
                    ++id;
                    argToId.put(event, eventID);
                    idE = doc.createElement("id");
                    idE.setTextContent(eventID);
                    spanE = doc.createElement("span");
                    spanE.setTextContent(String.valueOf(event.getBegin()) + "," + String.valueOf(event.getEnd()));
                    typeE = doc.createElement("type");
                    typeE.setTextContent("EVENT");
                    parentTE = doc.createElement("parentsType");
                    parentTE.setTextContent("TemporalEntities");
                    property = doc.createElement("properties");
                    Element docTimeRE = doc.createElement("DocTimeRel");
                    String dtrContent = null;
                    if (this.probViewname == null) {
                        dtrContent = event.getEvent().getProperties().getDocTimeRel();
                    } else {
                        StringBuffer buff = new StringBuffer();
                        for (EventMention probMention : mentions.get(event.getId())) {
                            buff.append(probMention.getEvent().getProperties().getDocTimeRel());
                            buff.append(':');
                            buff.append(probMention.getConfidence());
                            buff.append("::");
                        }
                        dtrContent = buff.substring(0, buff.length() - 2);
                    }
                    docTimeRE.setTextContent(dtrContent);
                    Element eventTypeE = doc.createElement("Type");
                    eventTypeE.setTextContent("N/A");
                    Element degreeE = doc.createElement("Degree");
                    degreeE.setTextContent("N/A");
                    Element polarityE = doc.createElement("Polarity");
                    String polarity = "UNKNOWN";
                    int polarityInt = event.getPolarity();
                    if (polarityInt == 1) {
                        polarity = "POS";
                    } else if (polarityInt == -1) {
                        polarity = "NEG";
                    }
                    polarityE.setTextContent(polarity);
                    Element ctexModE = doc.createElement("ContextualModality");
                    ctexModE.setTextContent(event.getEvent().getProperties().getContextualModality());
                    Element ctexAspE = doc.createElement("ContextualAspect");
                    ctexAspE.setTextContent(event.getEvent().getProperties().getContextualAspect());
                    Element permE = doc.createElement("Permanence");
                    permE.setTextContent("UNDETERMINED");
                    property.appendChild(docTimeRE);
                    property.appendChild(polarityE);
                    property.appendChild(degreeE);
                    property.appendChild(eventTypeE);
                    property.appendChild(ctexModE);
                    property.appendChild(ctexAspE);
                    property.appendChild(permE);
                    eventEl.appendChild(idE);
                    eventEl.appendChild(spanE);
                    eventEl.appendChild(typeE);
                    eventEl.appendChild(parentTE);
                    eventEl.appendChild(property);
                    annoElement.appendChild(eventEl);
                }
                for (TimeMention timex : JCasUtil.select((JCas)jcas, TimeMention.class)) {
                    Element timexElement = doc.createElement("entity");
                    String timexID = id + "@e@" + outFile + "@system";
                    ++id;
                    argToId.put(timex, timexID);
                    idE = doc.createElement("id");
                    idE.setTextContent(timexID);
                    spanE = doc.createElement("span");
                    spanE.setTextContent(String.valueOf(timex.getBegin()) + "," + String.valueOf(timex.getEnd()));
                    typeE = doc.createElement("type");
                    parentTE = doc.createElement("parentsType");
                    parentTE.setTextContent("TemporalEntities");
                    property = doc.createElement("properties");
                    String timeClass = timex.getTimeClass();
                    try {
                        String value = Utils.getTimexMLValue(timex.getCoveredText());
                        property.setTextContent(value);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("time norm error: " + e.getMessage()));
                    }
                    if (timeClass != null && (timeClass.equals("DOCTIME") || timeClass.equals("SECTIONTIME"))) {
                        typeE.setTextContent(timeClass);
                        property.setTextContent("");
                    } else {
                        typeE.setTextContent("TIMEX3");
                        Element classE = doc.createElement("Class");
                        classE.setTextContent(timeClass);
                        property.appendChild(classE);
                    }
                    timexElement.appendChild(idE);
                    timexElement.appendChild(spanE);
                    timexElement.appendChild(typeE);
                    timexElement.appendChild(property);
                    annoElement.appendChild(timexElement);
                }
                id = 1;
                if (this.probViewname == null) {
                    for (TemporalTextRelation rel : JCasUtil.select((JCas)jcas, TemporalTextRelation.class)) {
                        Annotation arg1 = rel.getArg1().getArgument();
                        Annotation arg2 = rel.getArg2().getArgument();
                        String arg1Content = (String)argToId.get(arg1);
                        String arg2Content = (String)argToId.get(arg2);
                        String relContent = rel.getCategory();
                        annoElement.appendChild(WriteAnaforaXML.addRelationElement(doc, id, relContent, arg1Content, arg2Content, outFile));
                        ++id;
                    }
                } else {
                    for (String key : rels.keySet()) {
                        String arg1Content = null;
                        String arg2Content = null;
                        StringBuffer buff = new StringBuffer();
                        for (TemporalTextRelation probRel : rels.get(key)) {
                            buff.append(probRel.getCategory());
                            buff.append(':');
                            buff.append(probRel.getConfidence());
                            buff.append("::");
                            if (arg1Content != null) continue;
                            arg1Content = (String)argToId.get(probRel.getArg1().getArgument());
                            arg2Content = (String)argToId.get(probRel.getArg2().getArgument());
                        }
                        String relContent = buff.substring(0, buff.length() - 2);
                        annoElement.appendChild(WriteAnaforaXML.addRelationElement(doc, id, relContent, arg1Content, arg2Content, outFile));
                        ++id;
                    }
                }
                rootElement.appendChild(infoElement);
                rootElement.appendChild(schema);
                rootElement.appendChild(annoElement);
                doc.appendChild(rootElement);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(outDir, outFile + ".xml"));
                transformer.transform(source, result);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (TransformerException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (CASException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }

        private static Element addRelationElement(Document doc, int id, String relContent, String arg1Content, String arg2Content, String outFile) {
            Element linkEl = doc.createElement("relation");
            String linkID = id + "@r@" + outFile + "@system";
            Element idE = doc.createElement("id");
            idE.setTextContent(linkID);
            Element typeE = doc.createElement("type");
            typeE.setTextContent("TLINK");
            Element parentTE = doc.createElement("parentsType");
            parentTE.setTextContent("TemporalRelations");
            Element property = doc.createElement("properties");
            Element sourceE = doc.createElement("Source");
            sourceE.setTextContent(arg1Content);
            Element relTypeE = doc.createElement("Type");
            relTypeE.setTextContent(relContent);
            Element targetE = doc.createElement("Target");
            targetE.setTextContent(arg2Content);
            property.appendChild(sourceE);
            property.appendChild(relTypeE);
            property.appendChild(targetE);
            linkEl.appendChild(idE);
            linkEl.appendChild(typeE);
            linkEl.appendChild(parentTE);
            linkEl.appendChild(property);
            return linkEl;
        }

        private static Map<Integer, List<EventMention>> getMentionIdMap(JCas jcas, JCas probView) {
            HashMap<Integer, List<EventMention>> map = new HashMap<Integer, List<EventMention>>();
            for (EventMention mention : JCasUtil.select((JCas)jcas, EventMention.class)) {
                ArrayList<EventMention> variations = new ArrayList<EventMention>();
                for (EventMention probMention : JCasUtil.select((JCas)probView, EventMention.class)) {
                    if (mention.getId() != probMention.getId()) continue;
                    variations.add(probMention);
                }
                map.put(mention.getId(), variations);
            }
            return map;
        }

        private static Map<String, List<TemporalTextRelation>> getRelationIdMap(JCas probView) {
            HashMap<String, List<TemporalTextRelation>> map = new HashMap<String, List<TemporalTextRelation>>();
            for (TemporalTextRelation probRel : JCasUtil.select((JCas)probView, TemporalTextRelation.class)) {
                String idStr = Evaluation_ImplBase.getRelationId(probRel);
                if (!map.containsKey(idStr)) {
                    map.put(idStr, new ArrayList());
                }
                List<TemporalTextRelation> variations = map.get(idStr);
                variations.add(probRel);
            }
            return map;
        }
    }

    public static class WriteI2B2XML
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_OUTPUT_DIR = "PARAM_OUTPUT_DIR";
        @ConfigurationParameter(mandatory=true, description="Output directory to write xml files to.", name="PARAM_OUTPUT_DIR")
        protected String outputDir;

        public void process(JCas jcas) throws AnalysisEngineProcessException {
            try {
                File outDir = new File(this.outputDir);
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
                File inFile = new File(ViewUriUtil.getURI((JCas)jcas));
                String outFile = inFile.getName().replace(".txt", "");
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("ClinicalNarrativeTemporalAnnotation");
                Element textElement = doc.createElement("TEXT");
                Element tagsElement = doc.createElement("TAGS");
                textElement.setTextContent(jcas.getDocumentText());
                rootElement.appendChild(textElement);
                rootElement.appendChild(tagsElement);
                doc.appendChild(rootElement);
                HashMap<Object, String> argToId = new HashMap<Object, String>();
                int id = 0;
                for (TimeMention timex : JCasUtil.select((JCas)jcas, TimeMention.class)) {
                    Element timexElement = doc.createElement("TIMEX3");
                    String timexID = "T" + id;
                    ++id;
                    argToId.put(timex, timexID);
                    timexElement.setAttribute("id", timexID);
                    timexElement.setAttribute("start", String.valueOf(timex.getBegin() + 1));
                    timexElement.setAttribute("end", String.valueOf(timex.getEnd() + 1));
                    timexElement.setAttribute("text", timex.getCoveredText());
                    timexElement.setAttribute("type", "NA");
                    timexElement.setAttribute("val", "NA");
                    timexElement.setAttribute("mod", "NA");
                    tagsElement.appendChild(timexElement);
                }
                id = 0;
                for (EventMention event : JCasUtil.select((JCas)jcas, EventMention.class)) {
                    if (!event.getClass().equals(EventMention.class)) continue;
                    Element eventEl = doc.createElement("EVENT");
                    String eventID = "E" + id;
                    ++id;
                    argToId.put(event, eventID);
                    eventEl.setAttribute("id", eventID);
                    eventEl.setAttribute("start", String.valueOf(event.getBegin() + 1));
                    eventEl.setAttribute("end", String.valueOf(event.getEnd() + 1));
                    eventEl.setAttribute("text", event.getCoveredText());
                    eventEl.setAttribute("modality", "NA");
                    eventEl.setAttribute("polarity", "NA");
                    eventEl.setAttribute("type", "NA");
                    tagsElement.appendChild(eventEl);
                }
                id = 0;
                for (TemporalTextRelation rel : JCasUtil.select((JCas)jcas, TemporalTextRelation.class)) {
                    Element linkEl = doc.createElement("TLINK");
                    String linkID = "TL" + id;
                    ++id;
                    linkEl.setAttribute("id", linkID);
                    Annotation arg1 = rel.getArg1().getArgument();
                    linkEl.setAttribute("fromID", (String)argToId.get(arg1));
                    linkEl.setAttribute("fromText", arg1.getCoveredText());
                    Annotation arg2 = rel.getArg2().getArgument();
                    if (arg2 != null) {
                        linkEl.setAttribute("toID", (String)argToId.get(arg2));
                        linkEl.setAttribute("toText", arg2.getCoveredText());
                    } else {
                        linkEl.setAttribute("toID", "Discharge");
                        linkEl.setAttribute("toText", "Discharge");
                    }
                    linkEl.setAttribute("type", rel.getCategory());
                    tagsElement.appendChild(linkEl);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(this.outputDir, outFile));
                transformer.transform(source, result);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (TransformerException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public static class UriToDocumentTextAnnotatorCtakes
    extends UriToDocumentTextAnnotator {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            URI uri = ViewUriUtil.getURI((JCas)jCas);
            try {
                String content = CharStreams.toString((Readable)new InputStreamReader(uri.toURL().openStream()));
                content = content.replace('\f', ' ');
                jCas.setSofaDataString(content, "text/plain");
            }
            catch (MalformedURLException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    @PipeBitInfo(name="System Annotation Copier", description="Copies an annotation type from the System view to a Gold view.", role=PipeBitInfo.Role.SPECIAL)
    public static class CopyFromSystem
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_ANNOTATION_CLASSES = "AnnotationClasses";
        @ConfigurationParameter(name="AnnotationClasses", mandatory=true)
        private Class<? extends TOP>[] annotationClasses;

        public static AnalysisEngineDescription getDescription(Class<?> ... classes) throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(CopyFromSystem.class, (Object[])new Object[]{PARAM_ANNOTATION_CLASSES, classes});
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView(Evaluation_ImplBase.GOLD_VIEW_NAME);
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (Class<? extends TOP> annotationClass : this.annotationClasses) {
                for (TOP annotation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, annotationClass))) {
                    if (!annotation.getClass().equals(annotationClass)) continue;
                    annotation.removeFromIndexes();
                }
            }
            CasCopier copier = new CasCopier(systemView.getCas(), goldView.getCas());
            Feature sofaFeature = jCas.getTypeSystem().getFeatureByFullName("uima.cas.AnnotationBase:sofa");
            for (Class<? extends TOP> annotationClass : this.annotationClasses) {
                for (TOP annotation : JCasUtil.select((JCas)systemView, annotationClass)) {
                    TOP copy = (TOP)copier.copyFs((FeatureStructure)annotation);
                    if (copy instanceof Annotation) {
                        copy.setFeatureValue(sofaFeature, (FeatureStructure)goldView.getSofa());
                    }
                    copy.addToIndexes(goldView);
                }
            }
        }
    }

    @PipeBitInfo(name="Gold Annotation Copier", description="Copies an annotation type from the Gold view to the System view.", role=PipeBitInfo.Role.SPECIAL)
    public static class CopyFromGold
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_ANNOTATION_CLASSES = "AnnotationClasses";
        @ConfigurationParameter(name="AnnotationClasses", mandatory=true)
        private Class<? extends TOP>[] annotationClasses;

        public static AnalysisEngineDescription getDescription(Class<?> ... classes) throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(CopyFromGold.class, (Object[])new Object[]{PARAM_ANNOTATION_CLASSES, classes});
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView(Evaluation_ImplBase.GOLD_VIEW_NAME);
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (Class<? extends TOP> annotationClass : this.annotationClasses) {
                for (TOP annotation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)systemView, annotationClass))) {
                    if (!annotation.getClass().equals(annotationClass)) continue;
                    annotation.removeFromIndexes();
                }
            }
            CasCopier copier = new CasCopier(goldView.getCas(), systemView.getCas());
            Feature sofaFeature = jCas.getTypeSystem().getFeatureByFullName("uima.cas.AnnotationBase:sofa");
            for (Class<? extends TOP> annotationClass : this.annotationClasses) {
                for (TOP annotation : JCasUtil.select((JCas)goldView, annotationClass)) {
                    TOP copy = (TOP)copier.copyFs((FeatureStructure)annotation);
                    if (copy instanceof Annotation) {
                        copy.setFeatureValue(sofaFeature, (FeatureStructure)systemView.getSofa());
                    }
                    copy.addToIndexes(systemView);
                }
            }
        }
    }

    public static class TimexAnnotationCorrector
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView(Evaluation_ImplBase.GOLD_VIEW_NAME);
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException();
            }
            for (TimeMention mention : JCasUtil.select((JCas)goldView, TimeMention.class)) {
                TerminalTreebankNode leftTerm;
                List nodes = JCasUtil.selectCovered((JCas)systemView, TreebankNode.class, (AnnotationFS)mention);
                TreebankNode sameSpanNode = null;
                for (TreebankNode node : nodes) {
                    if (node.getBegin() != mention.getBegin() || node.getEnd() != mention.getEnd()) continue;
                    sameSpanNode = node;
                    break;
                }
                if (sameSpanNode != null) {
                    int numChildren;
                    if (!sameSpanNode.getNodeType().equals("PP") || (numChildren = sameSpanNode.getChildren().size()) != 2 || !sameSpanNode.getChildren(0).getNodeType().equals("IN") || !sameSpanNode.getChildren(1).getNodeType().equals("NP")) continue;
                    TreebankNode mentionNode = sameSpanNode.getChildren(numChildren - 1);
                    mention.setBegin(mentionNode.getBegin());
                    mention.setEnd(mentionNode.getEnd());
                    continue;
                }
                List precedingPreterms = JCasUtil.selectPreceding((JCas)systemView, TerminalTreebankNode.class, (AnnotationFS)mention, (int)1);
                if (precedingPreterms == null || precedingPreterms.size() != 1 || !(leftTerm = (TerminalTreebankNode)precedingPreterms.get(0)).getNodeType().equals("DT")) continue;
                List matchingNodes = JCasUtil.selectCovered((JCas)systemView, TreebankNode.class, (int)leftTerm.getBegin(), (int)mention.getEnd());
                for (TreebankNode node : matchingNodes) {
                    if (node.getBegin() != leftTerm.getBegin() || node.getEnd() != mention.getEnd()) continue;
                    sameSpanNode = node;
                    break;
                }
                if (sameSpanNode == null) continue;
                System.err.println("Adding DT: " + leftTerm.getCoveredText() + " to TIMEX: " + mention.getCoveredText());
                mention.setBegin(leftTerm.getBegin());
            }
        }
    }

    public static class XMIReader
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_XMI_DIRECTORY = "XMIDirectory";
        @ConfigurationParameter(name="XMIDirectory", mandatory=true)
        private File xmiDirectory;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            File xmiFile = Evaluation_ImplBase.getXMIFile(this.xmiDirectory, jCas);
            try (FileInputStream inputStream = new FileInputStream(xmiFile);){
                XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
            }
            catch (SAXException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public static class XMIWriter
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_XMI_DIRECTORY = "XMIDirectory";
        @ConfigurationParameter(name="XMIDirectory", mandatory=true)
        private File xmiDirectory;

        public void initialize(UimaContext context) throws ResourceInitializationException {
            super.initialize(context);
            if (!this.xmiDirectory.exists()) {
                this.xmiDirectory.mkdirs();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            File xmiFile = Evaluation_ImplBase.getXMIFile(this.xmiDirectory, jCas);
            try (FileOutputStream outputStream = new FileOutputStream(xmiFile);){
                XmiCasSerializer serializer = new XmiCasSerializer(jCas.getTypeSystem());
                ContentHandler handler = new XMLSerializer((OutputStream)outputStream, false).getContentHandler();
                serializer.serialize(jCas.getCas(), handler);
            }
            catch (SAXException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public static class PittHeaderAnnotator
    extends JCasAnnotator_ImplBase {
        public void process(JCas jcas) throws AnalysisEngineProcessException {
            String docText = jcas.getDocumentText();
            int headerEnd = docText.indexOf("\n", docText.indexOf("[Report de-identified"));
            Segment mainSegment = new Segment(jcas, headerEnd + 1, docText.length() - 1);
            mainSegment.setId("SIMPLE_SEGMENT");
            mainSegment.addToIndexes();
        }
    }

    public static class SegmentsFromBracketedSectionTagsAnnotator
    extends JCasAnnotator_ImplBase {
        private static Pattern SECTION_PATTERN = Pattern.compile("(\\[start section id=\"?(.*?)\"?\\]).*?(\\[end section id=\"?(.*?)\"?\\])", 32);

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            Segment segment;
            boolean foundSections = false;
            Matcher matcher = SECTION_PATTERN.matcher(jCas.getDocumentText());
            while (matcher.find()) {
                segment = new Segment(jCas);
                segment.setBegin(matcher.start() + matcher.group(1).length());
                segment.setEnd(matcher.end() - matcher.group(3).length());
                segment.setId(matcher.group(2));
                segment.addToIndexes();
                foundSections = true;
            }
            if (!foundSections) {
                segment = new Segment(jCas);
                segment.setBegin(0);
                segment.setEnd(jCas.getDocumentText().length());
                segment.setId("SIMPLE_SEGMENT");
                segment.addToIndexes();
            }
        }
    }

    public static class EventMentionRemover
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (EventMention mention : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, EventMention.class))) {
                mention.removeFromIndexes();
            }
        }
    }

    public static class EntityMentionRemover
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (EntityMention mention : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, EntityMention.class))) {
                mention.removeFromIndexes();
            }
        }
    }

    @PipeBitInfo(name="Overlap Lookup Window Remover", description="Removes Lookup Windows that are within larger Lookup Windows.", role=PipeBitInfo.Role.SPECIAL)
    public static class RemoveEnclosedLookupWindows
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            ArrayList lws = new ArrayList(JCasUtil.select((JCas)jCas, LookupWindowAnnotation.class));
            for (int i = lws.size() - 2; i >= 0; --i) {
                LookupWindowAnnotation lw1 = (LookupWindowAnnotation)lws.get(i);
                LookupWindowAnnotation lw2 = (LookupWindowAnnotation)lws.get(i + 1);
                if (lw1.getBegin() > lw2.getBegin() || lw1.getEnd() < lw2.getEnd()) continue;
                lws.remove(i + 1);
                lw2.removeFromIndexes();
            }
        }
    }

    @PipeBitInfo(name="NP Lookup Window Creator", description="Creates a Lookup Window from Noun Phrase Chunks.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.CHUNK})
    public static class CopyNPChunksToLookupWindowAnnotations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (Chunk chunk : JCasUtil.select((JCas)jCas, Chunk.class)) {
                if (!chunk.getChunkType().equals("NP")) continue;
                new LookupWindowAnnotation(jCas, chunk.getBegin(), chunk.getEnd()).addToIndexes();
            }
        }
    }

    public static interface Options {
        @Option(longName={"text"}, defaultToNull=true)
        public File getRawTextDirectory();

        @Option(longName={"xml"})
        public File getXMLDirectory();

        @Option(longName={"format"}, defaultValue={"Anafora"})
        public XMLFormat getXMLFormat();

        @Option(longName={"subcorpus"}, defaultValue={"Colon"})
        public Subcorpus getSubcorpus();

        @Option(longName={"xmi"})
        public File getXMIDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"train-remainders"}, defaultValue={"0-3"})
        public CommandLine.IntegerRanges getTrainRemainders();

        @Option(longName={"dev-remainders"}, defaultValue={"4-5"})
        public CommandLine.IntegerRanges getDevRemainders();

        @Option(longName={"test-remainders"}, defaultValue={"6-7"})
        public CommandLine.IntegerRanges getTestRemainders();

        @Option(longName={"treebank"}, defaultToNull=true)
        public File getTreebankDirectory();

        @Option
        public boolean getUseGoldTrees();

        @Option
        public boolean getGrid();

        @Option
        public boolean getPrintErrors();

        @Option
        public boolean getPrintOverlappingSpans();

        @Option
        public boolean getTest();

        @Option(longName={"kernelParams"}, defaultToNull=true)
        public String getKernelParams();

        @Option(defaultToNull=true)
        public String getI2B2Output();

        @Option(defaultToNull=true)
        public String getAnaforaOutput();

        @Option
        public boolean getSkipTrain();

        @Option(longName={"skipWrite"})
        public boolean getSkipDataWriting();
    }

    public static enum Subcorpus {
        Colon,
        Brain,
        DeepPhe;

    }

    public static enum XMLFormat {
        Knowtator,
        Anafora,
        I2B2;

    }
}

