/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.ae;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.TemporalRelationExtractorAnnotator;
import org.apache.ctakes.temporal.nn.data.ArgContextProvider;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.util.ViewUriUtil;

@PipeBitInfo(name="E-T POS TLinker", description="Creates Event - Time TLinks with Parts of Speech.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventTimePosBasedAnnotator
extends CleartkAnnotator<String> {
    public static final String NO_RELATION_CATEGORY = "none";

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
        if (this.isTraining()) {
            relationLookup = new HashMap();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                Annotation arg2;
                Annotation arg1 = relation.getArg1().getArgument();
                List<Annotation> key = Arrays.asList(arg1, arg2 = relation.getArg2().getArgument());
                if (relationLookup.containsKey(key)) {
                    String reln = ((BinaryTextRelation)relationLookup.get(key)).getCategory();
                    System.err.println("Error in: " + ViewUriUtil.getURI((JCas)jCas).toString());
                    System.err.println("Error! This attempted relation " + relation.getCategory() + " already has a relation " + reln + " at this span: " + arg1.getCoveredText() + " -- " + arg2.getCoveredText());
                    continue;
                }
                relationLookup.put(key, relation);
            }
        }
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> candidatePairs = this.getCandidateRelationArgumentPairs(jCas, (Annotation)sentence);
            for (TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair pair : candidatePairs) {
                String[] tokens;
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                String context = arg2.getBegin() < arg1.getBegin() ? ArgContextProvider.getPosContext(jCas, sentence, (Annotation)arg2, "t", (Annotation)arg1, "e", 2) : ArgContextProvider.getPosContext(jCas, sentence, (Annotation)arg1, "e", (Annotation)arg2, "t", 2);
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (String token : tokens = context.split(" ")) {
                    features.add(new Feature((Object)token.toLowerCase()));
                }
                if (this.isTraining()) {
                    String category = this.getRelationCategory(relationLookup, arg1, arg2);
                    category = category == null ? NO_RELATION_CATEGORY : category.toLowerCase();
                    this.dataWriter.write(new Instance((Object)category, features));
                    continue;
                }
                String predictedCategory = (String)this.classifier.classify(features);
                if (predictedCategory == null || predictedCategory.equals(NO_RELATION_CATEGORY)) continue;
                if (predictedCategory.endsWith("-1")) {
                    predictedCategory = predictedCategory.substring(0, predictedCategory.length() - 2);
                    if (arg1 instanceof TimeMention) {
                        IdentifiedAnnotation temp = arg1;
                        arg1 = arg2;
                        arg2 = temp;
                    }
                } else if (arg1 instanceof EventMention) {
                    IdentifiedAnnotation temp = arg1;
                    arg1 = arg2;
                    arg2 = temp;
                }
                this.createRelation(jCas, arg1, arg2, predictedCategory.toUpperCase(), 0.0);
            }
        }
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null) {
            category = relation.getCategory();
            if (arg1 instanceof EventMention) {
                category = category + "-1";
            }
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null) {
                category = relation.getCategory();
                if (arg2 instanceof EventMention) {
                    category = category + "-1";
                }
            }
        }
        return category;
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }

    public List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Annotation sentence) {
        ArrayList pairs = Lists.newArrayList();
        for (EventMention event : JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence)) {
            if (!event.getClass().equals(EventMention.class)) continue;
            for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sentence)) {
                pairs.add(new TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)event, (IdentifiedAnnotation)time));
            }
        }
        return pairs;
    }
}

