/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.data;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class DtrRelPrinter {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        File trainFile = options.getTrainOutputDirectory();
        if (trainFile.exists()) {
            trainFile.delete();
        }
        trainFile.createNewFile();
        File devFile = options.getTestOutputDirectory();
        if (devFile.exists()) {
            devFile.delete();
        }
        devFile.createNewFile();
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<Integer> devItems = THYMEData.getPatientSets(patientSets, THYMEData.DEV_REMAINDERS);
        List<File> trainFiles = Utils.getFilesFor(trainItems, options.getInputDirectory());
        List<File> devFiles = Utils.getFilesFor(devItems, options.getInputDirectory());
        Collections.sort(trainFiles);
        CollectionReader trainCollectionReader = Utils.getCollectionReader(trainFiles);
        AnalysisEngine trainDataWriter = AnalysisEngineFactory.createEngine(DocTimeRelSnippetPrinter.class, (Object[])new Object[]{"OutputFile", trainFile.getAbsoluteFile()});
        SimplePipeline.runPipeline((CollectionReader)trainCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{trainDataWriter});
        CollectionReader devCollectionReader = Utils.getCollectionReader(devFiles);
        AnalysisEngine devDataWriter = AnalysisEngineFactory.createEngine(DocTimeRelSnippetPrinter.class, (Object[])new Object[]{"OutputFile", devFile.getAbsolutePath()});
        SimplePipeline.runPipeline((CollectionReader)devCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{devDataWriter});
    }

    public static String getEventContext(JCas jCas, Sentence sent, EventMention event, String marker, int contextSize) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)event, (int)contextSize)) {
            if (sent.getBegin() > baseToken.getBegin()) continue;
            tokens.add(baseToken.getCoveredText());
        }
        tokens.add("<" + marker + ">");
        tokens.add(event.getCoveredText());
        tokens.add("</" + marker + ">");
        for (BaseToken baseToken : JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)event, (int)contextSize)) {
            if (baseToken.getEnd() > sent.getEnd()) continue;
            tokens.add(baseToken.getCoveredText());
        }
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    public static String getEventPosContext(JCas jCas, Sentence sent, EventMention event, String marker, int contextSize) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)event, (int)contextSize)) {
            if (sent.getBegin() > baseToken.getBegin()) continue;
            tokens.add(baseToken.getPartOfSpeech());
        }
        tokens.add("<" + marker + ">");
        for (BaseToken baseToken : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)event)) {
            tokens.add(baseToken.getPartOfSpeech());
        }
        tokens.add("</" + marker + ">");
        for (BaseToken baseToken : JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)event, (int)contextSize)) {
            if (baseToken.getEnd() > sent.getEnd()) continue;
            tokens.add(baseToken.getPartOfSpeech());
        }
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    public static class DocTimeRelSnippetPrinter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="OutputFile", mandatory=true, description="path to the output file")
        private String outputFile;

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (Sentence sentence : JCasUtil.select((JCas)systemView, Sentence.class)) {
                ArrayList<String> docTimeRelExamplesInSentence = new ArrayList<String>();
                for (EventMention event : JCasUtil.selectCovered((JCas)goldView, EventMention.class, (AnnotationFS)sentence)) {
                    if (event.getEvent() != null) {
                        String label = event.getEvent().getProperties().getDocTimeRel();
                        String context = DtrRelPrinter.getEventPosContext(systemView, sentence, event, "e", 10);
                        String text = String.format("%s|%s", label, context);
                        docTimeRelExamplesInSentence.add(text.toLowerCase());
                        continue;
                    }
                    System.out.println("event is null: " + event.getCoveredText() + " / " + sentence.getCoveredText());
                }
                try {
                    Files.write(Paths.get(this.outputFile, new String[0]), docTimeRelExamplesInSentence, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"})
        public File getInputDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"output-train"})
        public File getTrainOutputDirectory();

        @Option(longName={"output-test"})
        public File getTestOutputDirectory();
    }
}

