/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.BidirectionalIntObjectMap;
import cc.mallet.grmm.types.ConstantFactor;
import cc.mallet.grmm.types.DenseAssignmentIterator;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.SparseAssignmentIterator;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.Universe;
import cc.mallet.grmm.types.UnmodifiableVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.GeneralUtils;
import cc.mallet.types.Matrix;
import cc.mallet.types.Matrixn;
import cc.mallet.types.SparseMatrixn;
import cc.mallet.util.Maths;
import cc.mallet.util.Randoms;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractTableFactor
implements DiscreteFactor {
    private Universe universe = Universe.DEFAULT;
    private VarSet vars;
    private int numVars;
    private int[] reorderingMap;
    private int[] sizesAsPassed;
    private int[] sizesAsSorted;
    protected Matrix probs;
    private transient TIntObjectHashMap projectionCache;
    private static final double EPS = 1.0E-5;
    private static final long serialVersionUID = 1L;

    protected AbstractTableFactor(BidirectionalIntObjectMap varMap) {
        this.initVars(varMap);
        this.setAsIdentity();
    }

    private void initVars(BidirectionalIntObjectMap allVars) {
        this.initVars(Arrays.asList(allVars.toArray()));
    }

    private void initVars(Variable[] varsAsPassed) {
        this.sizesAsPassed = new int[varsAsPassed.length];
        this.sizesAsSorted = new int[varsAsPassed.length];
        this.reorderingMap = new int[varsAsPassed.length];
        Object[] allVars = (Variable[])varsAsPassed.clone();
        this.vars = new HashVarSet(Arrays.asList(allVars));
        Arrays.sort(allVars);
        for (int i = 0; i < allVars.length; ++i) {
            Variable var = this.vars.get(i);
            if (var.isContinuous()) {
                throw new IllegalArgumentException("Attempt to create table over continous variable " + allVars[i]);
            }
            this.sizesAsSorted[i] = var.getNumOutcomes();
            int j = 0;
            while (varsAsPassed[j] != var) {
                ++j;
            }
            this.reorderingMap[j] = i;
            this.sizesAsPassed[j] = this.vars.get(i).getNumOutcomes();
        }
        this.probs = new Matrixn(this.sizesAsSorted);
        if (this.probs.numLocations() == 0) {
            System.err.println("Warning: empty potential created");
        }
        this.numVars = allVars.length;
    }

    private void initVars(Collection allVars) {
        this.initVars(allVars.toArray(new Variable[allVars.size()]));
    }

    private void setProbs(double[] probArray) {
        if (probArray.length != this.probs.numLocations()) {
            throw new RuntimeException("Attempt to initialize potential with bad number of probabilities.\nNeeded " + this.probs.numLocations() + " got " + probArray.length);
        }
        for (int i = 0; i < probArray.length; ++i) {
            int[] indicesAsPassed = new int[this.sizesAsPassed.length];
            Matrixn.singleToIndices(i, indicesAsPassed, this.sizesAsPassed);
            int[] indicesAsSorted = new int[this.sizesAsPassed.length];
            for (int j = 0; j < this.sizesAsPassed.length; ++j) {
                indicesAsSorted[j] = indicesAsPassed[this.reorderingMap[j]];
            }
            int singleIndexAsSorted = Matrixn.singleIndex(this.sizesAsSorted, indicesAsSorted);
            this.probs.setValueAtLocation(singleIndexAsSorted, probArray[i]);
        }
    }

    public AbstractTableFactor(Variable var) {
        this.initVars(new Variable[]{var});
        this.setAsIdentity();
    }

    public AbstractTableFactor(Variable var, double[] values) {
        this.initVars(new Variable[]{var});
        this.setProbs(values);
    }

    public AbstractTableFactor() {
        this.initVars(new Variable[0]);
        this.setAsIdentity();
    }

    public AbstractTableFactor(Variable[] allVars) {
        this.initVars(allVars);
        this.setAsIdentity();
    }

    public AbstractTableFactor(Collection allVars) {
        this.initVars(allVars);
        this.setAsIdentity();
    }

    public AbstractTableFactor(Variable[] allVars, double[] probs) {
        this.initVars(allVars);
        this.setProbs(probs);
    }

    private AbstractTableFactor(BidirectionalIntObjectMap allVars, double[] probs) {
        this.initVars(allVars);
        this.setProbs(probs);
    }

    public AbstractTableFactor(VarSet allVars, double[] probs) {
        this.initVars(allVars.toVariableArray());
        this.setProbs(probs);
    }

    public AbstractTableFactor(Variable[] allVars, Matrix probsIn) {
        this.initVars(allVars);
        this.probs = (Matrix)probsIn.cloneMatrix();
    }

    private AbstractTableFactor(BidirectionalIntObjectMap allVars, Matrix probsIn) {
        this.initVars(allVars);
        this.probs = (Matrix)probsIn.cloneMatrix();
    }

    public AbstractTableFactor(AbstractTableFactor in) {
        this.vars = in.vars;
        this.numVars = in.numVars;
        if (in.projectionCache == null) {
            in.initializeProjectionCache();
        }
        this.projectionCache = in.projectionCache;
    }

    public AbstractTableFactor(VarSet allVars, Matrix probsIn) {
        this.initVars(allVars.toVariableArray());
        this.probs = (Matrix)probsIn.cloneMatrix();
    }

    public AbstractTableFactor(AbstractTableFactor ptl, double[] probs) {
        this(ptl.vars, probs);
    }

    public static Factor makeIdentityFactor(AbstractTableFactor copy) {
        return new TableFactor(copy.vars);
    }

    void setAll(double val) {
        for (int i = 0; i < this.probs.numLocations(); ++i) {
            this.probs.setSingleValue(i, val);
        }
    }

    abstract void setAsIdentity();

    @Override
    public abstract Factor duplicate();

    @Override
    public abstract Factor normalize();

    @Override
    public abstract double sum();

    protected abstract AbstractTableFactor createBlankSubset(Variable[] var1);

    private AbstractTableFactor createBlankSubset(Collection vars) {
        return this.createBlankSubset(vars.toArray(new Variable[vars.size()]));
    }

    protected int getNumVars() {
        return this.numVars;
    }

    public void setValues(Matrix probs) {
        if (this.probs.singleSize() != probs.singleSize()) {
            throw new UnsupportedOperationException("Trying to reset prob matrix with wrong number of probabilities.  Previous num probs: " + this.probs.singleSize() + "  New num probs: " + probs.singleSize());
        }
        if (this.probs.getNumDimensions() != probs.getNumDimensions()) {
            throw new UnsupportedOperationException("Trying to reset prob matrix with wrong number of dimensions.");
        }
        this.probs = probs;
    }

    @Override
    public boolean containsVar(Variable var) {
        return this.vars.contains(var);
    }

    @Override
    public VarSet varSet() {
        return new UnmodifiableVarSet(this.vars);
    }

    @Override
    public AssignmentIterator assignmentIterator() {
        int[] idxs;
        if (this.probs instanceof SparseMatrixn && (idxs = ((SparseMatrixn)this.probs).getIndices()) != null) {
            return new SparseAssignmentIterator(this.vars, idxs);
        }
        return new DenseAssignmentIterator(this.vars);
    }

    public void setRawValue(Assignment assn, double value) {
        int[] indices = new int[this.numVars];
        for (int i = 0; i < this.numVars; ++i) {
            Variable var = this.getVariable(i);
            indices[i] = assn.get(var);
        }
        this.probs.setValue(indices, value);
    }

    public void setRawValue(AssignmentIterator it, double value) {
        this.probs.setSingleValue(it.indexOfCurrentAssn(), value);
    }

    protected void setRawValue(int loc, double value) {
        this.probs.setSingleValue(loc, value);
    }

    @Override
    public abstract double value(Assignment var1);

    public double logsum() {
        return Math.log(this.probs.oneNorm());
    }

    @Override
    public double entropy() {
        double h = 0.0;
        AssignmentIterator it = this.assignmentIterator();
        while (it.hasNext()) {
            double p = this.logValue(it);
            if (!Double.isInfinite(p)) {
                h -= p * Math.exp(p);
            }
            it.advance();
        }
        return h;
    }

    private void initializeProjectionCache() {
        this.projectionCache = this.universe.lookupProjectionCache(this.varSet());
    }

    private int computeSubsetHashValue(DiscreteFactor subset) {
        assert (this.getNumVars() <= 32);
        int result = 0;
        double numVars = subset.varSet().size();
        int lrgi = 0;
        int smi = 0;
        while ((double)smi < numVars) {
            Variable var = subset.getVariable(smi);
            while (var != this.getVariable(lrgi)) {
                ++lrgi;
            }
            result |= 1 << lrgi;
            ++smi;
        }
        return result;
    }

    private int[] computeLargeIdxToSmall(DiscreteFactor smallPotential) {
        int[] projection = new int[this.probs.numLocations()];
        int[] largeDims = new int[this.numVars];
        int smallNumVars = smallPotential.varSet().size();
        int[] smallDims = new int[smallNumVars];
        for (int largeLoc = 0; largeLoc < this.probs.numLocations(); ++largeLoc) {
            int largeIdx = this.probs.indexAtLocation(largeLoc);
            this.probs.singleToIndices(largeIdx, largeDims);
            int largeDim = 0;
            for (int smallDim = 0; smallDim < smallNumVars; ++smallDim) {
                Variable smallVar = smallPotential.getVariable(smallDim);
                while (smallVar != this.getVariable(largeDim)) {
                    ++largeDim;
                }
                smallDims[smallDim] = largeDims[largeDim];
            }
            projection[largeLoc] = smallPotential.singleIndex(smallDims);
        }
        return projection;
    }

    int[] largeIdxToSmall(DiscreteFactor smallPotential) {
        if (this.projectionCache == null) {
            this.initializeProjectionCache();
        }
        return this.cachedLargeIdxToSmall(smallPotential);
    }

    private int[] cachedLargeIdxToSmall(DiscreteFactor smallPotential) {
        int hashval = this.computeSubsetHashValue(smallPotential);
        Object ints = this.projectionCache.get(hashval);
        if (ints != null) {
            return (int[])ints;
        }
        int[] projection = this.computeLargeIdxToSmall(smallPotential);
        this.projectionCache.put(hashval, (Object)projection);
        return projection;
    }

    @Override
    public Factor marginalize(Variable[] vars) {
        assert (this.varSet().containsAll(Arrays.asList(vars)));
        return this.marginalizeInternal(this.createBlankSubset(vars));
    }

    @Override
    public Factor marginalize(Collection vars) {
        assert (this.varSet().containsAll(vars));
        return this.marginalizeInternal(this.createBlankSubset(vars));
    }

    @Override
    public Factor marginalize(Variable var) {
        assert (this.varSet().contains(var));
        return this.marginalizeInternal(this.createBlankSubset(new Variable[]{var}));
    }

    @Override
    public Factor marginalizeOut(Variable var) {
        HashVarSet newVars = new HashVarSet(this.vars);
        newVars.remove(var);
        return this.marginalizeInternal(this.createBlankSubset(newVars));
    }

    @Override
    public Factor marginalizeOut(VarSet badVars) {
        HashVarSet newVars = new HashVarSet(this.vars);
        newVars.remove(badVars);
        return this.marginalizeInternal(this.createBlankSubset(newVars));
    }

    protected abstract Factor marginalizeInternal(AbstractTableFactor var1);

    @Override
    public Factor extractMax(Variable var) {
        return this.extractMaxInternal(this.createBlankSubset(new Variable[]{var}));
    }

    @Override
    public Factor extractMax(Variable[] vars) {
        return this.extractMaxInternal(this.createBlankSubset(vars));
    }

    @Override
    public Factor extractMax(Collection vars) {
        return this.extractMaxInternal(this.createBlankSubset(vars));
    }

    private Factor extractMaxInternal(AbstractTableFactor result) {
        result.setAll(Double.NEGATIVE_INFINITY);
        int[] projection = this.largeIdxToSmall(result);
        for (int largeLoc = 0; largeLoc < this.probs.numLocations(); ++largeLoc) {
            double smallValue;
            int smallIdx = projection[largeLoc];
            double largeValue = this.probs.valueAtLocation(largeLoc);
            if (!(largeValue > (smallValue = result.probs.singleValue(smallIdx)))) continue;
            result.probs.setValueAtLocation(smallIdx, largeValue);
        }
        return result;
    }

    private void expandToContain(DiscreteFactor pot) {
        if (this.needsToExpand(this.varSet(), pot.varSet())) {
            HashVarSet newVarSet = new HashVarSet(this.varSet());
            newVarSet.addAll(pot.varSet());
            AbstractTableFactor newPtl = this.createBlankSubset(newVarSet);
            newPtl.multiplyByInternal(this);
            this.vars = newPtl.vars;
            this.probs = newPtl.probs;
            this.numVars = newPtl.numVars;
            this.initializeProjectionCache();
        }
    }

    private boolean needsToExpand(VarSet mine, VarSet his) {
        int size_h = his.size();
        int vi_h = 0;
        for (int vi_m = 0; vi_m < this.numVars && vi_h < size_h; ++vi_m) {
            Variable var_m = mine.get(vi_m);
            Variable var_h = his.get(vi_h);
            if (var_m != var_h) continue;
            ++vi_h;
        }
        return vi_h < size_h;
    }

    @Override
    public void multiplyBy(Factor pot) {
        if (pot instanceof DiscreteFactor) {
            DiscreteFactor factor = (DiscreteFactor)pot;
            this.expandToContain(factor);
            factor = this.ensureOperandCompatible(factor);
            this.multiplyByInternal(factor);
        } else if (pot instanceof ConstantFactor) {
            this.timesEquals(pot.value(new Assignment()));
        } else {
            AbstractTableFactor tbl;
            try {
                tbl = pot.asTable();
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException("Don't know how to multiply " + this + " by " + pot);
            }
            this.multiplyBy(tbl);
        }
    }

    protected DiscreteFactor ensureOperandCompatible(DiscreteFactor ptl) {
        return ptl;
    }

    protected abstract void multiplyByInternal(DiscreteFactor var1);

    protected abstract void plusEqualsInternal(DiscreteFactor var1);

    @Override
    public Factor multiply(Factor dist) {
        Factor result = this.duplicate();
        result.multiplyBy(dist);
        return result;
    }

    @Override
    public void divideBy(Factor pot) {
        if (pot instanceof DiscreteFactor) {
            DiscreteFactor pot1 = (DiscreteFactor)pot;
            this.expandToContain(pot1);
            pot1 = this.ensureOperandCompatible(pot1);
            this.divideByInternal(pot1);
        } else if (pot instanceof ConstantFactor) {
            this.timesEquals(1.0 / pot.value(new Assignment()));
        } else {
            AbstractTableFactor tbl;
            try {
                tbl = pot.asTable();
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException("Don't know how to multiply " + this + " by " + pot);
            }
            this.multiplyBy(tbl);
        }
    }

    protected abstract void divideByInternal(DiscreteFactor var1);

    @Override
    public int argmax() {
        int bestIdx = 0;
        double bestVal = this.probs.singleValue(0);
        for (int idx = 1; idx < this.probs.numLocations(); ++idx) {
            double val = this.probs.singleValue(idx);
            if (!(val > bestVal)) continue;
            bestVal = val;
            bestIdx = idx;
        }
        return bestIdx;
    }

    @Override
    public Assignment sample(Randoms r) {
        int loc = this.sampleLocation(r);
        return this.location2assignment(loc);
    }

    private Assignment location2assignment(int loc) {
        return new DenseAssignmentIterator(this.vars, loc).assignment();
    }

    @Override
    public int sampleLocation(Randoms r) {
        double sum = this.sum();
        double sampled = r.nextUniform() * sum;
        double cum = 0.0;
        for (int idx = 0; idx < this.probs.numLocations(); ++idx) {
            double val = this.value(idx);
            if (!(sampled <= (cum += val) + 1.0E-5)) continue;
            return idx;
        }
        throw new RuntimeException("Internal errors: Couldn't sample from potential " + this + "\n" + this.dumpToString() + "\n Using value " + sampled);
    }

    @Override
    public boolean almostEquals(Factor p) {
        return this.almostEquals(p, Maths.EPSILON);
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        if (!(p instanceof AbstractTableFactor)) {
            return false;
        }
        DiscreteFactor p2 = (DiscreteFactor)p;
        if (!this.varSet().containsAll(p2.varSet())) {
            return false;
        }
        if (!p2.varSet().containsAll(this.varSet())) {
            return false;
        }
        int[] projection = this.largeIdxToSmall(p2);
        for (int loc1 = 0; loc1 < this.probs.numLocations(); ++loc1) {
            double v2;
            int idx2 = projection[loc1];
            double v1 = this.valueAtLocation(loc1);
            if (!(Math.abs(v1 - (v2 = p2.value(idx2))) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return this.duplicate();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(1024);
        s.append("[");
        s.append(GeneralUtils.classShortName(this));
        s.append(" : ");
        s.append(this.varSet());
        s.append("]");
        return s.toString();
    }

    @Override
    public String dumpToString() {
        StringBuffer s = new StringBuffer(1024);
        s.append(this.toString());
        s.append("\n");
        int[] indices = new int[this.numVars];
        for (int loc = 0; loc < this.probs.numLocations(); ++loc) {
            int idx = this.probs.indexAtLocation(loc);
            this.probs.singleToIndices(idx, indices);
            for (int j = 0; j < this.numVars; ++j) {
                s.append(indices[j]);
                s.append("  ");
            }
            double val = this.probs.singleValue(idx);
            s.append(val);
            s.append("\n");
        }
        s.append(" Sum = ").append(this.sum()).append("\n");
        return s.toString();
    }

    @Override
    public boolean isNaN() {
        return this.probs.isNaN();
    }

    public void printValues() {
        System.out.print("[");
        for (int i = 0; i < this.probs.numLocations(); ++i) {
            System.out.print(this.probs.valueAtLocation(i));
            System.out.print(", ");
        }
        System.out.print("]");
    }

    public void printSizes() {
        int[] sizes = new int[this.numVars];
        this.probs.getDimensions(sizes);
        System.out.print("[");
        for (int i = 0; i < this.numVars; ++i) {
            System.out.print(sizes[i] + ", ");
        }
        System.out.print("]");
    }

    public Variable findVariable(String name) {
        for (int i = 0; i < this.getNumVars(); ++i) {
            Variable var = this.getVariable(i);
            if (!var.getLabel().equals(name)) continue;
            return var;
        }
        return null;
    }

    @Override
    public int numLocations() {
        return this.probs.numLocations();
    }

    @Override
    public int indexAtLocation(int loc) {
        return this.probs.indexAtLocation(loc);
    }

    @Override
    public Variable getVariable(int i) {
        return this.vars.get(i);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.projectionCache = new TIntObjectHashMap();
    }

    public void divideBy(double v) {
        this.probs.divideEquals(v);
    }

    public abstract void setLogValue(Assignment var1, double var2);

    public abstract void setLogValue(AssignmentIterator var1, double var2);

    public abstract void setValue(AssignmentIterator var1, double var2);

    static Factor hackyMixture(AbstractTableFactor ptl1, AbstractTableFactor ptl2, double weight) {
        if (ptl1.getNumVars() != ptl2.getNumVars()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < ptl2.getNumVars(); ++i) {
            if (ptl1.getVariable(i) == ptl2.getVariable(i)) continue;
            throw new IllegalArgumentException();
        }
        if (ptl1.ensureOperandCompatible(ptl2) != ptl2) {
            throw new IllegalArgumentException();
        }
        TableFactor result = new TableFactor(ptl1.vars);
        for (int loc1 = 0; loc1 < ptl1.numLocations(); ++loc1) {
            double val1 = ptl1.valueAtLocation(loc1);
            int idx = ptl1.indexAtLocation(loc1);
            double val2 = ptl2.value(idx);
            result.setRawValue(idx, weight * val1 + (1.0 - weight) * val2);
        }
        if (!ptl1.isNaN() && !ptl2.isNaN() && result.isNaN()) {
            System.err.println("Oops! NaN in averaging.\n   P1" + ptl1.isNaN() + "\n  P2:" + ptl2.isNaN() + "\n  Result:" + result.isNaN());
        }
        return result;
    }

    protected abstract double rawValue(int var1);

    @Override
    public double[] toValueArray() {
        Matrix matrix = this.getValueMatrix();
        double[] arr = new double[matrix.numLocations()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = matrix.valueAtLocation(i);
        }
        return arr;
    }

    @Override
    public int singleIndex(int[] smallDims) {
        return this.probs.singleIndex(smallDims);
    }

    public abstract Matrix getValueMatrix();

    public abstract Matrix getLogValueMatrix();

    public abstract void setLogValues(double[] var1);

    public abstract void setValues(double[] var1);

    public double[] toLogValueArray() {
        Matrix matrix = this.getLogValueMatrix();
        if (matrix instanceof Matrixn) {
            return ((Matrixn)matrix).toArray();
        }
        if (matrix instanceof SparseMatrixn) {
            return ((SparseMatrixn)matrix).toArray();
        }
        throw new RuntimeException();
    }

    public double[] getValues() {
        return ((Matrixn)this.getValueMatrix()).toArray();
    }

    public void plusEquals(double v) {
        for (int loc = 0; loc < this.numLocations(); ++loc) {
            this.plusEqualsAtLocation(loc, v);
        }
    }

    public void plusEquals(Factor f) {
        if (f instanceof DiscreteFactor) {
            DiscreteFactor factor = (DiscreteFactor)f;
            this.expandToContain(factor);
            factor = this.ensureOperandCompatible(factor);
            this.plusEqualsInternal(factor);
        } else if (f instanceof ConstantFactor) {
            this.plusEquals(f.value(new Assignment()));
        } else {
            AbstractTableFactor tbl;
            try {
                tbl = f.asTable();
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException("Don't know how to add " + this + " by " + f);
            }
            this.plusEquals(tbl);
        }
    }

    public abstract void timesEquals(double var1);

    protected abstract void plusEqualsAtLocation(int var1, double var2);

    public abstract AbstractTableFactor recenter();

    @Override
    public AbstractTableFactor asTable() {
        return this;
    }

    @Override
    public Factor slice(Assignment assn) {
        VarSet intersection = this.varSet().intersection(assn.varSet());
        if (intersection.isEmpty()) {
            return this;
        }
        HashVarSet clique = new HashVarSet(this.varSet());
        clique.removeAll(Arrays.asList(assn.getVars()));
        return this.sliceInternal(clique.toVariableArray(), assn);
    }

    private Factor sliceInternal(Variable[] vars, Assignment observed) {
        if (vars.length == 1) {
            return this.slice_onevar(vars[0], observed);
        }
        if (vars.length == 2) {
            return this.slice_twovar(vars[0], vars[1], observed);
        }
        return this.slice_general(vars, observed);
    }

    protected abstract Factor slice_onevar(Variable var1, Assignment var2);

    protected abstract Factor slice_twovar(Variable var1, Variable var2, Assignment var3);

    protected abstract Factor slice_general(Variable[] var1, Assignment var2);

    @Override
    public String prettyOutputString() {
        StringBuffer buf = new StringBuffer();
        for (Variable var : this.vars) {
            buf.append(var.getLabel());
            buf.append(" ");
        }
        buf.append("~ AbstractTableFactor\n");
        return buf.toString();
    }
}

