/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.lemmatizer.Lemmatizer;

public class DictionaryLemmatizer
implements Lemmatizer {
    private final Map<List<String>, String> dictMap = new HashMap<List<String>, String>();

    public DictionaryLemmatizer(InputStream dictionary) {
        BufferedReader breader = new BufferedReader(new InputStreamReader(dictionary));
        try {
            String line;
            while ((line = breader.readLine()) != null) {
                String[] elems = line.split("\t");
                this.dictMap.put(Arrays.asList(elems[0], elems[1]), elems[2]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<List<String>, String> getDictMap() {
        return this.dictMap;
    }

    private List<String> getDictKeys(String word, String postag) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(Arrays.asList(word.toLowerCase(), postag));
        return keys;
    }

    @Override
    public String[] lemmatize(String[] tokens, String[] postags) {
        ArrayList<String> lemmas = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            lemmas.add(this.apply(tokens[i], postags[i]));
        }
        return lemmas.toArray(new String[lemmas.size()]);
    }

    public String apply(String word, String postag) {
        List<String> keys = this.getDictKeys(word, postag);
        String keyValue = this.dictMap.get(keys);
        String lemma = keyValue != null ? keyValue : "O";
        return lemma;
    }
}

