/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElementDir;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElementZip;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;

abstract class ClasspathElement {
    final File classpathElementFile;
    private final String classpathElementFilePath;
    final URL classpathElementURL;
    boolean ioExceptionOnOpen;
    List<ClasspathRelativePath> childClasspathElts;
    final ScanSpec scanSpec;
    private final boolean scanFiles;
    protected InterruptionChecker interruptionChecker;
    protected MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource> fileMatches;
    protected List<ClasspathResource> classfileMatches;
    protected Map<File, Long> fileToLastModified;

    ClasspathElement(ClasspathRelativePath classpathEltPath, ScanSpec scanSpec, boolean scanFiles, InterruptionChecker interruptionChecker, LogNode log) {
        this.scanSpec = scanSpec;
        this.scanFiles = scanFiles;
        this.interruptionChecker = interruptionChecker;
        try {
            this.classpathElementFile = classpathEltPath.getFile();
            this.classpathElementFilePath = classpathEltPath.toString();
            try {
                this.classpathElementURL = this.classpathElementFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.classpathElementFilePath;
    }

    static ClasspathElement newInstance(ClasspathRelativePath classpathRelativePath, boolean scanFiles, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, WorkQueue<ClasspathRelativePath> workQueue, InterruptionChecker interruptionChecker, LogNode log) {
        ClasspathElement newInstance;
        String canonicalPath;
        boolean isDir;
        File file;
        try {
            file = classpathRelativePath.getFile();
            isDir = classpathRelativePath.isDirectory();
            canonicalPath = classpathRelativePath.getCanonicalPath();
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathRelativePath.getResolvedPath(), e);
            }
            return null;
        }
        LogNode logNode = log == null ? null : log.log(canonicalPath, "Scanning " + (isDir ? "directory " : "jarfile ") + classpathRelativePath + (file.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        ClasspathElement classpathElement = newInstance = isDir ? new ClasspathElementDir(classpathRelativePath, scanSpec, scanFiles, interruptionChecker, logNode) : new ClasspathElementZip(classpathRelativePath, scanSpec, scanFiles, nestedJarHandler, workQueue, interruptionChecker, logNode);
        if (logNode != null) {
            logNode.addElapsedTime();
        }
        return newInstance;
    }

    public int getNumClassfileMatches() {
        return this.classfileMatches == null ? 0 : this.classfileMatches.size();
    }

    void maskFiles(int classpathIdx, HashSet<String> classpathRelativePathsFound, LogNode log) {
        if (!this.scanFiles) {
            throw new IllegalArgumentException("scanFiles is false");
        }
        HashSet<String> allMatchingRelativePathsForThisClasspathElement = new HashSet<String>();
        for (ClasspathResource classpathResource : this.classfileMatches) {
            allMatchingRelativePathsForThisClasspathElement.add(classpathResource.relativePath);
        }
        for (Map.Entry entry : this.fileMatches.entrySet()) {
            for (ClasspathResource classpathResource : (List)entry.getValue()) {
                allMatchingRelativePathsForThisClasspathElement.add(classpathResource.relativePath);
            }
        }
        HashSet<String> maskedRelativePaths = new HashSet<String>();
        for (String string : allMatchingRelativePathsForThisClasspathElement) {
            if (!classpathRelativePathsFound.contains(string)) continue;
            maskedRelativePaths.add(string);
        }
        if (!maskedRelativePaths.isEmpty()) {
            ArrayList<ClasspathResource> arrayList = new ArrayList<ClasspathResource>();
            for (ClasspathResource classfileMatch : this.classfileMatches) {
                if (!maskedRelativePaths.contains(classfileMatch.relativePath)) {
                    arrayList.add(classfileMatch);
                    continue;
                }
                if (log == null) continue;
                log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + classfileMatch.relativePath.replace('/', '.') + " in classpath element " + classfileMatch.classpathEltFile);
            }
            this.classfileMatches = arrayList;
            MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource> multiMapKeyToList = new MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource>();
            for (Map.Entry<ScanSpec.FileMatchProcessorWrapper, List<ClasspathResource>> ent : this.fileMatches.entrySet()) {
                for (ClasspathResource fileMatch : ent.getValue()) {
                    if (!maskedRelativePaths.contains(fileMatch.relativePath)) {
                        multiMapKeyToList.put(ent.getKey(), fileMatch);
                        continue;
                    }
                    if (log == null) continue;
                    log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) file path " + fileMatch.relativePath + " in classpath element " + fileMatch.classpathEltFile);
                }
            }
            this.fileMatches = multiMapKeyToList;
        }
        classpathRelativePathsFound.addAll(allMatchingRelativePathsForThisClasspathElement);
    }

    void callFileMatchProcessors(ScanResult scanResult, LogNode log) throws InterruptedException, ExecutionException {
        for (Map.Entry<ScanSpec.FileMatchProcessorWrapper, List<ClasspathResource>> ent : this.fileMatches.entrySet()) {
            ScanSpec.FileMatchProcessorWrapper fileMatchProcessorWrapper = ent.getKey();
            for (ClasspathResource fileMatch : ent.getValue()) {
                try {
                    LogNode logNode = log == null ? null : log.log("Calling MatchProcessor for matching file " + fileMatch);
                    this.openInputStreamAndProcessFileMatch(fileMatch, fileMatchProcessorWrapper);
                    if (logNode != null) {
                        logNode.addElapsedTime();
                    }
                }
                catch (IOException e) {
                    if (log != null) {
                        log.log("Exception while opening file " + fileMatch.classpathEltFile + (fileMatch.classpathEltFile.isFile() ? "!" : "/") + fileMatch.relativePath, e);
                    }
                }
                catch (Throwable e) {
                    if (log != null) {
                        log.log("Exception while calling FileMatchProcessor for file " + fileMatch.classpathEltFile + (fileMatch.classpathEltFile.isFile() ? "!" : "/") + fileMatch.relativePath, e);
                    }
                    scanResult.addMatchProcessorException(e);
                }
                this.interruptionChecker.check();
            }
        }
    }

    protected abstract void openInputStreamAndProcessFileMatch(ClasspathResource var1, ScanSpec.FileMatchProcessorWrapper var2) throws IOException;

    void parseClassfiles(ClassfileBinaryParser classfileBinaryParser, int classfileStartIdx, int classfileEndIdx, ConcurrentHashMap<String, String> stringInternMap, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinked, LogNode log) throws Exception {
        for (int i = classfileStartIdx; i < classfileEndIdx; ++i) {
            ClasspathResource classfileResource = this.classfileMatches.get(i);
            try {
                LogNode logNode = log == null ? null : log.log("Parsing classfile " + classfileResource);
                this.openInputStreamAndParseClassfile(classfileResource, classfileBinaryParser, this.scanSpec, stringInternMap, classInfoUnlinked, logNode);
                if (logNode != null) {
                    logNode.addElapsedTime();
                }
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("IOException while attempting to read classfile " + classfileResource + " -- skipping", e);
                }
            }
            catch (Exception e) {
                if (log != null) {
                    log.log("Exception while parsing classfile " + classfileResource, e);
                }
                throw e;
            }
            this.interruptionChecker.check();
        }
    }

    protected abstract void openInputStreamAndParseClassfile(ClasspathResource var1, ClassfileBinaryParser var2, ScanSpec var3, ConcurrentHashMap<String, String> var4, ConcurrentLinkedQueue<ClassInfoUnlinked> var5, LogNode var6) throws IOException, InterruptedException;

    public abstract void close();

    static class ClasspathResource {
        final File classpathEltFile;
        final String relativePath;

        private ClasspathResource(File classpathEltFile, String relativePath) {
            this.classpathEltFile = classpathEltFile;
            this.relativePath = relativePath;
        }

        static class ClasspathResourceInZipFile
        extends ClasspathResource {
            final ZipEntry zipEntry;
            final String pathRelativeToClasspathPrefix;

            ClasspathResourceInZipFile(File classpathEltFile, String classpathPrefix, String relativePath, ZipEntry zipEntry) {
                super(classpathEltFile, classpathPrefix + relativePath);
                this.zipEntry = zipEntry;
                this.pathRelativeToClasspathPrefix = relativePath;
            }

            public String toString() {
                return ClasspathUtils.getClasspathResourceURL(this.classpathEltFile, this.relativePath).toString();
            }
        }

        static class ClasspathResourceInDir
        extends ClasspathResource {
            final File relativePathFile;

            ClasspathResourceInDir(File classpathEltFile, String relativePath, File relativePathFile) {
                super(classpathEltFile, relativePath);
                this.relativePathFile = relativePathFile;
            }

            public String toString() {
                return ClasspathUtils.getClasspathResourceURL(this.classpathEltFile, this.relativePath).toString();
            }
        }
    }
}

