/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.JTableHeader;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.pipeline.PiperFileReader;
import org.apache.ctakes.gui.component.DisablerPane;
import org.apache.ctakes.gui.component.LoggerPanel;
import org.apache.ctakes.gui.component.PositionedSplitPane;
import org.apache.ctakes.gui.component.SmoothTipList;
import org.apache.ctakes.gui.component.TextLineNumber;
import org.apache.ctakes.gui.pipeline.bit.PipeBitFinder;
import org.apache.ctakes.gui.pipeline.bit.available.AvailablesListModel;
import org.apache.ctakes.gui.pipeline.bit.info.PipeBitInfoPanel;
import org.apache.ctakes.gui.pipeline.bit.info.PipeBitInfoRenderer;
import org.apache.ctakes.gui.pipeline.bit.info.RoleRenderer;
import org.apache.ctakes.gui.pipeline.bit.info.TypeProductListModel;
import org.apache.ctakes.gui.pipeline.bit.info.TypeProductRenderer;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterHolder;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterTableModel;
import org.apache.ctakes.gui.pipeline.piper.PiperTextFilter;
import org.apache.ctakes.gui.util.IconLoader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

final class MainPanel2
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger((String)"MainPanel");
    private final JFileChooser _chooser = new JFileChooser();
    private final AvailablesListModel _availablesListModel = new AvailablesListModel();
    private JList<PipeBitInfo> _availablesList;
    private PipeBitInfoPanel _infoPanel;
    private DefaultStyledDocument _piperDocument;
    private PiperTextFilter _piperTextFilter;
    private JButton _newButton;
    private JButton _openButton;
    private JButton _saveButton;
    private JButton _validateButton;
    private JButton _runButton;
    private JButton _helpButton;
    private JTextPane _textPane;
    private JButton _addButton;
    private JButton _setButton;
    private JButton _loadButton;
    private JButton _packageButton;
    private static final Function<String, String> maybeQuote = t -> t.contains(" ") ? "\"" + t + "\"" : t;

    MainPanel2() {
        super(new BorderLayout());
        PositionedSplitPane logSplit = new PositionedSplitPane(0);
        logSplit.setTopComponent(this.createMainPanel());
        logSplit.setBottomComponent(LoggerPanel.createLoggerPanel(new Level[0]));
        ((JSplitPane)logSplit).setDividerLocation(0.6);
        this.add((Component)this.createToolBar(), "North");
        this.add((Component)logSplit, "Center");
        SwingUtilities.invokeLater(new ButtonIconLoader());
        this._chooser.setFileFilter(new FileNameExtensionFilter("Pipeline Definition (Piper) File", "piper"));
        this._chooser.setFileView(new PiperFileView());
        this.createNewPiper();
    }

    private JComponent createWestPanel() {
        JTable fakeTable = new JTable();
        JTableHeader fakeHeader = fakeTable.getTableHeader();
        Component header = fakeHeader.getDefaultRenderer().getTableCellRendererComponent(null, "Available Pipe Bits", false, false, -1, -1);
        ((JLabel)header).setHorizontalAlignment(0);
        this._availablesList = MainPanel2.createPipeBitList(this._availablesListModel);
        JScrollPane scroll = new JScrollPane(this._availablesList);
        scroll.setColumnHeaderView(header);
        scroll.setMinimumSize(new Dimension(100, 10));
        JList<PipeBitInfo> rowHeaders = new JList<PipeBitInfo>(this._availablesListModel);
        rowHeaders.setFixedCellHeight(20);
        rowHeaders.setCellRenderer(new RoleRenderer());
        scroll.setRowHeaderView(rowHeaders);
        scroll.setHorizontalScrollBarPolicy(31);
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(scroll);
        split.setRightComponent(this.createInfoPlusPanel());
        split.setResizeWeight(0.5);
        split.setDividerLocation(0.4);
        return split;
    }

    private JComponent createInfoPlusPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this._infoPanel = MainPanel2.createBitInfoPanel(this._availablesList);
        panel.add((Component)this._infoPanel, "Center");
        panel.add((Component)this.createAddButtonPanel(), "East");
        return panel;
    }

    private JComponent createEastPanel() {
        this._piperDocument = new DefaultStyledDocument();
        this._piperTextFilter = new PiperTextFilter(this._piperDocument);
        this._textPane = new JTextPane(this._piperDocument);
        this._textPane.putClientProperty("caretWidth", 2);
        this._textPane.setCaretColor(Color.MAGENTA);
        JScrollPane scroll = new JScrollPane(this._textPane);
        TextLineNumber lineNumber = new TextLineNumber(this._textPane, 2);
        scroll.setRowHeaderView(lineNumber);
        scroll.setMinimumSize(new Dimension(100, 10));
        return scroll;
    }

    private JComponent createMainPanel() {
        JComponent westPanel = this.createWestPanel();
        JComponent eastPanel = this.createEastPanel();
        JSplitPane mainSplit = new JSplitPane(1, westPanel, eastPanel);
        mainSplit.setDividerLocation(0.6);
        return mainSplit;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this._newButton = MainPanel2.addButton(toolBar, "Create New Piper File");
        this._newButton.addActionListener(new NewPiperAction());
        this._openButton = MainPanel2.addButton(toolBar, "Open Existing Piper File");
        this._openButton.addActionListener(new OpenPiperAction());
        this._saveButton = MainPanel2.addButton(toolBar, "Save Current Piper File");
        this._saveButton.addActionListener(new SavePiperAction());
        toolBar.addSeparator(new Dimension(20, 0));
        this._helpButton = MainPanel2.addButton(toolBar, "Help");
        this._helpButton.addActionListener(new HelpAction());
        toolBar.add(Box.createHorizontalGlue());
        this._validateButton = MainPanel2.addButton(toolBar, "Validate Current Piper File");
        this._validateButton.addActionListener(new ValidateAction());
        this._runButton = MainPanel2.addButton(toolBar, "Run Current Piper File");
        this._runButton.addActionListener(new RunAction());
        this._runButton.setEnabled(false);
        toolBar.addSeparator(new Dimension(10, 0));
        return toolBar;
    }

    private static JButton addButton(JToolBar toolBar, String toolTip) {
        toolBar.addSeparator(new Dimension(10, 0));
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setToolTipText(toolTip);
        toolBar.add(button);
        return button;
    }

    private static JButton addVerticalButton(JToolBar toolBar, String toolTip) {
        toolBar.addSeparator(new Dimension(0, 10));
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setToolTipText(toolTip);
        toolBar.add(button);
        return button;
    }

    private static JList<PipeBitInfo> createPipeBitList(ListModel<PipeBitInfo> model) {
        SmoothTipList<PipeBitInfo> bitList = new SmoothTipList<PipeBitInfo>(model);
        bitList.setCellRenderer(new PipeBitInfoRenderer());
        bitList.setFixedCellHeight(20);
        return bitList;
    }

    private static PipeBitInfoPanel createBitInfoPanel(JList<PipeBitInfo> list) {
        PipeBitInfoPanel pipeBitInfoPanel = new PipeBitInfoPanel();
        pipeBitInfoPanel.setPipeBitInfoList(list);
        pipeBitInfoPanel.setBorder(UIManager.getBorder("ScrollPane.border"));
        return pipeBitInfoPanel;
    }

    void findPipeBits() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new PiperBitParser());
        executor.shutdown();
    }

    private JComponent createAddButtonPanel() {
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.addSeparator(new Dimension(0, 30));
        AddAction addAction = new AddAction();
        ParameterTableModel parameterModel = this._infoPanel.getParameterModel();
        parameterModel.addTableModelListener(addAction);
        this._addButton = MainPanel2.addVerticalButton(toolBar, "Add selected Pipe Bit");
        this._addButton.addActionListener(addAction);
        this._addButton.setEnabled(false);
        toolBar.addSeparator(new Dimension(0, 60));
        this._setButton = MainPanel2.addVerticalButton(toolBar, "Set Global Parameter");
        this._setButton.addActionListener(new SetAction());
        toolBar.add(Box.createVerticalGlue());
        this._loadButton = MainPanel2.addVerticalButton(toolBar, "Load SubPiper");
        this._loadButton.addActionListener(new LoadAction());
        this._packageButton = MainPanel2.addVerticalButton(toolBar, "Add Package");
        this._packageButton.addActionListener(new PackageAction());
        SwingUtilities.invokeLater(new CommandIconLoader());
        return toolBar;
    }

    private void createNewPiper() {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MMMM dd, yyyy");
        LocalDate date = LocalDate.now();
        String text = "//       ***  Piper File  ***\n//       Created by " + System.getProperty("user.name") + "\n" + "//       on " + date.format(dateFormatter) + "\n\n";
        try {
            this._piperDocument.remove(0, this._piperDocument.getLength());
            this._piperDocument.insertString(0, text, null);
            this._textPane.setCaretPosition(this._piperDocument.getLength());
        }
        catch (BadLocationException blE) {
            LOGGER.warn((Object)blE.getMessage());
        }
        this._runButton.setEnabled(false);
    }

    private int getInsertCaret() throws BadLocationException {
        int caret = this._textPane.getCaretPosition();
        if (caret > 1 && this._piperDocument.getText(caret - 1, 1).charAt(0) == '\n') {
            return caret;
        }
        int length = this._piperDocument.getLength() - caret;
        String docText = this._piperDocument.getText(caret, length);
        boolean careted = false;
        for (int i = 0; i < length - 1; ++i) {
            if (docText.charAt(i) != '\n') continue;
            caret += i + 1;
            careted = true;
            break;
        }
        if (!careted) {
            caret = this._piperDocument.getLength();
        }
        return caret;
    }

    private final class AddAction
    implements ActionListener,
    TableModelListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String bitName = MainPanel2.this._infoPanel.getBitName();
            if (bitName == null || bitName.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            String description = MainPanel2.this._infoPanel.getDescription().trim();
            if (!description.isEmpty()) {
                sb.append("//  ").append(MainPanel2.this._infoPanel.getBitName()).append("\n");
                sb.append("//  ").append(description).append("\n");
            }
            StringBuilder helpSb = new StringBuilder();
            StringBuilder parmSb = new StringBuilder();
            ParameterTableModel parameterModel = MainPanel2.this._infoPanel.getParameterModel();
            ParameterHolder holder = parameterModel.getParameterHolder();
            int count = holder.getParameterCount();
            List<String[]> values = parameterModel.getValues();
            for (int i = 0; i < count; ++i) {
                Object[] value = values.get(i);
                if (value == null || value.length <= 0 || Arrays.equals(value, holder.getParameter(i).defaultValue())) continue;
                helpSb.append("#   ").append(holder.getParameterName(i)).append("  ").append(holder.getParameterDescription(i)).append("\n");
                String valueText = Arrays.stream(value).map(maybeQuote).collect(Collectors.joining(","));
                parmSb.append(" ").append(holder.getParameterName(i)).append("=").append(valueText);
            }
            sb.append(helpSb.toString());
            PipeBitInfo info = MainPanel2.this._infoPanel.getPipeBitInfo();
            if (info.role() == PipeBitInfo.Role.READER) {
                sb.append("reader ");
            } else {
                sb.append("add ");
            }
            sb.append(MainPanel2.this._infoPanel.getPipeBitClass().getName());
            sb.append(parmSb.toString()).append("\n");
            try {
                int caret = MainPanel2.this.getInsertCaret();
                MainPanel2.this._piperDocument.insertString(caret, sb.toString(), null);
            }
            catch (BadLocationException blE) {
                LOGGER.error((Object)blE.getMessage());
            }
            MainPanel2.this._runButton.setEnabled(false);
        }

        @Override
        public void tableChanged(TableModelEvent event) {
            ParameterTableModel parameterModel = MainPanel2.this._infoPanel.getParameterModel();
            ParameterHolder holder = parameterModel.getParameterHolder();
            int count = holder.getParameterCount();
            if (count > 0) {
                List<String[]> values = parameterModel.getValues();
                for (int i = 0; i < count; ++i) {
                    String[] value = values.get(i);
                    if (!holder.isParameterMandatory(i) || value != null && value.length != 0 && !value[0].trim().isEmpty() && !value[0].equals("org.apache.uima.fit.descriptor.ConfigurationParameter.NO_DEFAULT_VALUE")) continue;
                    MainPanel2.this._addButton.setEnabled(false);
                    return;
                }
            }
            MainPanel2.this._addButton.setEnabled(true);
        }
    }

    private final class PackageAction
    implements ActionListener {
        private PackageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int caret = MainPanel2.this.getInsertCaret();
                MainPanel2.this._piperDocument.insertString(caret, "\n// Add a Package that contains Pipe Bits or Piper files\npackage ", null);
            }
            catch (BadLocationException blE) {
                LOGGER.error((Object)blE.getMessage());
            }
            MainPanel2.this._runButton.setEnabled(false);
        }
    }

    private final class LoadAction
    implements ActionListener {
        private LoadAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int caret = MainPanel2.this.getInsertCaret();
                MainPanel2.this._piperDocument.insertString(caret, "\n// Load a Piper file containing a partial Pipeline\nload ", null);
            }
            catch (BadLocationException blE) {
                LOGGER.error((Object)blE.getMessage());
            }
            MainPanel2.this._runButton.setEnabled(false);
        }
    }

    private final class SetAction
    implements ActionListener {
        private SetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int caret = MainPanel2.this.getInsertCaret();
                MainPanel2.this._piperDocument.insertString(caret, "\n// Set a global value\nset ", null);
            }
            catch (BadLocationException blE) {
                LOGGER.error((Object)blE.getMessage());
            }
            MainPanel2.this._runButton.setEnabled(false);
        }
    }

    private final class CommandIconLoader
    implements Runnable {
        private CommandIconLoader() {
        }

        @Override
        public void run() {
            String dir = "org/apache/ctakes/gui/pipeline/icon/";
            String addPng = "PlusMark.png";
            String setPng = "Parameters.png";
            String loadPng = "BlueGearYellowGear.png";
            String packagePng = "Folder_Blue.png";
            Icon addIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/PlusMark.png");
            Icon setIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/Parameters.png");
            Icon loadIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/BlueGearYellowGear.png");
            Icon packageIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/Folder_Blue.png");
            MainPanel2.this._addButton.setIcon(addIcon);
            MainPanel2.this._setButton.setIcon(setIcon);
            MainPanel2.this._loadButton.setIcon(loadIcon);
            MainPanel2.this._packageButton.setIcon(packageIcon);
        }
    }

    private static final class PiperFileView
    extends FileView {
        private Icon _piperIcon = null;

        private PiperFileView() {
            SwingUtilities.invokeLater(new FileIconLoader());
        }

        @Override
        public String getTypeDescription(File file) {
            String name = file.getName();
            if (name.endsWith(".piper")) {
                return "Pipeline Definition (Piper) file.";
            }
            return super.getTypeDescription(file);
        }

        @Override
        public Icon getIcon(File file) {
            String name = file.getName();
            if (name.endsWith(".piper") && this._piperIcon != null) {
                return this._piperIcon;
            }
            return super.getIcon(file);
        }

        private final class FileIconLoader
        implements Runnable {
            private FileIconLoader() {
            }

            @Override
            public void run() {
                String dir = "org/apache/ctakes/gui/pipeline/icon/";
                String piperPng = "PiperFile.png";
                PiperFileView.this._piperIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/PiperFile.png");
            }
        }
    }

    private class PiperFileRunner
    implements Runnable {
        private PiperFileRunner() {
        }

        @Override
        public void run() {
            JFrame frame = (JFrame)SwingUtilities.getRoot(MainPanel2.this);
            frame.setCursor(Cursor.getPredefinedCursor(3));
            DisablerPane.getInstance().setVisible(true);
            try {
                String[] lines;
                PiperFileReader reader = new PiperFileReader();
                String text = MainPanel2.this._piperDocument.getText(0, MainPanel2.this._piperDocument.getLength());
                for (String line : lines = text.split("\\n")) {
                    reader.parsePipelineLine(line);
                }
                reader.getBuilder().run();
            }
            catch (Throwable t) {
                LOGGER.error((Object)"Pipeline Run caused Exception:", t);
            }
            DisablerPane.getInstance().setVisible(false);
            frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private final class RunAction
    implements ActionListener {
        private RunAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MainPanel2.this._piperTextFilter == null || MainPanel2.this._runButton == null) {
                return;
            }
            LOGGER.info((Object)"Running Piper File ...");
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.execute(new PiperFileRunner());
            executor.shutdown();
        }
    }

    private final class ValidateAction
    implements ActionListener {
        private ValidateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MainPanel2.this._piperTextFilter == null || MainPanel2.this._runButton == null) {
                return;
            }
            LOGGER.info((Object)"Validating Piper File ...");
            boolean valid = MainPanel2.this._piperTextFilter.validateText();
            MainPanel2.this._runButton.setEnabled(valid);
            LOGGER.info((Object)"Validation Complete.");
        }
    }

    private static final class HelpAction
    implements ActionListener {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel("Dependency and Product Types."), "North");
            JList<PipeBitInfo.TypeProduct> list = new JList<PipeBitInfo.TypeProduct>(new TypeProductListModel());
            list.setCellRenderer(new TypeProductRenderer());
            panel.add(list, "Center");
            panel.add((Component)new JLabel("Types are associated with Pipe Bits."), "South");
            JOptionPane.showMessageDialog(null, panel, "Type Products Help", -1, null);
        }
    }

    private final class SavePiperAction
    implements ActionListener {
        private SavePiperAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MainPanel2.this._piperDocument.getLength() == 0) {
                return;
            }
            int option = MainPanel2.this._chooser.showSaveDialog(null);
            if (option != 0) {
                return;
            }
            File file = MainPanel2.this._chooser.getSelectedFile();
            try {
                String path = file.getPath();
                if (!path.endsWith(".piper")) {
                    path = path + ".piper";
                }
                String text = MainPanel2.this._piperDocument.getText(0, MainPanel2.this._piperDocument.getLength());
                Files.write(Paths.get(path, new String[0]), text.getBytes(), new OpenOption[0]);
            }
            catch (IOException | BadLocationException multE) {
                LOGGER.warn((Object)multE.getMessage());
            }
        }
    }

    private final class OpenPiperAction
    implements ActionListener {
        private OpenPiperAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int option = MainPanel2.this._chooser.showOpenDialog(null);
            if (option != 0) {
                return;
            }
            String text = "";
            File file = MainPanel2.this._chooser.getSelectedFile();
            try {
                text = Files.lines(Paths.get(file.getPath(), new String[0])).collect(Collectors.joining("\n"));
            }
            catch (IOException ioE) {
                LOGGER.error((Object)ioE.getMessage());
                return;
            }
            try {
                MainPanel2.this._piperDocument.remove(0, MainPanel2.this._piperDocument.getLength());
                MainPanel2.this._piperDocument.insertString(0, text, null);
            }
            catch (BadLocationException blE) {
                LOGGER.warn((Object)blE.getMessage());
            }
            MainPanel2.this._runButton.setEnabled(false);
        }
    }

    private final class NewPiperAction
    implements ActionListener {
        private NewPiperAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainPanel2.this.createNewPiper();
        }
    }

    private final class ButtonIconLoader
    implements Runnable {
        private ButtonIconLoader() {
        }

        @Override
        public void run() {
            String dir = "org/apache/ctakes/gui/pipeline/icon/";
            String newPng = "NewPiper.png";
            String openPng = "OpenPiper.png";
            String savePng = "SavePiper.png";
            String validatePng = "RunReady.png";
            String runPng = "RunPiper.png";
            String helpPng = "Help_32.png";
            Icon newIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/NewPiper.png");
            Icon openIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/OpenPiper.png");
            Icon saveIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/SavePiper.png");
            Icon validateIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/RunReady.png");
            Icon runIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/RunPiper.png");
            Icon helpIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/Help_32.png");
            MainPanel2.this._newButton.setIcon(newIcon);
            MainPanel2.this._openButton.setIcon(openIcon);
            MainPanel2.this._saveButton.setIcon(saveIcon);
            MainPanel2.this._validateButton.setIcon(validateIcon);
            MainPanel2.this._runButton.setIcon(runIcon);
            MainPanel2.this._helpButton.setIcon(helpIcon);
        }
    }

    private class PiperBitParser
    implements Runnable {
        private PiperBitParser() {
        }

        @Override
        public void run() {
            JFrame frame = (JFrame)SwingUtilities.getRoot(MainPanel2.this);
            frame.setCursor(Cursor.getPredefinedCursor(3));
            DisablerPane.getInstance().setVisible(true);
            PipeBitFinder.getInstance().scan();
            MainPanel2.this._availablesListModel.setPipeBits(PipeBitFinder.getInstance().getPipeBits());
            DisablerPane.getInstance().setVisible(false);
            frame.setCursor(Cursor.getDefaultCursor());
        }
    }
}

