/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.parameter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterHolder;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterMapper;
import org.apache.log4j.Logger;
import org.apache.uima.fit.descriptor.ConfigurationParameter;

@Immutable
public final class DefaultParameterHolder
implements ParameterHolder {
    private static final Logger LOGGER = Logger.getLogger((String)"DefaultParameterHolder");
    private final List<ConfigurationParameter> _parameters;
    private final Map<ConfigurationParameter, String> _typeMap;

    public DefaultParameterHolder(Class<?> pipeBitClass) {
        this._typeMap = ParameterMapper.createParameterTypeMap(pipeBitClass);
        this._parameters = new ArrayList<ConfigurationParameter>(this._typeMap.keySet());
        this._parameters.sort((p1, p2) -> p1.name().compareToIgnoreCase(p2.name()));
    }

    @Override
    public int getParameterCount() {
        return this._parameters.size();
    }

    @Override
    public ConfigurationParameter getParameter(int index) {
        return this._parameters.get(index);
    }

    @Override
    public String getParameterClass(int index) {
        return this._typeMap.get(this.getParameter(index));
    }

    @Override
    public String getParameterName(int index) {
        return this._parameters.get(index).name();
    }

    @Override
    public String getParameterDescription(int index) {
        return this._parameters.get(index).description();
    }

    @Override
    public boolean isParameterMandatory(int index) {
        return this._parameters.get(index).mandatory();
    }

    @Override
    public String[] getParameterValue(int index) {
        return this._parameters.get(index).defaultValue();
    }
}

