/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cleartk;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.utils.distsem.WordEmbeddings;
import org.apache.ctakes.utils.distsem.WordVector;
import org.apache.ctakes.utils.distsem.WordVectorReader;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.NamedFeatureExtractor1;

public class ContinuousTextExtractor
implements NamedFeatureExtractor1<BaseToken> {
    private int dims;
    private WordEmbeddings words = null;
    private OovStrategy oovStrategy = null;

    public ContinuousTextExtractor(String vecFile) throws CleartkExtractorException {
        this(vecFile, OovStrategy.OOV_FEATURE);
    }

    public ContinuousTextExtractor(String vecFile, OovStrategy oovStrategy) throws CleartkExtractorException {
        try {
            this.words = WordVectorReader.getEmbeddings((InputStream)FileLocator.getAsStream(vecFile));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CleartkExtractorException((Throwable)e);
        }
        this.oovStrategy = oovStrategy;
    }

    public List<Feature> extract(JCas view, BaseToken token) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        String wordText = token.getCoveredText();
        WordVector vec = null;
        if (this.words.containsKey(wordText)) {
            vec = this.words.getVector(wordText);
        } else if (this.words.containsKey(wordText.toLowerCase())) {
            vec = this.words.getVector(wordText.toLowerCase());
        } else {
            if (this.oovStrategy == OovStrategy.OOV_FEATURE) {
                feats.add(new Feature(this.getFeatureName(), (Object)"OOV"));
                return feats;
            }
            if (this.oovStrategy == OovStrategy.EMPTY_VECTOR) {
                vec = new WordVector("_empty_", new double[this.words.getDimensionality()]);
            } else if (this.oovStrategy == OovStrategy.MEAN_VECTOR) {
                vec = this.words.getMeanVector();
            }
        }
        for (int i = 0; i < vec.size(); ++i) {
            feats.add(new Feature(this.getFeatureName() + "_" + i, (Object)vec.getValue(i)));
        }
        return feats;
    }

    public int getEmbeddingsDimensionality() {
        return this.words.getDimensionality();
    }

    public String getFeatureName() {
        return "ContinuousText";
    }

    public static enum OovStrategy {
        OOV_FEATURE,
        EMPTY_VECTOR,
        MEAN_VECTOR;

    }
}

