/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.machine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.condition.WordSetCondition;
import org.apache.ctakes.core.fsm.output.PersonTitleToken;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;

public class PersonTitleFSM {
    Set<String> iv_fullTextSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public PersonTitleFSM() {
        this.iv_fullTextSet.add("mr");
        this.iv_fullTextSet.add("ms");
        this.iv_fullTextSet.add("mrs");
        this.iv_fullTextSet.add("dr");
        this.iv_machineSet.add(this.getTitleMachine());
    }

    private Machine getTitleMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState titleNameState = new NamedState("TITLENAME");
        WordSetCondition titleNameCondition = new WordSetCondition(this.iv_fullTextSet, false);
        PunctuationValueCondition periodCondition = new PunctuationValueCondition('.');
        startState.addTransition(titleNameCondition, titleNameState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        titleNameState.addTransition(periodCondition, endState);
        titleNameState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        return m;
    }

    public Set<PersonTitleToken> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<PersonTitleToken> personTitleSet = new HashSet<PersonTitleToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                PersonTitleToken ptToken = new PersonTitleToken(startToken.getStartOffset(), endToken.getEndOffset());
                personTitleSet.add(ptToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return personTitleSet;
    }
}

