/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;

public class DEPFeat
extends HashMap<String, String> {
    public static final String DELIM_VALUES = ",";
    public static final String DELIM_FEATS = "|";
    public static final String DELIM_KEY_VALUE = "=";
    public static final Pattern P_FEATS = Pattern.compile("\\|");

    public DEPFeat() {
    }

    public DEPFeat(String feats) {
        this.add(feats);
    }

    public void add(String feats) {
        if (feats.equals("_")) {
            return;
        }
        for (String feat : P_FEATS.split(feats)) {
            int idx = feat.indexOf(DELIM_KEY_VALUE);
            if (idx <= 0) continue;
            String key = feat.substring(0, idx);
            String value = feat.substring(idx + 1);
            this.put(key, value);
        }
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "_";
        }
        StringBuilder build = new StringBuilder();
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            build.append(DELIM_FEATS);
            build.append(key);
            build.append(DELIM_KEY_VALUE);
            build.append((String)this.get(key));
        }
        return build.toString().substring(DELIM_FEATS.length());
    }
}

