/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency;

import com.carrotsearch.hppc.IntOpenHashSet;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.ner.NERNode;
import com.googlecode.clearnlp.pos.POSNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class DEPNode
extends NERNode
implements Comparable<DEPNode> {
    public int id;
    protected DEPFeat d_feats;
    protected DEPArc d_head;
    protected List<DEPArc> x_heads;
    protected List<DEPArc> s_heads;
    protected List<DEPArc> l_dependents;
    public boolean b_terminal;

    public DEPNode() {
    }

    public DEPNode(int id, String form, String lemma, String pos, DEPFeat feats) {
        this.init(id, form, lemma, pos, feats);
    }

    public DEPNode(int id, String form) {
        this.init(id, form, null, null, new DEPFeat());
    }

    public DEPNode(int id, POSNode node) {
        this.init(id, node.form, node.lemma, node.pos, new DEPFeat());
    }

    public void initRoot() {
        this.init(0, "_R_", "_R_", "_R_", new DEPFeat());
    }

    public void init(int id, String form, String lemma, String pos, DEPFeat feats) {
        this.id = id;
        this.form = form;
        this.lemma = lemma;
        this.pos = pos;
        this.nament = "_";
        this.d_feats = feats;
        this.d_head = new DEPArc();
    }

    public boolean isRoot() {
        DEPNode head = this.getHead();
        return head != null && head.id == 0;
    }

    public String getFeat(String key) {
        return (String)this.d_feats.get(key);
    }

    public void addFeat(String key, String value) {
        this.d_feats.put(key, value);
    }

    public void removeFeat(String key) {
        this.d_feats.remove(key);
    }

    public void setFeats(DEPFeat feats) {
        this.d_feats = feats;
    }

    public String getLabel() {
        return this.d_head.label;
    }

    public void setLabel(String label) {
        this.d_head.setLabel(label);
    }

    public boolean isLabel(String label) {
        return this.d_head.label != null && this.d_head.isLabel(label);
    }

    public DEPNode getHead() {
        return this.d_head.node;
    }

    public void setHead(DEPNode head) {
        this.d_head.setNode(head);
    }

    public void setHead(DEPNode head, String label) {
        this.d_head.set(head, label);
    }

    public boolean hasHead() {
        return this.d_head.node != null;
    }

    public void clearHead() {
        this.d_head.clear();
    }

    public DEPNode getGrandHead() {
        DEPNode head = this.getHead();
        return head == null ? null : head.getHead();
    }

    public boolean isDependentOf(DEPNode node) {
        return this.d_head.isNode(node);
    }

    public boolean isSiblingOf(DEPNode node) {
        return node.isDependentOf(this.getHead());
    }

    public boolean isDescendentOf(DEPNode node) {
        for (DEPNode head = this.getHead(); head != null; head = head.getHead()) {
            if (head != node) continue;
            return true;
        }
        return false;
    }

    public List<DEPArc> getSHeads() {
        return this.s_heads;
    }

    public void setSHeads(List<DEPArc> sHeads) {
        this.s_heads = sHeads;
    }

    public List<DEPArc> getSHeadsByLabel(String label) {
        ArrayList<DEPArc> sHeads = new ArrayList<DEPArc>();
        for (DEPArc arc : this.s_heads) {
            if (!arc.isLabel(label)) continue;
            sHeads.add(arc);
        }
        return sHeads;
    }

    public void addSHead(DEPNode head, String label) {
        this.s_heads.add(new DEPArc(head, label));
    }

    public void removeSHeads(Collection<DEPArc> sHeads) {
        this.s_heads.removeAll(sHeads);
    }

    public void removeSHeadsByLabel(String label) {
        this.s_heads.removeAll(this.getSHeadsByLabel(label));
    }

    public boolean containsSHead(DEPNode sHead) {
        for (DEPArc arc : this.s_heads) {
            if (!arc.isNode(sHead)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSHead(String label) {
        for (DEPArc arc : this.s_heads) {
            if (!arc.isLabel(label)) continue;
            return true;
        }
        return false;
    }

    public boolean isArgumentOf(DEPNode sHead) {
        for (DEPArc arc : this.s_heads) {
            if (!arc.isNode(sHead)) continue;
            return true;
        }
        return false;
    }

    public boolean isArgumentOf(DEPNode sHead, String label) {
        for (DEPArc arc : this.s_heads) {
            if (!arc.isNode(sHead) || !arc.isLabel(label)) continue;
            return true;
        }
        return false;
    }

    public List<DEPArc> getDependents() {
        return this.l_dependents;
    }

    public List<DEPNode> getLeftDependents() {
        ArrayList<DEPNode> list = new ArrayList<DEPNode>();
        int size = this.l_dependents.size();
        for (int i = 0; i < size; ++i) {
            DEPArc arc = this.l_dependents.get(i);
            if (arc.getNode().id > this.id) break;
            list.add(arc.getNode());
        }
        return list;
    }

    public List<DEPNode> getRightDependents() {
        ArrayList<DEPNode> list = new ArrayList<DEPNode>();
        for (int i = this.l_dependents.size() - 1; i >= 0; --i) {
            DEPArc arc = this.l_dependents.get(i);
            if (arc.getNode().id < this.id) break;
            list.add(arc.getNode());
        }
        return list;
    }

    public List<DEPArc> getGrandDependents() {
        ArrayList<DEPArc> list = new ArrayList<DEPArc>();
        for (DEPArc arc : this.l_dependents) {
            list.addAll(arc.getNode().getDependents());
        }
        return list;
    }

    public DEPNode getLeftNearestDependent() {
        for (int i = this.l_dependents.size() - 1; i >= 0; --i) {
            DEPArc arc = this.l_dependents.get(i);
            if (arc.getNode().id >= this.id) continue;
            return arc.getNode();
        }
        return null;
    }

    public DEPNode getRightNearestDependent() {
        int size = this.l_dependents.size();
        for (int i = 0; i < size; ++i) {
            DEPArc arc = this.l_dependents.get(i);
            if (arc.getNode().id <= this.id) continue;
            return arc.getNode();
        }
        return null;
    }

    public DEPNode getLeftMostDependent() {
        if (!this.l_dependents.isEmpty()) {
            DEPNode dep = this.l_dependents.get(0).getNode();
            if (dep.id < this.id) {
                return dep;
            }
        }
        return null;
    }

    public DEPNode getRightMostDependent() {
        if (!this.l_dependents.isEmpty()) {
            DEPNode dep = this.l_dependents.get(this.l_dependents.size() - 1).getNode();
            if (dep.id > this.id) {
                return dep;
            }
        }
        return null;
    }

    public List<DEPNode> getDescendents(Pattern regex) {
        ArrayList<DEPNode> desc = new ArrayList<DEPNode>();
        this.getDescendentsAux(this, desc, regex);
        return desc;
    }

    public void getDescendentsAux(DEPNode node, List<DEPNode> desc, Pattern regex) {
        for (DEPArc arc : node.getDependents()) {
            if (!arc.isLabel(regex)) continue;
            this.getDescendentsAux(arc.getNode(), desc, regex);
            desc.add(arc.getNode());
        }
    }

    public List<DEPArc> getDescendents(int depth) {
        ArrayList<DEPArc> list = new ArrayList<DEPArc>();
        this.getDescendentsAux(this, list, depth - 1);
        return list;
    }

    public void getDescendentsAux(DEPNode curr, List<DEPArc> list, int depth) {
        List<DEPArc> deps = curr.getDependents();
        list.addAll(deps);
        if (depth == 0) {
            return;
        }
        for (DEPArc arc : deps) {
            this.getDescendentsAux(arc.getNode(), list, depth - 1);
        }
    }

    public Set<DEPNode> getArgumentCandidateSet(int depth, boolean includeSelf) {
        HashSet<DEPNode> set = new HashSet<DEPNode>();
        for (DEPArc arc : this.getDescendents(depth)) {
            set.add(arc.getNode());
        }
        for (DEPNode head = this.getHead(); head != null; head = head.getHead()) {
            set.add(head);
            for (DEPArc arc : head.getDependents()) {
                set.add(arc.getNode());
            }
        }
        if (includeSelf) {
            set.add(this);
        } else {
            set.remove(this);
        }
        return set;
    }

    public List<DEPNode> getDependentsByLabels(String ... labels) {
        ArrayList<DEPNode> list = new ArrayList<DEPNode>();
        for (DEPArc arc : this.l_dependents) {
            for (String label : labels) {
                if (!arc.isLabel(label)) continue;
                list.add(arc.getNode());
            }
        }
        return list;
    }

    void addDependent(DEPNode node, String label) {
        this.l_dependents.add(new DEPArc(node, label));
    }

    public boolean containsDependent(String label) {
        for (DEPArc node : this.l_dependents) {
            if (!node.isLabel(label)) continue;
            return true;
        }
        return false;
    }

    public IntOpenHashSet getSubtreeIdSet() {
        IntOpenHashSet set = new IntOpenHashSet();
        this.getSubtreeIdSetAux(set, this);
        return set;
    }

    private void getSubtreeIdSetAux(IntOpenHashSet set, DEPNode curr) {
        set.add(curr.id);
        for (DEPArc arc : curr.getDependents()) {
            this.getSubtreeIdSetAux(set, arc.getNode());
        }
    }

    public int[] getSubtreeIdArray() {
        IntOpenHashSet set = this.getSubtreeIdSet();
        int[] list = set.toArray();
        Arrays.sort(list);
        return list;
    }

    public String toStringPOS() {
        StringBuilder build = new StringBuilder();
        build.append(this.form);
        build.append("\t");
        build.append(this.pos);
        build.append("\t");
        build.append(this.d_feats);
        return build.toString();
    }

    public String toStringMorph() {
        StringBuilder build = new StringBuilder();
        build.append(this.form);
        build.append("\t");
        build.append(this.lemma);
        build.append("\t");
        build.append(this.pos);
        return build.toString();
    }

    public String toStringDEP() {
        StringBuilder build = new StringBuilder();
        build.append(this.id);
        build.append("\t");
        build.append(this.form);
        build.append("\t");
        build.append(this.lemma);
        build.append("\t");
        build.append(this.pos);
        build.append("\t");
        build.append(this.d_feats);
        build.append("\t");
        if (this.hasHead()) {
            build.append(this.d_head.node.id);
            build.append("\t");
            build.append(this.d_head.label);
        } else {
            build.append("_");
            build.append("\t");
            build.append("_");
        }
        return build.toString();
    }

    public String toStringCoNLL() {
        StringBuilder build = new StringBuilder();
        build.append(this.id);
        build.append("\t");
        build.append(this.form);
        build.append("\t");
        build.append(this.lemma);
        build.append("\t");
        build.append(this.pos);
        build.append("\t");
        build.append(this.pos);
        build.append("\t");
        build.append("_");
        build.append("\t");
        if (this.hasHead()) {
            build.append(this.d_head.node.id);
            build.append("\t");
            build.append(this.d_head.label);
        } else {
            build.append("_");
            build.append("\t");
            build.append("_");
        }
        return build.toString();
    }

    public String toStringDAG() {
        StringBuilder build = new StringBuilder();
        build.append(this.toStringDEP());
        build.append("\t");
        build.append(this.toString(this.x_heads));
        return build.toString();
    }

    public String toStringSRL() {
        StringBuilder build = new StringBuilder();
        build.append(this.toStringDEP());
        build.append("\t");
        build.append(this.toString(this.s_heads));
        return build.toString();
    }

    @Override
    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.toStringDEP());
        build.append("\t");
        build.append(this.toString(this.x_heads));
        build.append("\t");
        build.append(this.toString(this.s_heads));
        build.append("\t");
        build.append(this.nament);
        return build.toString();
    }

    private String toString(List<DEPArc> heads) {
        StringBuilder build = new StringBuilder();
        Collections.sort(heads);
        for (DEPArc arc : heads) {
            build.append(";");
            build.append(arc.toString());
        }
        if (build.length() > 0) {
            return build.substring(";".length());
        }
        return "_";
    }

    @Override
    public int compareTo(DEPNode node) {
        return this.id - node.id;
    }

    public List<DEPArc> getXHeads() {
        return this.x_heads;
    }

    public Set<DEPNode> getXAncestorSet() {
        HashSet<DEPNode> set = new HashSet<DEPNode>();
        this.getXAncestorIdSetAux(this, set);
        return set;
    }

    private void getXAncestorIdSetAux(DEPNode node, Set<DEPNode> set) {
        for (DEPArc arc : node.x_heads) {
            DEPNode head = arc.getNode();
            set.add(head);
            this.getXAncestorIdSetAux(head, set);
        }
    }

    public DEPArc getXHead(DEPNode head) {
        for (DEPArc arc : this.x_heads) {
            if (!arc.isNode(head)) continue;
            return arc;
        }
        return null;
    }

    public List<DEPArc> getXHeads(String label) {
        ArrayList<DEPArc> list = new ArrayList<DEPArc>();
        for (DEPArc arc : this.x_heads) {
            if (!arc.isLabel(label)) continue;
            list.add(arc);
        }
        return list;
    }

    public void addXHead(DEPNode head, String label) {
        this.x_heads.add(new DEPArc(head, label));
    }

    public boolean hasXHead() {
        return !this.x_heads.isEmpty();
    }

    public boolean isXDescendentOf(DEPNode node) {
        return this.isXDescendentOfAux(this, node);
    }

    private boolean isXDescendentOfAux(DEPNode curr, DEPNode node) {
        for (DEPArc arc : curr.x_heads) {
            if (!arc.isNode(node) && !this.isXDescendentOfAux(arc.getNode(), node)) continue;
            return true;
        }
        return false;
    }

    public boolean containsXHead(DEPNode xHead) {
        for (DEPArc arc : this.x_heads) {
            if (!arc.isNode(xHead)) continue;
            return true;
        }
        return false;
    }
}

