/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.feature.xml;

import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.feature.xml.AbstractFtrXml;
import com.googlecode.clearnlp.util.UTRegex;
import com.googlecode.clearnlp.util.UTXml;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JointFtrXml
extends AbstractFtrXml {
    public static final char S_INPUT = 'i';
    public static final char S_STACK = 's';
    public static final char S_LAMBDA = 'l';
    public static final char S_BETA = 'b';
    public static final char S_PRED = 'p';
    public static final char S_ARG = 'a';
    public static final String R_H = "h";
    public static final String R_H2 = "h2";
    public static final String R_LMD = "lmd";
    public static final String R_RMD = "rmd";
    public static final String R_LMD2 = "lmd2";
    public static final String R_RMD2 = "rmd2";
    public static final String R_LND = "lnd";
    public static final String R_RND = "rnd";
    public static final String R_LNS = "lns";
    public static final String R_RNS = "rns";
    public static final String F_FORM = "f";
    public static final String F_SIMPLIFIED_FORM = "sf";
    public static final String F_LOWER_SIMPLIFIED_FORM = "lsf";
    public static final String F_POS = "p";
    public static final String F_POS_SET = "ps";
    public static final String F_AMBIGUITY_CLASS = "a";
    public static final String F_LEMMA = "m";
    public static final String F_NAMENT = "nt";
    public static final String F_DEPREL = "d";
    public static final String F_LEFT_DEP_POS = "ldp";
    public static final String F_RIGHT_DEP_POS = "rdp";
    public static final String F_LEFT_DEP_DEPREL = "ldd";
    public static final String F_RIGHT_DEP_DEPREL = "rdd";
    public static final String F_DIRECTION = "dir";
    public static final String F_DISTANCE = "n";
    public static final String F_DEPREL_SET = "ds";
    public static final String F_GRAND_DEPREL_SET = "gds";
    public static final String F_LEFT_VALENCY = "lv";
    public static final String F_RIGHT_VALENCY = "rv";
    public static final String F_LNPL = "lnpl";
    public static final String F_RNPL = "rnpl";
    public static final String F_LNPB = "lnpb";
    public static final String F_RNPB = "rnpb";
    public static final Pattern P_BOOLEAN = Pattern.compile("^b(\\d+)$");
    public static final Pattern P_PREFIX = Pattern.compile("^pf(\\d+)$");
    public static final Pattern P_SUFFIX = Pattern.compile("^sf(\\d+)$");
    public static final Pattern P_FEAT = Pattern.compile("^ft=(.+)$");
    public static final Pattern P_SUBCAT = Pattern.compile("^sc([pd])(\\d+)$");
    public static final Pattern P_PATH = Pattern.compile("^pt([pdn])(\\d+)$");
    public static final Pattern P_ARGN = Pattern.compile("^argn(\\d+)$");
    protected static final Pattern P_REL = UTRegex.getORPattern("h", "h2", "lmd", "rmd", "lmd2", "rmd2", "lnd", "rnd", "lns", "rns");
    protected static final Pattern P_FIELD = UTRegex.getORPattern("f", "sf", "lsf", "m", "p", "ps", "a", "nt", "d", "dir", "n", "ds", "lv", "rv", "lnpl", "rnpl", "lnpb", "rnpb", "ldp", "rdp", "ldd", "rdd");
    final String CUTOFF_AMBIGUITY = "ambiguity";
    final String CUTOFF_DOCUMENT_FREQUENCY = "df";
    final String CUTOFF_PATH_DOWN = "down";
    final String CUTOFF_PATH_UP = "up";
    final String LEXICA_PUNCTUATION = "punctuation";
    final String LEXICA_PREDICATE = "predicate";
    double cutoff_ambiguity;
    int cutoff_df;
    int cutoff_pathDown;
    int cutoff_pathUp;
    StringIntPair p_punc;
    Pattern p_predicates;

    public JointFtrXml(InputStream fin) {
        super(fin);
    }

    public double getAmbiguityClassThreshold() {
        return this.cutoff_ambiguity;
    }

    public int getDocumentFrequencyCutoff() {
        return this.cutoff_df;
    }

    public int getPathDownCutoff() {
        return this.cutoff_pathDown;
    }

    public int getPathUpCutoff() {
        return this.cutoff_pathUp;
    }

    public int getPunctuationCutoff() {
        return this.p_punc.i;
    }

    public String getPunctuationLabel() {
        return this.p_punc.s;
    }

    public boolean isPredicate(DEPNode node) {
        return this.p_predicates.matcher(node.pos).find();
    }

    @Override
    protected void initCutoffMore(NodeList eList) {
        Element eCutoff = (Element)eList.item(0);
        this.cutoff_ambiguity = eCutoff.hasAttribute("ambiguity") ? Double.parseDouble(eCutoff.getAttribute("ambiguity")) : 0.0;
        this.cutoff_df = eCutoff.hasAttribute("df") ? Integer.parseInt(eCutoff.getAttribute("df")) : 0;
        this.cutoff_pathDown = eCutoff.hasAttribute("down") ? Integer.parseInt(eCutoff.getAttribute("down")) : 0;
        this.cutoff_pathUp = eCutoff.hasAttribute("up") ? Integer.parseInt(eCutoff.getAttribute("up")) : 0;
    }

    @Override
    protected void initMore(Document doc) throws Exception {
        this.initMoreLexica(doc);
    }

    private void initMoreLexica(Document doc) {
        NodeList eList = doc.getElementsByTagName("lexica");
        int size = eList.getLength();
        this.p_punc = new StringIntPair("", 0);
        for (int i = 0; i < size; ++i) {
            Element eLexica = (Element)eList.item(i);
            String type = UTXml.getTrimmedAttribute(eLexica, "type");
            String label = UTXml.getTrimmedAttribute(eLexica, "label");
            int cutoff = Integer.parseInt(UTXml.getTrimmedAttribute(eLexica, "cutoff"));
            if (type.equals("punctuation")) {
                this.p_punc.set(label, cutoff);
                continue;
            }
            if (!type.equals("predicate")) continue;
            this.p_predicates = Pattern.compile("^" + label + "$");
        }
    }

    @Override
    protected boolean validSource(char source) {
        return source == 'i' || source == 's' || source == 'l' || source == 'b' || source == 'p' || source == 'a';
    }

    @Override
    protected boolean validRelation(String relation) {
        return P_REL.matcher(relation).matches();
    }

    @Override
    protected boolean validField(String field) {
        return P_FIELD.matcher(field).matches() || P_BOOLEAN.matcher(field).matches() || P_PREFIX.matcher(field).matches() || P_SUFFIX.matcher(field).matches() || P_FEAT.matcher(field).matches() || P_SUBCAT.matcher(field).matches() || P_PATH.matcher(field).matches() || P_ARGN.matcher(field).matches();
    }
}

