/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.predicate.AbstractPredIdentifier;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.UTXml;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class PredPredict
extends AbstractRun {
    @Option(name="-i", usage="input path (required)", required=true, metaVar="<filepath>")
    private String s_inputPath;
    @Option(name="-ie", usage="input file extension (default: .*)", required=false, metaVar="<regex>")
    private String s_inputExt = ".*";
    @Option(name="-oe", usage="output file extension (default: pred)", required=false, metaVar="<string>")
    private String s_outputExt = "pred";
    @Option(name="-c", usage="configuration file (required)", required=true, metaVar="<filename>")
    private String s_configXml;
    @Option(name="-m", usage="model file (required)", required=true, metaVar="<filename>")
    private String s_modelFile;

    public PredPredict() {
    }

    public PredPredict(String[] args) {
        this.initArgs(args);
        try {
            Element eConfig = UTXml.getDocumentElement(new FileInputStream(this.s_configXml));
            List<String[]> filenames = this.getFilenames(this.s_inputPath, this.s_inputExt, this.s_outputExt);
            DEPReader reader = (DEPReader)this.getReader((Element)eConfig).o1;
            AbstractPredIdentifier identifier = EngineGetter.getPredIdentifier(this.s_modelFile);
            for (String[] io : filenames) {
                this.predict(identifier, reader, io[0], io[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void predict(AbstractPredIdentifier identifier, DEPReader fin, String inputFile, String outputFile) {
        DEPTree tree;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((tree = fin.next()) != null) {
            identifier.identify(tree);
            fout.println(tree.toStringDEP() + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public static void main(String[] args) {
        new PredPredict(args);
    }
}

