/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.datetimeentry;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.icefaces.component.datetimeentry.DateTimeEntryBase;
import org.icefaces.component.utils.Utils;
import org.icefaces.impl.util.Util;

public class DateTimeEntry
extends DateTimeEntryBase {
    public DateTimeConverter resolveDateTimeConverter(FacesContext context) {
        Converter appConverter;
        DateTimeConverter converter = null;
        Converter compConverter = this.getConverter();
        converter = compConverter instanceof DateTimeConverter ? (DateTimeConverter)compConverter : ((appConverter = context.getApplication().createConverter(Date.class)) instanceof DateTimeConverter ? (DateTimeConverter)appConverter : new DateTimeConverter());
        return converter;
    }

    public TimeZone resolveTimeZone(FacesContext context) {
        DateTimeConverter converter = this.resolveDateTimeConverter(context);
        TimeZone tz = converter.getTimeZone();
        if (tz == null) {
            tz = TimeZone.getTimeZone("GMT");
        }
        return tz;
    }

    public Locale resolveLocale(FacesContext context) {
        return context.getViewRoot().getLocale();
    }

    public static String getDateTimeConverterPattern(DateTimeConverter converter) {
        DateFormat df;
        Locale locale = converter.getLocale();
        String pattern = converter.getPattern();
        String type = converter.getType();
        String dateStyle = converter.getDateStyle();
        String timeStyle = converter.getTimeStyle();
        if (pattern != null) {
            df = new SimpleDateFormat(pattern, locale);
        } else if (type.equals("both")) {
            df = DateFormat.getDateTimeInstance(DateTimeEntry.getDateTimeConverterStyle(dateStyle), DateTimeEntry.getDateTimeConverterStyle(timeStyle), locale);
        } else if (type.equals("date")) {
            df = DateFormat.getDateInstance(DateTimeEntry.getDateTimeConverterStyle(dateStyle), locale);
        } else if (type.equals("time")) {
            df = DateFormat.getTimeInstance(DateTimeEntry.getDateTimeConverterStyle(timeStyle), locale);
        } else {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        df.setLenient(false);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        return "";
    }

    private static int getDateTimeConverterStyle(String name) {
        if ("short".equals(name)) {
            return 3;
        }
        if ("medium".equals(name)) {
            return 2;
        }
        if ("long".equals(name)) {
            return 1;
        }
        if ("full".equals(name)) {
            return 0;
        }
        return 2;
    }

    public boolean isSingleSubmit() {
        return Utils.superValueIfSet((UIComponent)this, this.getStateHelper(), DateTimeEntryBase.PropertyKeys.singleSubmit.name(), super.isSingleSubmit(), Util.withinSingleSubmit((UIComponent)this));
    }
}

